/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import ru.blok.vms.calltransport.ui.SoundItem;
import ru.blok.vms.calltransport.ui.SoundPainter;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapPropertiesUItrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Primitive;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.TrackNDData;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.ParkingPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.Utils;
import ru.blok.vms.ui.tracks.TrackAllWithPeriods;
import ru.blok.vms.ui.tracks.TrackInRealTime2;
import ru.infor.common.SysProperties;
import ru.infor.gpx.Trkpt;
import ru.infor.ws.objects.draw.entities.TrackLineUI;
import ru.infor.ws.objects.draw.entities.TrackPointUI;
import ru.infor.ws.objects.draw.entities.TrackUI;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.Route;

public class NodePainterDataTraclAll<T extends JXMapViewer>
extends MapViewPainter<T> {
    protected static double accuracyOfPaint = 8.0;
    private List<TrackAllWithPeriods.Period> parkingPoints = null;
    List<SoundItem> listSoundItems;
    private ParkingPainter<JXMapViewer> pp = null;
    SoundPainter<JXMapViewer> soundPainter;
    protected MapValueWithTrack value;
    public List<Trkpt> listTrkpts;
    public List<SoundItem> soundItems;
    protected HashMap<TrackNDData, HashMap<Integer, Polygon>> mapV = new HashMap();

    public List<SoundItem> getListSoundItems() {
        return this.listSoundItems;
    }

    public void setListSoundItems(List<SoundItem> listSoundItems) {
        this.listSoundItems = listSoundItems;
    }

    public List<TrackAllWithPeriods.Period> getParkingPoints() {
        return this.parkingPoints;
    }

    public void setParkingPoints(List<TrackAllWithPeriods.Period> parkingPoints) {
        this.parkingPoints = parkingPoints;
    }

    public ParkingPainter<JXMapViewer> getPp() {
        return this.pp;
    }

    public void setPp(ParkingPainter<JXMapViewer> pp) {
        this.pp = pp;
    }

    public SoundPainter<JXMapViewer> getSoundPainter() {
        return this.soundPainter;
    }

    public void setSoundPainter(SoundPainter<JXMapViewer> soundPainter) {
        this.soundPainter = soundPainter;
    }

    public NodePainterDataTraclAll() {
        this.setAntialiasing(true);
        this.setCacheable(false);
        accuracyOfPaint = Double.parseDouble(SysProperties.getProperty((String)"AccuracyOfPaint", (String)"8.0"));
    }

    public List<TrackNDData> getTracks() {
        return this.value.getTracksNDData();
    }

    public Integer include(TrackNDData d, Point2D pClick) {
        HashMap<Integer, Polygon> lp = this.mapV.get(d);
        if (lp != null) {
            for (Integer i : lp.keySet()) {
                Polygon p = lp.get(i);
                if (p == null || !p.contains(pClick)) continue;
                return i;
            }
        }
        return null;
    }

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        TrackNDData trackLast = null;
        this.listTrkpts = new ArrayList<Trkpt>();
        this.soundItems = new ArrayList<SoundItem>();
        if (this.pp != null) {
            this.pp.setList(this.listTrkpts);
        }
        if (this.soundPainter != null) {
            this.soundPainter.setListSoundItems(this.soundItems);
        }
        if (this.getTracks() != null) {
            int j = 0;
            while (j < this.getTracks().size()) {
                TrackNDData t = this.getTracks().get(j);
                if (t.isVisible()) {
                    if (t.getMapValueWithTrack() != null && t.getMapValueWithTrack().getSelectTrack() != null && t.getId() == t.getMapValueWithTrack().getSelectTrack().longValue()) {
                        trackLast = t;
                    } else {
                        this.paintTrack(t, map, g, vp2, vp3);
                    }
                }
                ++j;
            }
        }
        if (trackLast != null) {
            this.paintTrack(trackLast, map, g, vp2, vp3);
        }
        if (this.pp != null) {
            this.pp.paint(g, map, width, height);
        }
        if (this.soundPainter != null) {
            this.soundPainter.paint(g, map, width, height);
        }
    }

    protected void paintTrack(TrackNDData t, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Color cr = Color.RED;
        HashMap<Integer, Polygon> lp = new HashMap<Integer, Polygon>();
        if (!t.getNodes().isEmpty()) {
            Route r;
            boolean selFrom;
            Color c;
            int s = t.getNodes().size();
            Object trUI = ((MapPropertiesUItrack)this.value.mapViewerWithTrack.getUIProperties()).getTrackUI();
            if (trUI == null) {
                trUI = new TrackUI();
                trUI.setShowLine(Integer.valueOf(1));
                trUI.setShowPoint(Integer.valueOf(0));
                TrackLineUI lUI = new TrackLineUI();
                lUI.setColorLine(Integer.valueOf(Color.RED.getRGB()));
                lUI.setWidth(Float.valueOf(2.0f));
                lUI.setOpaque(Integer.valueOf(255));
                trUI.setLineUI(lUI);
            }
            if (trUI.getLineUI() != null && trUI.getLineUI().getColorLine() != null) {
                cr = new Color(trUI.getLineUI().getColorLine());
            }
            if ((c = (Color)t.getParameter("Color")) != null) {
                cr = c;
                trUI.getLineUI().setColorLine(Integer.valueOf(c.getRGB()));
            }
            Integer[] sel = t.getSelectedPath();
            int selb = -1;
            int sele = -1;
            if (sel != null) {
                selb = sel[0];
                sele = sel[1];
            }
            ArrayList<Integer> selPoint = new ArrayList<Integer>();
            if (sel != null) {
                selb = sel[0];
                sele = sel[1];
            }
            if (t.getSelectedPoint() != null) {
                Integer[] integerArray = t.getSelectedPoint();
                int n = integerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer i = integerArray[n2];
                    selPoint.add(i);
                    ++n2;
                }
            }
            int from = 0;
            if (t.isOnlyCurrent()) {
                from = selb;
                s = sele + 1;
            }
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(t.getNodes().get(from).getLat().doubleValue(), t.getNodes().get(from).getLon().doubleValue()), map.getZoom());
            this.paintpath(t, g, vp2, vp3, from, s, (JXMapViewer)map, pointFrom, selb, sele, (List<Integer>)selPoint, lp, (TrackUI)trUI);
            from = s - 1;
            boolean bl = selFrom = from >= selb && from < sele;
            if (trUI.getShowPoint().equals(1)) {
                if (vp2.contains(pointFrom)) {
                    this.paintPoint((JXMapViewer)map, g, trUI.getPointUI(), pointFrom, t.getNodes().get(from), vp2, selFrom, true);
                } else if (vp3.contains(pointFrom)) {
                    this.paintPoint((JXMapViewer)map, g, trUI.getPointUI(), pointFrom, t.getNodes().get(from), vp3, selFrom, true);
                }
            }
            g.setStroke(Primitive.defaultStroke);
            if (t.getCurrent() != null && s > t.getCurrent()) {
                this.paintFlag(t.getNodes().get(t.getCurrent()), map, g, vp2, vp3);
            }
            if ((r = t.getRoute()) != null && r.getAreaRouteGeom() != null) {
                try {
                    this.paintRoute(r, map, g, vp2, t);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (t.getListGeometry() != null) {
            for (Geometry g1 : t.getListGeometry()) {
                this.paintPolygon(g1, (JXMapViewer)map, g, vp2, vp3, cr, 50);
            }
        }
        this.mapV.put(t, lp);
        if (this.pp != null) {
            this.pp.removeAllObstacle();
            for (TrackAllWithPeriods.Period tp : this.parkingPoints) {
                if (tp.getId() == t.getId() && tp.getTrkpt() != null) {
                    this.listTrkpts.add(tp.getTrkpt());
                    if (tp.getBegin() < t.getNodes().size()) {
                        this.pp.addObstacle(tp.getTrkpt());
                    }
                }
                if (tp.getId() != t.getId() || tp.getTrkptstatus() == null) continue;
                this.listTrkpts.add(tp.getTrkptstatus());
                if (tp.getBegin() >= t.getNodes().size()) continue;
                this.pp.addObstacle(tp.getTrkptstatus());
            }
        }
        if (this.soundPainter != null) {
            ArrayList<SoundItem> l = new ArrayList<SoundItem>();
            for (SoundItem i : this.listSoundItems) {
                this.soundItems.add(i);
                if (i.getIndex() >= t.getNodes().size()) continue;
                l.add(i);
            }
            this.soundPainter.setListSoundItems(l);
        }
    }

    public void paintpath(TrackNDData t, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, int from, int s, JXMapViewer map, Point2D pointFrom, int selb, int sele, List<Integer> selPoint, HashMap<Integer, Polygon> lp, TrackUI trUI) {
        int k = from + 3;
        int i = from + 1;
        while (i < s) {
            boolean selEnd;
            Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(t.getNodes().get(i).getLat().doubleValue(), t.getNodes().get(i).getLon().doubleValue()), map.getZoom());
            double d = pointFrom.distance(pointTo);
            boolean selFrom = !t.isOnlyCurrent() && from >= selb && from < sele;
            boolean bl = selEnd = !t.isOnlyCurrent() && i >= selb && i < sele;
            if (d > accuracyOfPaint || selFrom != selEnd || i == from + 1 || i == s - 1) {
                lp.put(i - 1, this.paint(t.getNodes().get(i - 1), t.getNodes().get(i), pointFrom, pointTo, map, g, vp2, vp3, selFrom, selPoint.contains(from), trUI, k % 7 == 0));
                from = i;
                pointFrom = pointTo;
                ++k;
            } else if (selPoint.contains(i) && trUI.getShowPoint().equals(1)) {
                this.paintPoint(map, g, trUI.getPointUI(), pointFrom, t.getNodes().get(from), vp2, selFrom, selPoint.contains(from));
                from = i;
                pointFrom = pointTo;
            }
            ++i;
        }
    }

    public void paintPolygon(Geometry polygon, JXMapViewer map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, int k) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), k);
        if (polygon instanceof MultiPolygon) {
            org.postgis.Polygon[] polygonArray = ((MultiPolygon)polygon).getPolygons();
            int n = polygonArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.postgis.Polygon p2 = polygonArray[n2];
                Polygon pp = new Polygon();
                int i = 0;
                while (i < p2.numPoints()) {
                    Point p = p2.getPoint(i);
                    Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p.y, p.x), map.getZoom());
                    pp.addPoint((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()));
                    ++i;
                }
                g.setColor(cc);
                g.fillPolygon(pp);
                ++n2;
            }
        } else {
            Polygon pp = new Polygon();
            int i = 0;
            while (i < polygon.numPoints()) {
                Point p = polygon.getPoint(i);
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p.y, p.x), map.getZoom());
                pp.addPoint((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()));
                ++i;
            }
            g.setColor(cc);
            g.drawPolygon(pp);
            g.fillPolygon(pp);
        }
    }

    public Polygon getPolygonGP() {
        Polygon p = new Polygon();
        p.addPoint(17, -15);
        p.addPoint(0, 15);
        p.addPoint(-17, -15);
        return p;
    }

    protected void paintRoute(Route r, T map, Graphics2D g, Rectangle2D vp2, TrackNDData t) throws SQLException {
        if (r != null && r.getAreaRouteGeom() != null) {
            Object currentPolygon = null;
            currentPolygon = r.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(r.getAreaRouteGeom()) : new org.postgis.Polygon(r.getAreaRouteGeom());
            RoutePainter.paintPolygon((Geometry)currentPolygon, map, g, vp2, Color.RED, 150);
        }
    }

    protected void paintPoint(JXMapViewer map, Graphics2D g, TrackPointUI p, Point2D point, AbstractNDData data, Rectangle2D vp, boolean select, boolean selectFrom) {
        Color colorLine = new Color(Utils.getColorWithConditions(data, null, p.getColorLineConditions(), p.getColorLine()));
        Color colorFill = new Color(Utils.getColorWithConditions(data, null, p.getColorFillConditions(), p.getColorFill()));
        int opaque = Utils.getIntegerWithConditions(data, null, p.getOpaqueConditions(), p.getOpaque());
        int diameter = Utils.getIntegerWithConditions(data, null, p.getDiameterConditions(), p.getDiameter());
        Color w = new Color(colorLine.getRed(), colorLine.getGreen(), colorLine.getBlue(), opaque);
        if (select || selectFrom) {
            w = w.darker().darker();
        }
        if (selectFrom) {
            diameter *= 2;
        }
        g.setColor(w);
        g.setStroke(new BasicStroke());
        g.drawOval((int)(point.getX() - vp.getX() - (double)(diameter / 2)), (int)(point.getY() - vp.getY() - (double)(diameter / 2)), diameter, diameter);
        w = new Color(colorFill.getRed(), colorFill.getGreen(), colorFill.getBlue(), opaque);
        g.setColor(w);
        g.fillOval((int)(point.getX() - vp.getX() - (double)(diameter / 2)), (int)(point.getY() - vp.getY() - (double)(diameter / 2)), diameter, diameter);
    }

    protected Polygon paintLine(JXMapViewer map, Graphics2D g, TrackLineUI tUI, AbstractNDData data1, AbstractNDData data2, Point2D point1, Point2D point2, Rectangle2D vp, boolean select, boolean st) {
        Color c = new Color(Utils.getColorWithConditions(data1, data2, tUI.getColorConditions(), tUI.getColorLine()));
        float w = Utils.getFloatWithConditions(data1, data2, tUI.getWidthConditions(), tUI.getWidth()).floatValue();
        Float[] d = Utils.getFloatArrayWithConditions(data1, data2, tUI.getDashConditions(), tUI.getDash());
        Integer o = Utils.getIntegerWithConditions(data1, data2, tUI.getOpaqueConditions(), tUI.getOpaque());
        float[] ff = null;
        if (d != null) {
            ff = new float[d.length];
            int i = 0;
            while (i < d.length) {
                ff[i] = d[i].floatValue();
                ++i;
            }
        }
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), o);
        if (select) {
            cc = cc.darker().darker();
            w += 5.0f;
        }
        BasicStroke s = new BasicStroke(w, 1, 0, 10.0f, ff, 0.0f);
        g.setColor(cc);
        g.setStroke(s);
        g.drawLine((int)(point1.getX() - vp.getX()), (int)(point1.getY() - vp.getY()), (int)(point2.getX() - vp.getX()), (int)(point2.getY() - vp.getY()));
        Polygon p1 = new Polygon();
        p1.addPoint((int)(point2.getX() - 5.0), (int)(point2.getY() + 5.0));
        p1.addPoint((int)(point2.getX() + 5.0), (int)(point2.getY() - 5.0));
        p1.addPoint((int)(point1.getX() + 5.0), (int)(point1.getY() - 5.0));
        p1.addPoint((int)(point1.getX() - 5.0), (int)(point1.getY() + 5.0));
        if (st) {
            Double angle = TrackInRealTime2.getAngle(data1, data2);
            this.paintS(g, point2, angle, cc, cc.darker().darker(), vp);
        }
        return p1;
    }

    protected Polygon paint(AbstractNDData from, AbstractNDData to, Point2D pointFrom, Point2D point, JXMapViewer map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, boolean select, boolean selectFrom, TrackUI trUI, boolean s) {
        TrackPointUI p = null;
        TrackLineUI tUI = null;
        if (trUI.getShowPoint().equals(1)) {
            p = trUI.getPointUI();
            if (vp2.contains(pointFrom)) {
                this.paintPoint(map, g, p, pointFrom, from, vp2, select, selectFrom);
            }
            if (vp3.contains(pointFrom)) {
                this.paintPoint(map, g, p, pointFrom, from, vp3, select, selectFrom);
            }
        }
        Polygon p1 = null;
        if (trUI.getShowLine().equals(1)) {
            tUI = trUI.getLineUI();
            if (vp2.contains(point) || vp2.contains(pointFrom)) {
                p1 = this.paintLine(map, g, tUI, from, to, pointFrom, point, vp2, select, s);
            }
            if (vp3.contains(point) || vp3.contains(pointFrom)) {
                p1 = this.paintLine(map, g, tUI, from, to, pointFrom, point, vp3, select, s);
            }
        }
        return p1;
    }

    protected void paintS(Graphics2D g, Point2D point2, Double angle, Color cl, Color cz, Rectangle2D vp) {
        if (angle != null && angle > 0.0) {
            int x = (int)(point2.getX() - vp.getX());
            int y = (int)(point2.getY() - vp.getY());
            g.translate(x, y);
            g.rotate(Math.toRadians(angle + 180.0));
            Polygon p = new Polygon();
            p.addPoint(0, 8);
            p.addPoint(-3, 0);
            p.addPoint(0, 2);
            p.addPoint(3, 0);
            p.addPoint(0, 8);
            Color c2 = cl.brighter().brighter();
            g.setColor(c2);
            g.drawPolygon(p);
            g.setColor(cz);
            g.fillPolygon(p);
            g.rotate(-Math.toRadians(angle + 180.0));
            g.translate(-x, -y);
        }
    }

    public void paintFlag(AbstractNDData current, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(current.getLat().doubleValue(), current.getLon().doubleValue()), map.getZoom());
        int x = (int)(pointFrom.getX() - vp2.getX());
        int y = (int)(pointFrom.getY() - vp2.getY());
        g.translate(x, y);
        this.paintFlag(g);
        g.translate(-x, -y);
    }

    public void paintFlag(Graphics2D g) {
        Polygon p = new Polygon();
        p.addPoint(0, 0);
        p.addPoint(0, -25);
        p.addPoint(10, -20);
        p.addPoint(0, -15);
        g.setColor(Color.BLUE);
        g.drawPolygon(p);
        g.fillPolygon(p);
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueWithTrack)mapValueWithTrack;
    }
}

