/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.infor.gpx.Trkpt;

public class ObstaclePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    private List<Trkpt> list = null;

    public int getMaxZoomForShow() {
        return 5;
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        if (zoom <= this.getMaxZoomForShow()) {
            Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
            int tileSize = map.getTileFactory().getTileSize(zoom);
            Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
            double vpx = viewportBounds.getX();
            while (vpx < 0.0) {
                vpx += sizeInPixels.getWidth();
            }
            while (vpx > sizeInPixels.getWidth()) {
                vpx -= sizeInPixels.getWidth();
            }
            Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
            Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
            if (this.list != null && this.list.size() > 0) {
                int i = 0;
                while (i < this.list.size()) {
                    int y;
                    int x;
                    Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(this.list.get(i).getLat(), this.list.get(i).getLon()), map.getZoom());
                    if (vp2.contains(point)) {
                        x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                        y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                        g.translate(x, y);
                        this.paintNode(g, (JXMapViewer)map, zoom, this.list.get(i).getType(), this.list.get(i));
                        g.translate(-x, -y);
                    }
                    if (vp3.contains(point)) {
                        x = (int)(point.getX() - ((RectangularShape)vp3).getX());
                        y = (int)(point.getY() - ((RectangularShape)vp3).getY());
                        g.translate(x, y);
                        this.paintNode(g, (JXMapViewer)map, zoom, this.list.get(i).getType(), this.list.get(i));
                        g.translate(-x, -y);
                    }
                    ++i;
                }
            }
        }
    }

    public void addObstacle(Trkpt data) {
        if (this.list == null) {
            this.list = new ArrayList<Trkpt>();
        }
        this.list.add(data);
    }

    public void addObstacle(GeoPosition data) {
        Trkpt t = new Trkpt(data.getLatitude(), data.getLongitude(), null);
        this.addObstacle(t);
    }

    public void removeObstacle(Trkpt data) {
        if (this.list == null) {
            return;
        }
        int i = 0;
        while (i < this.list.size()) {
            Trkpt cur = this.list.get(i);
            if (cur.equals(data)) {
                this.list.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeAllObstacle() {
        if (this.list == null) {
            return;
        }
        this.list.clear();
    }

    public List<Trkpt> getList() {
        return this.list;
    }

    public void setList(List<Trkpt> list) {
        this.list = list;
    }

    public boolean paintNode(Graphics2D g, JXMapViewer ma, int zoom, int type, Trkpt tt) {
        int radius = 25 - zoom * 3;
        g.setColor(Color.RED);
        g.fillOval(-radius / 2, -radius / 2, radius, radius);
        g.setColor(Color.WHITE);
        g.fillRect((int)((double)(-radius) * 0.3), (int)((double)(-radius) * 0.1), (int)((double)radius * 0.6), (int)((double)radius * 0.2));
        return false;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

