/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class RectanglePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    private GeoPosition point1 = null;
    private GeoPosition point2 = null;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.point1 != null && this.point2 != null) {
            int y;
            int x;
            Point2D p1 = map.getTileFactory().geoToPixel(this.point1, map.getZoom());
            Point2D p2 = map.getTileFactory().geoToPixel(this.point2, map.getZoom());
            if (vp2.contains(p1)) {
                x = (int)(p1.getX() - ((RectangularShape)vp2).getX());
                y = (int)(p1.getY() - ((RectangularShape)vp2).getY());
                g.translate(x, y);
                this.paintNode(g, (JXMapViewer)map, zoom, (int)(p2.getX() - p1.getX()), (int)(p2.getY() - p1.getY()));
                g.translate(-x, -y);
            }
            if (vp3.contains(p1)) {
                x = (int)(p1.getX() - ((RectangularShape)vp3).getX());
                y = (int)(p1.getY() - ((RectangularShape)vp3).getY());
                g.translate(x, y);
                this.paintNode(g, (JXMapViewer)map, zoom, (int)(p2.getX() - p1.getX()), (int)(p2.getY() - p1.getY()));
                g.translate(-x, -y);
            }
        }
    }

    public GeoPosition getPoint1() {
        return this.point1;
    }

    public void setPoint1(GeoPosition point) {
        this.point1 = point;
    }

    public GeoPosition getPoint2() {
        return this.point2;
    }

    public void setPoint2(GeoPosition point) {
        this.point2 = point;
    }

    public boolean paintNode(Graphics2D g, JXMapViewer ma, int zoom, int sizeX, int sizeY) {
        g.setColor(Color.BLACK);
        g.drawLine(0, 0, 0, sizeY);
        g.drawLine(0, 0, sizeX, 0);
        g.drawLine(sizeX, 0, sizeX, sizeY);
        g.drawLine(0, sizeY, sizeX, sizeY);
        return false;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

