/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.text.DecimalFormat;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.ScalePainter;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapViewerWithOneTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapViewerWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.WatchAreaWSProxy;
import ru.infor.ws.objects.vms.AdressNearPointParam;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.WatchArea;

public class RegionPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValueWithTrack value;
    WatchAreaWSProxy watchAreaProxy = (WatchAreaWSProxy)CurrentProxyFactory.getProxy(WatchArea.class);
    CheckPointWSProxy checkPointWSProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);

    public MapValueWithTrack getValue() {
        return this.value;
    }

    @Override
    public void setValue(IMapValue value) {
        this.value = (MapValueWithTrack)value;
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.value != null && this.value.getListZoneID() != null) {
            Long[] longArray = this.value.getListZoneID();
            int n = longArray.length;
            int n2 = 0;
            while (n2 < n) {
                Long id = longArray[n2];
                WatchArea w = this.watchAreaProxy.getCurrentObject(InitializedVariable.context, id);
                if (w.getAreageom() != null) {
                    this.paint(w.getAreageom(), map, g, vp2, vp3);
                }
                ++n2;
            }
        } else if (this.value != null && this.value.mapViewerWithTrack != null && ((MapViewerWithTrack)this.value.mapViewerWithTrack).getParam() != null) {
            AdressNearPointParam param = ((MapViewerWithOneTrack)this.value.mapViewerWithTrack).getParam();
            String geom = null;
            geom = param.getLimit() != null && param.getLimit() == 2 ? RegionPainter.buildSquare(param) : this.checkPointWSProxy.getGeomFromPoint(InitializedVariable.context, param);
            if (geom != null) {
                this.paint(geom, map, g, vp2, vp3);
            }
        }
    }

    public static String buildSquare(AdressNearPointParam param) {
        DecimalFormat df = new DecimalFormat("##0.#######");
        Double dla = (double)param.getRadius().intValue() / 111120.0;
        Double dlo = (double)param.getRadius().intValue() / (1000.0 * ScalePainter.calcKmOmDegree(param.getLat()));
        String geom = "SRID=4326;POLYGON((";
        geom = geom.concat(df.format(param.getLon() - dlo).replaceAll(",", ".")).concat(" ").concat(df.format(param.getLat() - dla).replaceAll(",", ".")).concat(",");
        geom = geom.concat(df.format(param.getLon() + dlo).replaceAll(",", ".")).concat(" ").concat(df.format(param.getLat() - dla).replaceAll(",", ".")).concat(",");
        geom = geom.concat(df.format(param.getLon() + dlo).replaceAll(",", ".")).concat(" ").concat(df.format(param.getLat() + dla).replaceAll(",", ".")).concat(",");
        geom = geom.concat(df.format(param.getLon() - dlo).replaceAll(",", ".")).concat(" ").concat(df.format(param.getLat() + dla).replaceAll(",", ".")).concat(",");
        geom = geom.concat(df.format(param.getLon() - dlo).replaceAll(",", ".")).concat(" ").concat(df.format(param.getLat() - dla).replaceAll(",", "."));
        geom = geom.concat("))");
        return geom;
    }

    protected void paintPolygon(org.postgis.Polygon polygon, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color w, Color w1) {
        Path2D path = null;
        int ii = 0;
        while (ii < polygon.numRings()) {
            Polygon pp = new Polygon();
            int i = 0;
            while (i < polygon.getRing(ii).numPoints()) {
                Point p1 = polygon.getRing(ii).getPoint(i);
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p1.getY(), p1.getX()), map.getZoom());
                int x = (int)(point.getX() - vp2.getX());
                int y = (int)(point.getY() - vp2.getY());
                pp.addPoint(x, y);
                ++i;
            }
            if (path == null) {
                path = new GeneralPath(pp);
            } else {
                path.append(pp, true);
            }
            g.setColor(w1);
            g.drawPolygon(pp);
            ++ii;
        }
        g.setColor(w);
        g.fill(path);
    }

    protected void paint(String geom, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Color w = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 70);
        Color w1 = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 90);
        try {
            Object geometry = geom.toLowerCase().indexOf("MultiPolygon".toLowerCase()) > -1 ? new MultiPolygon(geom) : new org.postgis.Polygon(geom);
            if (geometry instanceof org.postgis.Polygon) {
                this.paintPolygon((org.postgis.Polygon)geometry, map, g, vp2, vp3, w, w1);
            } else if (geometry instanceof MultiPolygon) {
                org.postgis.Polygon[] polygonArray = geometry.getPolygons();
                int n = polygonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    org.postgis.Polygon polygon = polygonArray[n2];
                    this.paintPolygon(polygon, map, g, vp2, vp3, w, w1);
                    ++n2;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

