/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.route.routegeom.RouteGeomBuilder;
import ru.blok.vms.ui.tracks.TrackAllWarrant;
import ru.blok.vms.ui.tracks.trackinrealtimelite.busnew.TrackInRealTimeLiteBusNew;
import ru.blok.vms.ui.tracks.tracksmp.MapPropertiesUItrackSMP;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.Route2CheckPointLinkWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.ws.objects.vms.Route2CheckPointLinkSearchCriteria;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.ext.Route2CheckPointLinkExt;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;
import ru.infor.ws.proxy.interfaces.ISearchCriteria;
import ru.infor.ws.proxy.interfaces.InvocationContext;

public class RoutePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    RouteWSProxy routeWSProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    TrackInRealTimeLiteBusNew inRealTimeLiteBusNew = null;
    Route2CheckPointLinkWSProxy linkWSProxy = (Route2CheckPointLinkWSProxy)CurrentProxyFactory.getProxy(Route2CheckPointLink.class);
    CheckPointWSProxy pointWsproxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
    private static WKTReader wr = new WKTReader();
    private static GeometryFactory gf = new GeometryFactory();
    private static Logger logger = Logger.getLogger(RoutePainter.class);
    private static HashMap<Geometry, com.vividsolutions.jts.geom.Geometry> g_cache = new HashMap();
    protected static Color c = Color.GREEN;
    public static Stroke defaultStroke = new BasicStroke(2.0f, 1, 1);
    public static Stroke defaultStrokeSelect = new BasicStroke(6.0f, 1, 1);
    List<RouteExt> routes = new ArrayList<RouteExt>();
    IMapValue mapValueWithTrack;

    public static double getScale(JXMapViewer map, RectangularShape vp2) {
        GeoPosition p1 = map.getTileFactory().pixelToGeo((Point2D)new Point2D.Double(vp2.getMinX(), vp2.getMinY()), map.getZoom());
        GeoPosition p2 = map.getTileFactory().pixelToGeo((Point2D)new Point2D.Double(vp2.getMaxX(), vp2.getMaxY()), map.getZoom());
        double p1scale = (p2.getLatitude() - p1.getLatitude()) / vp2.getHeight();
        double p2scale = (p2.getLatitude() - p1.getLatitude()) / vp2.getHeight();
        double p_scale = 3.0 * Math.min(Math.abs(p1scale), Math.abs(p2scale));
        return p_scale;
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Object o;
        if (this.mapValueWithTrack != null) {
            this.routes.clear();
            for (RouteExt r : ((MapValueWithTrack)this.mapValueWithTrack).getRoutes()) {
                if (r == null) continue;
                this.routes.add(r);
            }
            Object o2 = ((MapValueWithTrack)this.mapValueWithTrack).getTrackInRealTime2();
            if (o2 != null && o2 instanceof TrackInRealTimeLiteBusNew) {
                this.inRealTimeLiteBusNew = (TrackInRealTimeLiteBusNew)o2;
            }
        }
        for (RouteExt route : this.routes) {
            if (route != null && route.getRouteGeom() == null) {
                Route r2 = this.routeWSProxy.getCurrentObject(InitializedVariable.context, route.getId());
                route.setRouteGeom(r2.getRouteGeom());
                route.setAreaRouteGeom(r2.getAreaRouteGeom());
            }
            if (route != null && route.getRouteGeom() != null && route.getLineString() == null) {
                try {
                    MultiLineString lineString = new MultiLineString(route.getRouteGeom());
                    route.setLineString(lineString);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (route != null && route.getAreaRouteGeom() != null && route.getCurrentPolygon() == null) {
                try {
                    Object currentPolygon = null;
                    currentPolygon = route.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(route.getAreaRouteGeom()) : new org.postgis.Polygon(route.getAreaRouteGeom());
                    route.setCurrentPolygon((Geometry)currentPolygon);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            Object o3 = null;
            if (this.mapValueWithTrack != null && this.mapValueWithTrack instanceof MapValueWithTrack) {
                o3 = ((MapValueWithTrack)this.mapValueWithTrack).getTrackInRealTime2();
            }
            if (o3 == null || !(o3 instanceof TrackAllWarrant) || route.getLinks() != null) continue;
            ObjectUIList list3 = new ObjectUIList(Route2CheckPointLinkExt.class);
            list3.setTotalFill(true);
            Route2CheckPointLinkSearchCriteria sc3 = (Route2CheckPointLinkSearchCriteria)list3.getSearchCriteria();
            sc3.setRouteIdList(new Long[]{route.getId()});
            sc3.setCount(this.linkWSProxy._universalGetCount((InvocationContext)InitializedVariable.context, (ISearchCriteria)sc3));
            route.setLinks((List<Route2CheckPointLinkExt>)list3);
            if (route.getLinks() == null) continue;
            for (Route2CheckPointLinkExt rr : route.getLinks()) {
                if (rr.getCurrentPolygon() != null) continue;
                CheckPoint p = rr.getPoint();
                p = this.pointWsproxy.getCurrentObject(InitializedVariable.context, p.getId());
                rr.setPoint(p);
                if (rr.getPoint().getGeom() != null) {
                    try {
                        Object currentPolygon = null;
                        currentPolygon = rr.getPoint().getGeom().contains("MULTIPOLYGON") ? new MultiPolygon(rr.getPoint().getGeom()) : new org.postgis.Polygon(rr.getPoint().getGeom());
                        rr.setCurrentPolygon((Geometry)currentPolygon);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                rr.setCurrentPolygon((Geometry)RouteGeomBuilder.getDefaultPolygonStation(rr.getPoint().getLat(), rr.getPoint().getLon(), 30));
            }
        }
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        int a = 150;
        if (this.mapValueWithTrack != null && ((MapValueWithTrack)this.mapValueWithTrack).mapViewerWithTrack != null && (o = ((MapValueWithTrack)this.mapValueWithTrack).mapViewerWithTrack.getUIProperties()) instanceof MapPropertiesUItrackSMP) {
            a = ((MapPropertiesUItrackSMP)o).getAlpha();
            c = new Color(((MapPropertiesUItrackSMP)o).getColorRoute());
        }
        Polygon window = RoutePainter.getLatLonWindow(map, vp2);
        for (RouteExt r : this.routes) {
            Color cc = c;
            if (r.getColor() != null) {
                cc = new Color(r.getColor());
            }
            if (r.getCurrentPolygon() != null) {
                RoutePainter.paintArea(r, window, g, map, vp2, cc, a);
            }
            if (r.getLineString() != null) {
                this.paintLine((Geometry)r.getLineString(), g, map, vp2, vp3, cc);
            }
            if (r.getLinks() == null) continue;
            for (Route2CheckPointLinkExt rr : r.getLinks()) {
                try {
                    com.vividsolutions.jts.geom.Geometry jtsp;
                    if (g_cache.containsKey(rr.getCurrentPolygon())) {
                        jtsp = g_cache.get(rr.getCurrentPolygon());
                    } else {
                        jtsp = wr.read(String.valueOf(rr.getCurrentPolygon().getTypeString()) + rr.getCurrentPolygon().getValue());
                        g_cache.put(rr.getCurrentPolygon(), jtsp);
                    }
                    RoutePainter.paintPolygon(window.intersection(jtsp), map, g, (Rectangle2D)vp2, cc, a);
                }
                catch (ParseException e) {
                    logger.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438", (Throwable)e);
                }
            }
        }
        if (this.inRealTimeLiteBusNew != null && this.inRealTimeLiteBusNew.isColorFromRoute()) {
            Object o4 = ((MapValueWithTrack)this.mapValueWithTrack).mapViewerWithTrack.getUIProperties();
            Color cc = null;
            cc = o4 instanceof MapPropertiesUItrackSMP ? new Color(((MapPropertiesUItrackSMP)o4).getColorRoute()) : Color.RED;
            int y = 40;
            int h = g.getFontMetrics().getHeight();
            for (RouteExt r : this.routes) {
                Color c = cc;
                if (r.getColor() != null) {
                    c = new Color(r.getColor());
                }
                g.setColor(c);
                g.fillRect(20, y, 30, h);
                g.setColor(c.brighter().brighter());
                g.drawRect(20, y, 30, h);
                g.setColor(Color.BLACK);
                g.drawString(r.getNum(), 53, y + h);
                y = y + h + 5;
            }
        }
    }

    public void paintLine(Geometry r, Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3, Color cc) {
        try {
            com.vividsolutions.jts.geom.Geometry is;
            com.vividsolutions.jts.geom.Geometry jtsp;
            Polygon window = RoutePainter.getLatLonWindow(map, vp2);
            if (g_cache.containsKey(r)) {
                jtsp = g_cache.get(r);
            } else {
                jtsp = wr.read(String.valueOf(r.getTypeString()) + r.getValue());
                g_cache.put(r, jtsp);
            }
            if (window.covers(jtsp.getBoundary())) {
                is = jtsp;
            } else {
                try {
                    is = window.intersection(jtsp);
                }
                catch (Exception exception) {
                    is = jtsp;
                }
            }
            this.paint(is, map, g, vp2, vp3, cc, false);
        }
        catch (ParseException e) {
            logger.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438", (Throwable)e);
        }
    }

    public static com.vividsolutions.jts.geom.Geometry paintArea(RouteExt r, Polygon window, Graphics2D g, JXMapViewer map, Rectangle2D vp2, Color cc, int a) {
        try {
            com.vividsolutions.jts.geom.Geometry is;
            com.vividsolutions.jts.geom.Geometry jtsp;
            if (g_cache.containsKey(r.getCurrentPolygon())) {
                jtsp = g_cache.get(r.getCurrentPolygon());
            } else {
                jtsp = wr.read(String.valueOf(r.getCurrentPolygon().getTypeString()) + r.getCurrentPolygon().getValue());
                g_cache.put(r.getCurrentPolygon(), jtsp);
            }
            if (window.covers(jtsp.getBoundary())) {
                is = jtsp;
            } else {
                try {
                    is = window.intersection(jtsp);
                }
                catch (Exception exception) {
                    is = jtsp;
                }
            }
            RoutePainter.paintPolygon(is, map, g, vp2, cc, a);
            return jtsp;
        }
        catch (ParseException e) {
            logger.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438", (Throwable)e);
            return null;
        }
    }

    public static List<Shape> paintPolygon(Geometry polygon, JXMapViewer map, Graphics2D g, Rectangle2D vp2, Color c, int k) {
        Polygon window = RoutePainter.getLatLonWindow(map, vp2);
        try {
            com.vividsolutions.jts.geom.Geometry is;
            com.vividsolutions.jts.geom.Geometry jtsp;
            if (g_cache.containsKey(polygon)) {
                jtsp = g_cache.get(polygon);
            } else {
                jtsp = wr.read(String.valueOf(polygon.getTypeString()) + polygon.getValue());
                g_cache.put(polygon, jtsp);
            }
            if (window.covers(jtsp.getBoundary())) {
                is = jtsp;
            } else {
                try {
                    is = window.intersection(jtsp);
                }
                catch (Exception exception) {
                    is = jtsp;
                }
            }
            List<Shape> pp = RoutePainter.paintPolygon(is, map, g, vp2, c, k);
            return pp;
        }
        catch (ParseException e) {
            logger.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static Polygon getLatLonWindow(JXMapViewer map, Rectangle2D vp2) {
        GeoPosition mingp = map.getTileFactory().pixelToGeo((Point2D)new Point2D.Double(vp2.getMinX(), vp2.getMinY()), map.getZoom());
        GeoPosition maxgp = map.getTileFactory().pixelToGeo((Point2D)new Point2D.Double(vp2.getMaxX(), vp2.getMaxY()), map.getZoom());
        Coordinate coor = new Coordinate(mingp.getLongitude(), mingp.getLatitude());
        Polygon window = gf.createPolygon(gf.createLinearRing(new Coordinate[]{coor, new Coordinate(mingp.getLongitude(), maxgp.getLatitude()), new Coordinate(maxgp.getLongitude(), maxgp.getLatitude()), new Coordinate(maxgp.getLongitude(), mingp.getLatitude()), coor}), new LinearRing[0]);
        return window;
    }

    public static List<Shape> paintPolygon(com.vividsolutions.jts.geom.Geometry polygon, JXMapViewer map, Graphics2D g, Rectangle2D vp2, Color c, int k) {
        ArrayList<Shape> listp = new ArrayList<Shape>();
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), k));
        GeneralPath[] pp = RoutePainter.createPolygonFromGeometry(polygon, map, vp2, RoutePainter.getScale(map, vp2));
        int i = 0;
        while (i < pp.length) {
            g.draw(pp[i]);
            g.fill(pp[i]);
            listp.add(pp[i]);
            ++i;
        }
        return listp;
    }

    private static GeneralPath[] createPolygonFromGeometry(com.vividsolutions.jts.geom.Geometry polygon, JXMapViewer map, Rectangle2D vp2, double p_scale) {
        com.vividsolutions.jts.geom.Geometry simplifyed = DouglasPeuckerSimplifier.simplify((com.vividsolutions.jts.geom.Geometry)polygon, (double)p_scale);
        if (!simplifyed.isEmpty()) {
            GeneralPath[] pp = new GeneralPath[simplifyed.getNumGeometries()];
            int j = 0;
            while (j < simplifyed.getNumGeometries()) {
                com.vividsolutions.jts.geom.Geometry gn = simplifyed.getGeometryN(j);
                if (gn instanceof Polygon) {
                    GeneralPath ppi = new GeneralPath();
                    Polygon pol = (Polygon)gn;
                    int poln = -1;
                    while (poln < pol.getNumInteriorRing()) {
                        LineString gnn = poln == -1 ? pol.getExteriorRing() : pol.getInteriorRingN(poln);
                        int i = 0;
                        while (i < gnn.getNumPoints() - 1) {
                            Coordinate p = gnn.getCoordinates()[i];
                            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p.y, p.x), map.getZoom());
                            if (i == 0) {
                                ppi.moveTo(point.getX() - vp2.getX(), point.getY() - vp2.getY());
                            } else {
                                ppi.lineTo(point.getX() - vp2.getX(), point.getY() - vp2.getY());
                            }
                            ++i;
                        }
                        ++poln;
                    }
                    ppi.closePath();
                    pp[j] = ppi;
                } else {
                    logger.error((Object)("\u0412 \u0441\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u044b\u0445 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0439 \u043d\u0435 \u043f\u043e\u043b\u0438\u0433\u043e\u043d: " + gn.getGeometryType() + " " + gn.toString()));
                }
                ++j;
            }
            return pp;
        }
        return new GeneralPath[0];
    }

    protected void paint(com.vividsolutions.jts.geom.Geometry geometry, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, boolean select) {
        com.vividsolutions.jts.geom.Geometry simplifyedGeometry = DouglasPeuckerSimplifier.simplify((com.vividsolutions.jts.geom.Geometry)geometry, (double)RoutePainter.getScale(map, vp2));
        GeneralPath shape = new GeneralPath();
        int i = 0;
        while (i < simplifyedGeometry.getNumGeometries()) {
            com.vividsolutions.jts.geom.Geometry gg = simplifyedGeometry.getGeometryN(i);
            int j = 0;
            while (j < gg.getCoordinates().length) {
                Point2D cp = map.getTileFactory().geoToPixel(new GeoPosition(gg.getCoordinates()[j].y, gg.getCoordinates()[j].x), map.getZoom());
                if (j == 0) {
                    shape.moveTo(cp.getX() - vp2.getX(), cp.getY() - vp2.getY());
                } else {
                    shape.lineTo(cp.getX() - vp2.getX(), cp.getY() - vp2.getY());
                }
                ++j;
            }
            ++i;
        }
        g.setColor(c);
        g.setStroke(select ? defaultStrokeSelect : defaultStroke);
        g.draw(shape);
    }

    public void setRoutes(List<RouteExt> routes) {
        this.routes = routes;
        routes.stream().forEach(t -> this.initR((RouteExt)((Object)t)));
    }

    private void initR(RouteExt route) {
        if (route != null && route.getRouteGeom() == null) {
            Route r2 = this.routeWSProxy.getCurrentObject(InitializedVariable.context, route.getId());
            route.setRouteGeom(r2.getRouteGeom());
        }
        if (route != null && route.getRouteGeom() != null && route.getLineString() == null) {
            try {
                MultiLineString lineString = new MultiLineString(route.getRouteGeom());
                route.setLineString(lineString);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (route != null && route.getAreaRouteGeom() != null && route.getCurrentPolygon() == null) {
            try {
                Object currentPolygon = null;
                currentPolygon = route.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(route.getAreaRouteGeom()) : new org.postgis.Polygon(route.getAreaRouteGeom());
                route.setCurrentPolygon((Geometry)currentPolygon);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void setRoute(Route r) {
        this.routes.clear();
        RouteExt route = (RouteExt)r;
        this.routes.add(route);
        this.initR(route);
    }

    public List<RouteExt> getRoutes() {
        return this.routes;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.mapValueWithTrack = mapValueWithTrack;
    }
}

