/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import java.util.Arrays;
import java.util.HashMap;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.tracks.parameterdevice.Parameter;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.ws.objects.draw.entities.AbstractCondition;
import ru.infor.ws.objects.draw.entities.ColorCondition;
import ru.infor.ws.objects.draw.entities.FloatArrayCondition;
import ru.infor.ws.objects.draw.entities.FloatCondition;
import ru.infor.ws.objects.draw.entities.IntegerCondition;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.NavigationDevice;

public class Utils {
    static HashMap<Long, NavigationDevice> mapDevice = new HashMap();
    static NavigationDeviceWSProxy proxy = (NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class);

    public static Object getParameterValue(AbstractNDData d1, AbstractNDData d2, AbstractCondition c) {
        NDData data = (NDData)d1;
        if ("speed".equals(c.getParameterName().getCode())) {
            return data.getSpeed();
        }
        if ("dtime".equals(c.getParameterName().getCode())) {
            if (d2 != null) {
                return (d2.getCreatedDateTime().getTime() - d1.getCreatedDateTime().getTime()) / 1000L;
            }
            return 0.0;
        }
        if ("gpsSatCount".equals(c.getParameterName().getCode())) {
            return data.getGpsSatCount();
        }
        if ("gsmSignalLevel".equals(c.getParameterName().getCode())) {
            return data.getGsmSignalLevel();
        }
        if ("alarmDevice".equals(c.getParameterName().getCode())) {
            return data.getAlarmDevice();
        }
        if ("powerValue".equals(c.getParameterName().getCode())) {
            return data.getPowerValue();
        }
        NavigationDevice d = mapDevice.get(data.getDeviceId());
        if (d == null) {
            d = proxy.getCurrentObject(InitializedVariable.context, data.getDeviceId());
            mapDevice.put(d.getId(), d);
        }
        if (d.getAe0_name() != null && d.getAe0_name().equals((Object)c.getParameterName())) {
            return data.getAe0();
        }
        if (d.getAe1_name() != null && d.getAe1_name().equals((Object)c.getParameterName())) {
            return data.getAe1();
        }
        if (d.getAe2_name() != null && d.getAe2_name().equals((Object)c.getParameterName())) {
            return data.getAe2();
        }
        if (d.getAe3_name() != null && d.getAe3_name().equals((Object)c.getParameterName())) {
            return data.getAe3();
        }
        if (d.getAe4_name() != null && d.getAe4_name().equals((Object)c.getParameterName())) {
            return data.getAe4();
        }
        if (d.getAe5_name() != null && d.getAe5_name().equals((Object)c.getParameterName())) {
            return data.getAe5();
        }
        if (d.getAe6_name() != null && d.getAe6_name().equals((Object)c.getParameterName())) {
            return data.getAe6();
        }
        if (d.getAe7_name() != null && d.getAe7_name().equals((Object)c.getParameterName())) {
            return data.getAe7();
        }
        if (d.getAe8_name() != null && d.getAe8_name().equals((Object)c.getParameterName())) {
            return data.getAe8();
        }
        if (d.getAe9_name() != null && d.getAe9_name().equals((Object)c.getParameterName())) {
            return data.getAe9();
        }
        if (d.getDe0_name() != null && d.getDe0_name().equals((Object)c.getParameterName())) {
            return data.getDe0();
        }
        if (d.getDe1_name() != null && d.getDe1_name().equals((Object)c.getParameterName())) {
            return data.getDe1();
        }
        if (d.getDe2_name() != null && d.getDe2_name().equals((Object)c.getParameterName())) {
            return data.getDe2();
        }
        if (d.getDe3_name() != null && d.getDe3_name().equals((Object)c.getParameterName())) {
            return data.getDe3();
        }
        if (d.getDe4_name() != null && d.getDe4_name().equals((Object)c.getParameterName())) {
            return data.getDe4();
        }
        if (d.getDe5_name() != null && d.getDe5_name().equals((Object)c.getParameterName())) {
            return data.getDe5();
        }
        if (d.getDe6_name() != null && d.getDe6_name().equals((Object)c.getParameterName())) {
            return data.getDe6();
        }
        if (d.getDe7_name() != null && d.getDe7_name().equals((Object)c.getParameterName())) {
            return data.getDe7();
        }
        if (d.getDe8_name() != null && d.getDe8_name().equals((Object)c.getParameterName())) {
            return data.getDe8();
        }
        if (d.getDe9_name() != null && d.getDe9_name().equals((Object)c.getParameterName())) {
            return data.getDe9();
        }
        return null;
    }

    public static Object getParameterValue(NDData d, Parameter p) {
        switch (p.getAn()) {
            case -1: {
                switch (p.getIndex()) {
                    case 0: {
                        return d.getSpeed();
                    }
                    case 1: {
                        return d.getGpsSatCount();
                    }
                    case 2: {
                        return d.getGsmSignalLevel();
                    }
                    case 3: {
                        return d.getAlarm();
                    }
                    case 4: {
                        return d.getPowerValue();
                    }
                }
            }
            case 1: {
                switch (p.getIndex()) {
                    case 0: {
                        return d.getAe0();
                    }
                    case 1: {
                        return d.getAe1();
                    }
                    case 2: {
                        return d.getAe2();
                    }
                    case 3: {
                        return d.getAe3();
                    }
                    case 4: {
                        return d.getAe4();
                    }
                    case 5: {
                        return d.getAe5();
                    }
                    case 6: {
                        return d.getAe6();
                    }
                    case 7: {
                        return d.getAe7();
                    }
                    case 8: {
                        return d.getAe8();
                    }
                    case 9: {
                        return d.getAe9();
                    }
                }
            }
            case 0: {
                switch (p.getIndex()) {
                    case 0: {
                        return d.getDe0();
                    }
                    case 1: {
                        return d.getDe1();
                    }
                    case 2: {
                        return d.getDe2();
                    }
                    case 3: {
                        return d.getDe3();
                    }
                    case 4: {
                        return d.getDe4();
                    }
                    case 5: {
                        return d.getDe5();
                    }
                    case 6: {
                        return d.getDe6();
                    }
                    case 7: {
                        return d.getDe7();
                    }
                    case 8: {
                        return d.getDe8();
                    }
                    case 9: {
                        return d.getDe9();
                    }
                }
            }
        }
        return null;
    }

    public static boolean isTrue(Object parameter, AbstractCondition c) {
        if (parameter == null) {
            return false;
        }
        JEP jep = new JEP();
        jep.addVariable("p", parameter);
        Boolean b = false;
        String fs = c.getCondition().replaceAll(" and ", " && ").replaceAll(" or ", " || ").replaceAll(" = ", " == ").replaceAll(" <> ", " != ");
        try {
            Node nod = jep.parse(fs);
            b = (Double)jep.evaluate(nod) == 1.0;
            return b;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Integer getColorWithConditions(AbstractNDData data, AbstractNDData d2, ColorCondition[] conditions, Integer defaultValue) {
        Integer color = defaultValue;
        if (conditions != null) {
            Arrays.sort(conditions);
            ColorCondition[] colorConditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                ColorCondition cc = colorConditionArray[n2];
                if (Utils.isTrue(Utils.getParameterValue(data, d2, (AbstractCondition)cc), (AbstractCondition)cc)) {
                    return cc.getColor();
                }
                ++n2;
            }
        }
        return color;
    }

    public static Integer getIntegerWithConditions(AbstractNDData data, AbstractNDData d2, IntegerCondition[] conditions, Integer defaultValue) {
        Integer res = defaultValue;
        if (conditions != null) {
            Arrays.sort(conditions);
            IntegerCondition[] integerConditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                IntegerCondition cc = integerConditionArray[n2];
                if (Utils.isTrue(Utils.getParameterValue(data, d2, (AbstractCondition)cc), (AbstractCondition)cc)) {
                    return cc.getValue();
                }
                ++n2;
            }
        }
        return res;
    }

    public static Float getFloatWithConditions(AbstractNDData data, AbstractNDData d2, FloatCondition[] conditions, Float defaultValue) {
        Float res = defaultValue;
        if (conditions != null) {
            Arrays.sort(conditions);
            FloatCondition[] floatConditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                FloatCondition cc = floatConditionArray[n2];
                if (Utils.isTrue(Utils.getParameterValue(data, d2, (AbstractCondition)cc), (AbstractCondition)cc)) {
                    return cc.getValue();
                }
                ++n2;
            }
        }
        return res;
    }

    public static Float[] getFloatArrayWithConditions(AbstractNDData data, AbstractNDData d2, FloatArrayCondition[] conditions, Float[] defaultValue) {
        Float[] res = defaultValue;
        if (conditions != null) {
            Arrays.sort(conditions);
            FloatArrayCondition[] floatArrayConditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                FloatArrayCondition cc = floatArrayConditionArray[n2];
                if (Utils.isTrue(Utils.getParameterValue(data, d2, (AbstractCondition)cc), (AbstractCondition)cc)) {
                    return cc.getValue();
                }
                ++n2;
            }
        }
        return res;
    }
}

