/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.newmapviewer;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.mapviewer.imap.IMapViewerWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapPropertiesUItrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.newmapviewer.InfoPoint;
import ru.blok.vms.ui.mapviewer.newmapviewer.MapValueWithTrackNew;
import ru.blok.vms.ui.mapviewer.newmapviewer.NewPainterData;
import ru.blok.vms.ui.mapviewer.newmapviewer.TrackData;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.entities.AbstractNDData;

public class MapViewerWithTrackNew
extends MapViewer
implements IMapViewerWithTrack {
    protected MapValueWithTrackNew mapValueWithTrack;
    MapViewPainter<JXMapViewer> wpp;
    private boolean change = false;
    protected NewPainterData<JXMapViewer> nodepd;

    public MapViewerWithTrackNew(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    public void setValue(Object arg0) {
        if (arg0 != null) {
            this.mapValueWithTrack = (MapValueWithTrackNew)arg0;
            this.mapValueWithTrack.mapViewerWithTrack = this;
            super.setValue(this.mapValueWithTrack.getMapValue());
            this.wpp.setValue(this.mapValueWithTrack);
        }
    }

    @Override
    public Object getValue() {
        if (this.mapValueWithTrack != null && this.mapValueWithTrack.getMapValue() != null) {
            this.mapValueWithTrack.getMapValue().setLat(this.map.getMainMap().getCenterPosition().getLatitude());
            this.mapValueWithTrack.getMapValue().setLon(this.map.getMainMap().getCenterPosition().getLongitude());
            this.mapValueWithTrack.getMapValue().setZoom(this.map.getMainMap().getZoom());
        }
        return this.mapValueWithTrack;
    }

    @Override
    public void change() {
        this.change = true;
    }

    protected MapViewPainter<JXMapViewer> getPainter() {
        this.nodepd = new NewPainterData<JXMapViewer>();
        return this.nodepd;
    }

    protected void mouseClickedOnMap(MouseEvent e) {
        if (e.getClickCount() == 1) {
            double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
            Point2D.Double pClick = new Point2D.Double(x, y);
            InfoPoint p = this.nodepd.include(pClick);
            System.out.println(p);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.wpp = this.getPainter();
        this.painter.addPainter(this.wpp);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapViewerWithTrackNew.this.mouseClickedOnMap(e);
            }
        });
        this.initRepaint();
    }

    protected void initRepaint() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (MapViewerWithTrackNew.this.change) {
                            MapViewerWithTrackNew.this.repaint();
                            MapViewerWithTrackNew.this.change = false;
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    @Override
    public Object getUIProperties() {
        if (this.propertiesUI == null) {
            this.propertiesUI = new MapPropertiesUItrack();
            this.propertiesUI.setProvidersInfo(DefaultProvider.getDefaultProviderInfo());
        }
        return this.propertiesUI;
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return MapPropertiesUItrack.class;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        for (TrackData t : this.mapValueWithTrack.getTracksData()) {
            AbstractNDData d = (AbstractNDData)t.getNodes()[t.getNodes().length - 1];
            if (minLat == null || d.getLat() < minLat) {
                minLat = d.getLat();
            }
            if (maxLat == null || d.getLat() > maxLat) {
                maxLat = d.getLat();
            }
            if (minLon == null || d.getLon() < minLon) {
                minLon = d.getLon();
            }
            if (maxLon != null && !(d.getLon() > maxLon)) continue;
            maxLon = d.getLon();
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }
}

