/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.newmapviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.newmapviewer.InfoPoint;
import ru.blok.vms.ui.mapviewer.newmapviewer.MapValueWithTrackNew;
import ru.blok.vms.ui.mapviewer.newmapviewer.TrackData;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.vms.entities.AbstractNDData;

public class NewPainterData<T extends JXMapViewer>
extends MapViewPainter<T> {
    protected MapValueWithTrackNew mapValueWithTrackNew;
    protected static double accuracyOfPaint = 8.0;
    private HashMap<InfoPoint, Polygon> mapV = new HashMap();

    public NewPainterData() {
        this.setAntialiasing(true);
        this.setCacheable(false);
        accuracyOfPaint = Double.parseDouble(SysProperties.getProperty((String)"AccuracyOfPaint", (String)"8.0"));
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        this.paintTracks(g, map, vp2, vp3);
        this.paintIcons(g, map, vp2, vp3);
    }

    public InfoPoint include(Point2D pClick) {
        for (InfoPoint p : this.mapV.keySet()) {
            if (!this.mapV.get(p).contains(pClick)) continue;
            return p;
        }
        return null;
    }

    protected void paintIcons(Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3) {
        this.mapV.clear();
        if (this.mapValueWithTrackNew != null && this.mapValueWithTrackNew.getListPoint() != null && this.mapValueWithTrackNew.getListPoint().size() > 0) {
            for (InfoPoint p : this.mapValueWithTrackNew.getListPoint()) {
                this.mapV.put(p, this.paintIcon(p.getIcon(), p.getData().getLat(), p.getData().getLon(), map, g, vp2, vp3, false));
            }
        }
    }

    protected void paintTracks(Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3) {
        if (this.mapValueWithTrackNew != null && this.mapValueWithTrackNew.getTracksData() != null && this.mapValueWithTrackNew.getTracksData().size() > 0) {
            for (TrackData t : this.mapValueWithTrackNew.getTracksData()) {
                this.paintTrack(t, map, g, vp2, vp3);
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.mapValueWithTrackNew = (MapValueWithTrackNew)mapValueWithTrack;
    }

    protected Polygon paintIcon(String icon, double lat, double lon, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, boolean select) {
        int y;
        int x;
        Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(lat, lon), map.getZoom());
        if (vp2.contains(point)) {
            x = (int)(point.getX() - vp2.getX());
            y = (int)(point.getY() - vp2.getY());
            try {
                BufferedImage img1 = ImageIO.read(((Object)((Object)this)).getClass().getResource(icon));
                int imwidth = ((Image)img1).getWidth(null);
                int imheight = ((Image)img1).getHeight(null);
                if (select) {
                    g.setColor(Color.RED);
                    g.fillRect(x - imheight - 3, y - imwidth - 3, imheight + 6, imwidth + 6);
                    g.drawImage((Image)img1, x - imwidth, y - imheight, (ImageObserver)map);
                    Polygon p1 = new Polygon();
                    p1.addPoint((int)point.getX() + 3, (int)point.getY() + 3);
                    p1.addPoint((int)(point.getX() - (double)imwidth - 3.0), (int)point.getY() + 3);
                    p1.addPoint((int)(point.getX() - (double)imwidth - 3.0), (int)(point.getY() - (double)imheight - 3.0));
                    p1.addPoint((int)(point.getX() + 3.0), (int)(point.getY() - (double)imheight - 3.0));
                    return p1;
                }
                g.drawImage((Image)img1, x - imwidth, y - imheight, (ImageObserver)map);
                Polygon p1 = new Polygon();
                p1.addPoint((int)point.getX(), (int)point.getY());
                p1.addPoint((int)(point.getX() - (double)imwidth), (int)point.getY());
                p1.addPoint((int)(point.getX() - (double)imwidth), (int)(point.getY() - (double)imheight));
                p1.addPoint((int)point.getX(), (int)(point.getY() - (double)imheight));
                return p1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (vp3.contains(point)) {
            x = (int)(point.getX() - vp3.getX());
            y = (int)(point.getY() - vp3.getY());
            try {
                BufferedImage img1 = ImageIO.read(((Object)((Object)this)).getClass().getResource(icon));
                int imwidth = ((Image)img1).getWidth(null);
                int imheight = ((Image)img1).getHeight(null);
                if (select) {
                    g.setColor(Color.RED);
                    g.fillRect(x - imheight - 3, y - imwidth - 3, imheight + 6, imwidth + 6);
                    g.drawImage((Image)img1, x - imwidth, y - imheight, (ImageObserver)map);
                    Polygon p1 = new Polygon();
                    p1.addPoint((int)point.getX() + 3, (int)point.getY() + 3);
                    p1.addPoint((int)(point.getX() - (double)imwidth - 3.0), (int)point.getY() + 3);
                    p1.addPoint((int)(point.getX() - (double)imwidth - 3.0), (int)(point.getY() - (double)imheight - 3.0));
                    p1.addPoint((int)(point.getX() + 3.0), (int)(point.getY() - (double)imheight - 3.0));
                    return p1;
                }
                g.drawImage((Image)img1, x - imwidth, y - imheight, (ImageObserver)map);
                Polygon p1 = new Polygon();
                p1.addPoint((int)point.getX(), (int)point.getY());
                p1.addPoint((int)(point.getX() - (double)imwidth), (int)point.getY());
                p1.addPoint((int)(point.getX() - (double)imwidth), (int)(point.getY() - (double)imheight));
                p1.addPoint((int)point.getX(), (int)(point.getY() - (double)imheight));
                return p1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void paintTrack(TrackData t, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (t.getNodes() != null) {
            int s = t.getNodes().length;
            int from = 0;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(((AbstractNDData)t.getNodes()[from]).getLat().doubleValue(), ((AbstractNDData)t.getNodes()[from]).getLon().doubleValue()), map.getZoom());
            int i = 1;
            while (i < s) {
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(((AbstractNDData)t.getNodes()[i]).getLat().doubleValue(), ((AbstractNDData)t.getNodes()[i]).getLon().doubleValue()), map.getZoom());
                double d = pointFrom.distance(pointTo);
                if (d > accuracyOfPaint) {
                    this.paint(pointFrom, pointTo, map, g, vp2, vp3, t.getColor(), null);
                    from = i;
                    pointFrom = pointTo;
                }
                ++i;
            }
        }
    }

    protected void paint(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, Stroke stroke) {
        g.setColor(c);
        if (stroke != null) {
            g.setStroke(stroke);
        }
        g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
    }
}

