/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.polygonstringviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.polygonstringviewer.MapValuePolygon;

public class PolygonPainterData<T extends JXMapViewer>
extends MapViewPainter<T> {
    protected MapValuePolygon valuePolygon;
    protected static double accuracyOfPaint = 8.0;
    public static Stroke defaultStroke = new BasicStroke(2.0f, 1, 1);

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.valuePolygon != null) {
            GeoPosition[] gpp = this.valuePolygon.getFlags();
            if (gpp != null) {
                int i = 0;
                while (i < gpp.length) {
                    GeoPosition gp = gpp[i];
                    if (gp != null) {
                        int y;
                        int x;
                        Point2D point = map.getTileFactory().geoToPixel(gp, map.getZoom());
                        if (vp2.contains(point)) {
                            x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                            y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                            g.translate(x, y);
                            this.paintNode(g, (JXMapViewer)map);
                            g.translate(-x, -y);
                        }
                        if (vp3.contains(point)) {
                            x = (int)(point.getX() - ((RectangularShape)vp3).getX());
                            y = (int)(point.getY() - ((RectangularShape)vp3).getY());
                            g.translate(x, y);
                            this.paintNode(g, (JXMapViewer)map);
                            g.translate(-x, -y);
                        }
                    }
                    ++i;
                }
            }
            if (this.valuePolygon.getPolygon() != null) {
                this.paintPolygon(this.valuePolygon.getPolygon(), map, g, vp2, vp3, Color.RED);
            }
        }
    }

    protected void paintPolygon(com.vividsolutions.jts.geom.Polygon polygon, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c) {
        int from = 0;
        Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(polygon.getCoordinates()[from].y, polygon.getCoordinates()[from].x), map.getZoom());
        int i = 1;
        while (i < polygon.getCoordinates().length) {
            Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(polygon.getCoordinates()[i].y, polygon.getCoordinates()[i].x), map.getZoom());
            this.paint(pointFrom, pointTo, map, g, vp2, vp3, c, defaultStroke);
            from = i++;
            pointFrom = pointTo;
        }
    }

    protected void paint(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, Stroke stroke) {
        g.setColor(c);
        if (stroke != null) {
            g.setStroke(stroke);
        }
        g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
    }

    public boolean paintNode(Graphics2D g, JXMapViewer ma) {
        Polygon p = new Polygon();
        p.addPoint(0, -15);
        p.addPoint(-15, -15);
        p.addPoint(-15, -25);
        p.addPoint(1, -25);
        p.addPoint(1, 0);
        g.setColor(Color.BLACK);
        g.drawPolygon(p);
        g.setColor(Color.RED);
        g.fillPolygon(p);
        return false;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.valuePolygon = (MapValuePolygon)mapValueWithTrack;
    }
}

