/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.polygonstringviewer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.jxmapviewer.viewer.GeoPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.mapviewer.polygonstringviewer.MapValuePolygon;
import ru.blok.vms.ui.mapviewer.polygonstringviewer.MapViewerPolygon;
import ru.blok.vms.ui.mapviewer.polygonstringviewer.OKPolygon;
import ru.blok.vms.ui.tracks.json.LoaderFromInternet;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.RouteNavigationParam;

@ListView(views={@View(title="\u0412\u044b\u0431\u043e\u0440 \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u0430", keyView="point", layoutKeys={"tabSplitPercentLayoutManager"}, actions={@ActionViewer(clazz=OKPolygon.class), @ActionViewer(clazz=PanelContext.CancelButton.class)}), @View(title="\u0412\u044b\u0431\u043e\u0440 \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u0430", keyView="route", layoutKeys={"tabSplitPercentLayoutManager"}, actions={@ActionViewer(clazz=OKPolygon.class), @ActionViewer(clazz=PanelContext.CancelButton.class)})})
public class PolygonStringPresentation
extends CommonObjectWithKey {
    private String title;
    PanelContext pc;
    private Polygon polygon;
    private MapValuePolygon mapValuePolygon;
    public static String wkt4326 = "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]";
    public static String wkt3395 = "PROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3395\"]]";
    private Double lat;
    private Double lon;
    private Integer radius;
    private Double lat1;
    private Double lon1;
    private Double lat2;
    private Double lon2;
    private Integer width;
    private Integer typeVariable = 2;
    boolean isPoint;
    BeanViewerAction<ViewerContext> buildR = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (PolygonStringPresentation.this.lon == null || PolygonStringPresentation.this.lat == null || PolygonStringPresentation.this.radius == null) {
                InitializedVariable.factory.runMessageEx((Object)new ErrorMessage("\u0414\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0432\u0432\u0435\u0434\u0435\u043d\u044b \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0438 \u0440\u0430\u0434\u0438\u0443\u0441"), new BeanViewerAction[]{new MessageOKButton()});
            } else {
                PolygonStringPresentation.this.buildPolygon();
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
            }
        }

        public String getName() {
            return "\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043e\u043a\u0440\u0443\u0436\u043d\u043e\u0441\u0442\u044c";
        }
    };
    BeanViewerAction<ViewerContext> buildPath = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object message) {
            NavigationPoint no;
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (PolygonStringPresentation.this.getLat1() == null || PolygonStringPresentation.this.getLon1() == null || PolygonStringPresentation.this.getLat2() == null || PolygonStringPresentation.this.getLon2() == null || PolygonStringPresentation.this.getWidth() == null) {
                InitializedVariable.factory.runMessageEx((Object)new ErrorMessage("\u0414\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0438 \u043a\u043e\u043d\u0435\u0447\u043d\u044b\u0435 \u0442\u043e\u0447\u043a\u0438 \u0438 \u0448\u0438\u0440\u0438\u043d\u0430 \u043f\u0443\u0442\u0438"), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            NavigationPoint from = new NavigationPoint();
            from.setLat(PolygonStringPresentation.this.getLat1());
            from.setLon(PolygonStringPresentation.this.getLon1());
            NavigationPoint to = new NavigationPoint();
            to.setLat(PolygonStringPresentation.this.getLat2());
            to.setLon(PolygonStringPresentation.this.getLon2());
            NavigationPoint[] pp = null;
            RouteNavigationParam param = new RouteNavigationParam();
            param.setFrom(from);
            param.setTo(to);
            param.setLimitRange(null);
            param.setFintessID(Long.valueOf(1L));
            pp = LoaderFromInternet.getRoute(InitializedVariable.context, param);
            ArrayList<NavigationPoint> listPE = new ArrayList<NavigationPoint>();
            if (pp == null || pp.length == 0 || pp[0].getLat() != from.getLat() || pp[0].getLon() != from.getLon()) {
                no = new NavigationPoint();
                no.setLat(from.getLat());
                no.setLon(from.getLon());
                listPE.add(no);
            }
            if (pp != null && pp.length > 0) {
                int i = 0;
                while (i < pp.length) {
                    listPE.add(pp[i]);
                    ++i;
                }
            }
            if (pp == null || pp.length == 0 || pp[pp.length - 1].getLat() != to.getLat() || pp[pp.length].getLon() != to.getLon()) {
                no = new NavigationPoint();
                no.setLat(to.getLat());
                no.setLon(to.getLon());
                listPE.add(no);
            }
            pp = listPE.toArray(new NavigationPoint[listPE.size()]);
            PolygonStringPresentation.this.buildPolygonRoute(pp);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }

        public String getName() {
            return "\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043f\u0443\u0442\u044c";
        }
    };

    public PolygonStringPresentation(Integer typeVariable, String keyPage) {
        super(keyPage);
        Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        this.mapValuePolygon = new MapValuePolygon(coord[0], coord[1], coord[2].intValue(), this);
        this.typeVariable = typeVariable;
    }

    public void beforeShow(PanelContext panelContext) {
        this.pc = panelContext;
        this.isPoint = Integer.valueOf(1).equals(this.typeVariable);
        this.setTitle("\u041e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u043e\u043a\u0440\u0443\u0433 \u0442\u043e\u0447\u043a\u0438 \u043d\u0430 \u043a\u0430\u0440\u0442\u0435");
        if (!Integer.valueOf(1).equals(this.typeVariable)) {
            this.setTitle("\u041c\u0430\u0440\u0448\u0440\u0443\u0442");
        }
        this.pc.getPanel().updateUIForPresentatorName("title");
    }

    @ListField(fields={@Field(title="", keyView="point", order=100, propertiesLayout="Split1/h/l/0.3:Tab1/\u0422\u043e\u0447\u043a\u0430:0/fillx, wrap 2#cell 1 0#cell 0 0", propertiesUI={"background=#FFFFE1", "font=+2", "horizontalalignment=center"}, readOnly=true), @Field(title="", keyView="route", order=100, propertiesLayout="Split1/h/l/0.3:Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442:0/fillx, wrap 2#cell 1 0#cell 0 0", propertiesUI={"background=#FFFFE1", "font=+2", "horizontalalignment=center"}, readOnly=true)})
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @ListField(fields={@Field(title="\u0428\u0438\u0440\u043e\u0442\u0430", keyView="point", order=200, propertiesLayout="Split1/h/l/0.3:Tab1/\u0422\u043e\u0447\u043a\u0430:0/fillx, wrap 2#cell 1 1#cell 0 1")})
    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    @ListField(fields={@Field(title="\u0414\u043e\u043b\u0433\u043e\u0442\u0430", keyView="point", order=300, propertiesLayout="Split1/h/l/0.3:Tab1/\u0422\u043e\u0447\u043a\u0430:0#cell 1 2#cell 0 2")})
    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    @ListField(fields={@Field(title="\u0420\u0430\u0434\u0438\u0443\u0441 (\u043c)", keyView="point", order=400, propertiesLayout="Split1/h/l/0.3:Tab1/\u0422\u043e\u0447\u043a\u0430:0#cell 1 3#cell 0 3")})
    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    @ListField(fields={@Field(title="", order=500, keyView="point", propertiesLayout="Split1/h/l/0.3:Tab1/\u0422\u043e\u0447\u043a\u0430:0/fillx#cell 1 4#cell 0 4", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBuildR() {
        return this.buildR;
    }

    @ListField(fields={@Field(title="\u0422\u043e\u0447\u043a\u0430 1 \u0448\u0438\u0440\u043e\u0442\u0430", keyView="route", order=200, propertiesLayout="Split1/h/l/0.3:Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442:0/fillx, wrap 2#cell 1 1#cell 0 1, align right")})
    public Double getLat1() {
        return this.lat1;
    }

    public void setLat1(Double lat1) {
        this.lat1 = lat1;
    }

    @ListField(fields={@Field(title="\u0434\u043e\u043b\u0433\u043e\u0442\u0430", keyView="route", order=300, propertiesLayout="Split1/h/l/0.3:Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442:0/fillx, wrap 2#cell 1 2#cell 0 2, align right")})
    public Double getLon1() {
        return this.lon1;
    }

    public void setLon1(Double lon1) {
        this.lon1 = lon1;
    }

    @ListField(fields={@Field(title="\u0422\u043e\u0447\u043a\u0430 2 \u0448\u0438\u0440\u043e\u0442\u0430", keyView="route", order=400, propertiesLayout="Split1/h/l/0.3:Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442:0/fillx, wrap 2#cell 1 3#cell 0 3, align right")})
    public Double getLat2() {
        return this.lat2;
    }

    public void setLat2(Double lat2) {
        this.lat2 = lat2;
    }

    @ListField(fields={@Field(title="\u0434\u043e\u043b\u0433\u043e\u0442\u0430", keyView="route", order=500, propertiesLayout="Split1/h/l/0.3:Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442:0/fillx, wrap 2#cell 1 4#cell 0 4, align right")})
    public Double getLon2() {
        return this.lon2;
    }

    public void setLon2(Double lon2) {
        this.lon2 = lon2;
    }

    @ListField(fields={@Field(title="\u0428\u0438\u0440\u0438\u043d\u0430 \u043f\u0443\u0442\u0438", keyView="route", order=600, propertiesLayout="Split1/h/l/0.3:Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442:0/fillx, wrap 2#cell 1 5#cell 0 5, align right")})
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @ListField(fields={@Field(title="", order=700, keyView="route", propertiesLayout="Split1/h/l/0.3:Tab1/\u041c\u0430\u0440\u0448\u0440\u0443\u0442:0/fillx#cell 1 6#cell 0 6", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBuildPath() {
        return this.buildPath;
    }

    @ListField(fields={@Field(title="", order=2000, keyView="route", propertiesLayout="Split1/h/r/0.3", viewer={MapViewerPolygon.class}), @Field(title="", order=2000, keyView="point", propertiesLayout="Split1/h/r/0.3", viewer={MapViewerPolygon.class})})
    public MapValuePolygon getMapValuePolygon() {
        return this.mapValuePolygon;
    }

    public void setMapValuePolygon(MapValuePolygon mapValuePolygon) {
        this.mapValuePolygon = mapValuePolygon;
    }

    public void buildPolygonRoute(NavigationPoint[] pp) {
        GeometryFactory f = new GeometryFactory();
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
            Coordinate[] cc = new Coordinate[pp.length];
            int i = 0;
            while (i < pp.length) {
                GeneralDirectPosition pt1 = new GeneralDirectPosition(pp[i].getLon().doubleValue(), pp[i].getLat().doubleValue());
                DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                cc[i] = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                ++i;
            }
            LineString s = f.createLineString(cc);
            Geometry buffer = s.buffer((double)this.width.intValue());
            if (buffer instanceof Polygon) {
                Polygon p = (Polygon)buffer;
                Coordinate[] cc1 = new Coordinate[p.getCoordinates().length];
                int i2 = 0;
                while (i2 < p.getCoordinates().length) {
                    Coordinate c = p.getCoordinates()[i2];
                    GeneralDirectPosition pt11 = new GeneralDirectPosition(c.x, c.y);
                    DirectPosition pt22 = math2.transform((DirectPosition)pt11, null);
                    cc1[i2] = new Coordinate(pt22.getCoordinate()[0], pt22.getCoordinate()[1]);
                    ++i2;
                }
                Polygon p2 = f.createPolygon(f.createLinearRing(cc1), null);
                this.setPolygon(p2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildPolygon() {
        GeometryFactory f = new GeometryFactory();
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
            GeneralDirectPosition pt1 = new GeneralDirectPosition(this.getLon().doubleValue(), this.getLat().doubleValue());
            DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
            Coordinate cc = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
            Point point = f.createPoint(cc);
            Geometry buffer = point.buffer((double)this.radius.intValue());
            if (buffer instanceof Polygon) {
                Polygon p = (Polygon)buffer;
                Coordinate[] cc1 = new Coordinate[p.getCoordinates().length];
                int i = 0;
                while (i < p.getCoordinates().length) {
                    Coordinate c = p.getCoordinates()[i];
                    GeneralDirectPosition pt11 = new GeneralDirectPosition(c.x, c.y);
                    DirectPosition pt22 = math2.transform((DirectPosition)pt11, null);
                    cc1[i] = new Coordinate(pt22.getCoordinate()[0], pt22.getCoordinate()[1]);
                    ++i;
                }
                Polygon p2 = f.createPolygon(f.createLinearRing(cc1), null);
                this.setPolygon(p2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFlagFromMap(GeoPosition gp) {
        if (this.isPoint) {
            this.setLat(gp.getLatitude());
            this.setLon(gp.getLongitude());
            this.updateUI();
        } else {
            if (this.getLat1() == null) {
                this.setLat1(gp.getLatitude());
                this.setLon1(gp.getLongitude());
            } else if (this.getLat2() == null) {
                this.setLat2(gp.getLatitude());
                this.setLon2(gp.getLongitude());
            } else {
                this.setLat1(this.getLat2());
                this.setLon1(this.getLon2());
                this.setLat2(gp.getLatitude());
                this.setLon2(gp.getLongitude());
            }
            this.updateUI2();
        }
    }

    public void updateUI2() {
        this.pc.getPanel().updateUIForPresentatorName("lat1");
        this.pc.getPanel().updateUIForPresentatorName("lon1");
        this.pc.getPanel().updateUIForPresentatorName("lat2");
        this.pc.getPanel().updateUIForPresentatorName("lon2");
    }

    public void updateUI() {
        this.pc.getPanel().updateUIForPresentatorName("lat");
        this.pc.getPanel().updateUIForPresentatorName("lon");
    }

    public void setPolygon(Polygon polygon) {
        this.polygon = polygon;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public GeoPosition[] getFlags() {
        GeoPosition[] ggp = new GeoPosition[2];
        if (this.isPoint) {
            if (this.getLat() != null && this.getLon() != null) {
                ggp[0] = new GeoPosition(this.getLat().doubleValue(), this.getLon().doubleValue());
            }
        } else {
            if (this.getLat1() != null && this.getLon1() != null) {
                ggp[0] = new GeoPosition(this.getLat1().doubleValue(), this.getLon1().doubleValue());
            }
            if (this.getLat2() != null && this.getLon2() != null) {
                ggp[1] = new GeoPosition(this.getLat2().doubleValue(), this.getLon2().doubleValue());
            }
        }
        return ggp;
    }
}

