/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mobiledevice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.PeriodDateClass;
import ru.blok.common.report.RunReport;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.HelpUtils;
import ru.blok.vms.ui.event.ObjectUIListWithAutoRefresh;
import ru.blok.vms.ui.mobiledevice.ListMessagesViewer;
import ru.blok.vms.ui.mobiledevice.MobileDevicePanelBtn;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.ManagerBeanPanel;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.client.soap.proxy.core.UsersGroupWSProxy;
import ru.infor.client.soap.proxy.vms.DeviceMessagesWSProxy;
import ru.infor.client.soap.proxy.vms.Transport2MobileDeviceLinkWSProxy;
import ru.infor.client.soap.proxy.vms.TransportStatusWSProxy;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.core.UsersGroupSearchCriteria;
import ru.infor.ws.objects.core.entities.UsersGroup;
import ru.infor.ws.objects.vms.DeviceMessagesSearchCriteria;
import ru.infor.ws.objects.vms.Transport2DeviceLinkSearchCriteria;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.TransportStatusSearchCriteria;
import ru.infor.ws.objects.vms.entities.DeviceMessages;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.Transport2MobileDeviceLink;
import ru.infor.ws.objects.vms.entities.TransportStatus;
import ru.infor.ws.objects.vms.ext.MobileDeviceWithTS;

@ListView(views={@View(title="", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class MobileDeviceStatusList
extends CommonObjectWithKey {
    private List<MobileDeviceWithTS> items;
    private List<DeviceMessages> itemsM;
    Transport2MobileDeviceLinkWSProxy mobileLinkWSProxy = (Transport2MobileDeviceLinkWSProxy)CurrentProxyFactory.getProxy(Transport2MobileDeviceLink.class, (String)this.getKeyPage());
    DeviceMessagesWSProxy proxyMes = (DeviceMessagesWSProxy)CurrentProxyFactory.getProxy(DeviceMessages.class, (String)this.getKeyPage());
    DeviceMessagesSearchCriteria messagesSearchCriteria;
    boolean refreshData = true;
    HashMap<String, String> sp = null;
    Date dateFrom;
    Date dateTill;
    Integer dependentEL = 0;
    TransportStatus transportStatus;
    List<Long> initiatorIdList = new ArrayList<Long>();
    PanelContext currentPC;
    static int countMessages = 20;
    static Long timeRepeat = 10000L;
    List<Object> selDetP;

    public void beforeShow(PanelContext pc) {
        this.setCurrentPC(pc);
        FieldPresentation fp = pc.getPanel().getPresentatorForName("items");
        ManagerBeanPanel pp = ((BigContentViewer)fp.getViewer()).getManagerBeanPanelForName("Update");
        MobileDevicePanelBtn panBtn = (MobileDevicePanelBtn)pp.getObject();
        panBtn.setDateFrom(this.getDateFrom());
        panBtn.setDateTill(this.getDateTill());
        panBtn.setDependentEL(this.getDependentEL());
        if (this.getTransportStatus() != null) {
            panBtn.setTransportStatus(this.getTransportStatus());
        }
        this.setTransportStatus(null);
        pp.updateUI();
    }

    public MobileDeviceStatusList(String keyPage) {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)this.getKeyPage()) != null) {
            this.sp = InitializedVariable.runtimeParameters((String)this.getKeyPage(), (Long)InitializedVariable.getWorkplaceId((String)this.getKeyPage()));
        }
        PeriodDateClass pd = new PeriodDateClass(this.sp);
        this.setDateFrom(pd.getFirstDate());
        this.setDateTill(pd.getLastDate());
        TransportStatusWSProxy transportSWSProxy = (TransportStatusWSProxy)CurrentProxyFactory.getProxy(TransportStatus.class, (String)this.getKeyPage());
        TransportStatusSearchCriteria dsc = new TransportStatusSearchCriteria();
        dsc.setCount(Integer.valueOf(1));
        dsc.appendSorting(SortObject.getInstance((String)"code", (String)SortObject.DIRECTION_ASC));
        TransportStatusWSProxy.SearchResultListTransportStatus sr = transportSWSProxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), dsc);
        TransportStatus ts = null;
        if (!sr.isEmpty()) {
            ts = (TransportStatus)sr.getObjList()[0];
        }
        this.setTransportStatus(ts);
        this.init();
    }

    public void init() {
        this.setRefreshData(false);
        this.initData();
        this.initEvents();
        this.startCycle();
    }

    public void startCycle() {
        new Thread(){

            @Override
            public void run() {
                System.out.println("beginning startCycle - " + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date()));
                MobileDeviceStatusList.this.setRefreshData(true);
                if (MobileDeviceStatusList.this.getDateTill().compareTo(new Date()) < 0) {
                    MobileDeviceStatusList.this.setRefreshData(false);
                }
                while (MobileDeviceStatusList.this.items.size() > 0) {
                    if (!MobileDeviceStatusList.this.isRefreshData()) break;
                    System.out.println(" start repeat....");
                    MobileDeviceStatusList.this.updateMessagesList();
                    MobileDeviceStatusList.this.updateStatus();
                    try {
                        Thread.sleep(timeRepeat);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    protected void updateStatus() {
        ArrayList<Long> listTSID = new ArrayList<Long>();
        int i = 0;
        while (i < this.items.size()) {
            listTSID.add(this.items.get(i).getTransportId());
            ++i;
        }
        TransportWSProxy proxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class, (String)this.getKeyPage());
        TransportSearchCriteria tSC = new TransportSearchCriteria();
        tSC.setCount(Integer.valueOf(Integer.MAX_VALUE));
        tSC.setIdList(listTSID.toArray(new Long[listTSID.size()]));
        TransportWSProxy.SearchResultListTransport sr = proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), tSC);
        if (!sr.isEmpty()) {
            HashMap<Long, String> map = new HashMap<Long, String>();
            int i2 = 0;
            while (i2 < sr.getObjList().length) {
                Transport ts = (Transport)sr.getObjList()[i2];
                map.put(ts.getId(), ts.getTransportStatus() == null ? " - " : String.valueOf(ts.getTransportStatus().getCode()) + " - " + ts.getTransportStatus().getDescription());
                ++i2;
            }
            boolean isChange = false;
            int i3 = 0;
            while (i3 < this.items.size()) {
                MobileDeviceWithTS mdts = this.items.get(i3);
                if (!((String)map.get(mdts.getTransportId())).equals(mdts.getStatusName())) {
                    mdts.setStatusName((String)map.get(mdts.getTransportId()));
                    isChange = true;
                }
                ++i3;
            }
            if (isChange) {
                this.getCurrentPC().getPanel().updateUI();
            }
        }
    }

    private void initData() {
        this.items = new ArrayList<MobileDeviceWithTS>();
        Transport2DeviceLinkSearchCriteria t2dSC = new Transport2DeviceLinkSearchCriteria();
        t2dSC.setCount(Integer.valueOf(Integer.MAX_VALUE));
        t2dSC.setActiveOnDate(new Date());
        Transport2MobileDeviceLinkWSProxy.SearchResultListTransport2MobileDeviceLink srT2D = this.mobileLinkWSProxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), t2dSC);
        if (!srT2D.isEmpty()) {
            ArrayList<Long> listGrID = new ArrayList<Long>();
            int i = 0;
            while (i < srT2D.getObjList().length) {
                Transport2MobileDeviceLink t2mdl = (Transport2MobileDeviceLink)srT2D.getObjList()[i];
                if (t2mdl.getDevice() != null && t2mdl.getTransport() != null) {
                    MobileDeviceWithTS mdts = new MobileDeviceWithTS(t2mdl.getDevice(), t2mdl.getTransport());
                    if (t2mdl.getTransport().getCreatedBy_id() != null) {
                        UsersGroup group = HelpUtils.getPrimaryGroup(t2mdl.getTransport().getCreatedBy_id());
                        listGrID.add(group.getId());
                        mdts.setGroupId(group.getId());
                        mdts.setGroupTS("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430");
                        this.items.add(mdts);
                    }
                }
                ++i;
            }
            UsersGroupWSProxy proxy = (UsersGroupWSProxy)CurrentProxyFactory.getProxy(UsersGroup.class, (String)this.getKeyPage());
            UsersGroupSearchCriteria criteria = new UsersGroupSearchCriteria();
            criteria.setIdList(listGrID.toArray(new Long[listGrID.size()]));
            UsersGroupWSProxy.SearchResultListUsersGroup sr = proxy.getUsersGroupList(InitializedVariable.getContext((String)this.getKeyPage()), criteria);
            if (!sr.isEmpty()) {
                HashMap<Long, String> map = new HashMap<Long, String>();
                int i2 = 0;
                while (i2 < sr.getObjList().length) {
                    map.put(((UsersGroup)sr.getObjList()[i2]).getId(), ((UsersGroup)sr.getObjList()[i2]).getName());
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.items.size()) {
                    MobileDeviceWithTS mdts = this.items.get(i2);
                    if (mdts.getGroupId() != null && map.get(mdts.getGroupId()) != null) {
                        mdts.setGroupTS((String)map.get(mdts.getGroupId()));
                    }
                    ++i2;
                }
            }
        }
    }

    private void initEvents() {
        this.itemsM = new ObjectUIListWithAutoRefresh<DeviceMessages>(DeviceMessages.class, this.getKeyPage());
        this.messagesSearchCriteria = (DeviceMessagesSearchCriteria)((ObjectUIList)this.itemsM).getSearchCriteria();
        this.messagesSearchCriteria.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_DESC));
        this.messagesSearchCriteria.setDateFrom(this.getDateFrom());
        this.messagesSearchCriteria.setDateTill(this.getDateTill());
        this.messagesSearchCriteria.setCount(Integer.valueOf(countMessages));
        ((ObjectUIListWithAutoRefresh)((Object)this.itemsM)).setTotalFill(true);
    }

    public void updateMessagesList() {
        this.messagesSearchCriteria = (DeviceMessagesSearchCriteria)((ObjectUIList)this.itemsM).getSearchCriteria();
        this.messagesSearchCriteria.setDateFrom(this.getDateFrom());
        this.messagesSearchCriteria.setDateTill(this.getDateTill());
        ArrayList<Long> ll = new ArrayList<Long>();
        if (this.getDependentEL() == 1) {
            if (this.getInitiatorIdList() == null || this.getInitiatorIdList().size() == 0) {
                ll.add(-1L);
                this.setInitiatorIdList(ll);
            }
        } else {
            int i = 0;
            while (i < this.getItems().size()) {
                if (this.getItems().get(i).getDeviceId() != null) {
                    ll.add(this.getItems().get(i).getDeviceId());
                }
                ++i;
            }
            if (ll == null || ll.size() == 0) {
                ll.add(-1L);
            }
            this.setInitiatorIdList(ll);
        }
        this.messagesSearchCriteria.setDeviceIdList(this.getInitiatorIdList().toArray(new Long[this.getInitiatorIdList().size()]));
        this.messagesSearchCriteria.setCount(Integer.valueOf(countMessages));
        ((ObjectUIListWithAutoRefresh)((Object)this.itemsM)).compromateAllData();
    }

    @ListField(fields={@Field(title="", order=100, propertiesField={"className=ru.infor.ws.objects.vms.ext.MobileDeviceWithTS"}, viewer={ListViewer.class}, propertiesLayout="Split1/v/l/0.3", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=RunReport.class)}), @PanelField(name="\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", order=20, classView={@ClassView(clazz=MobileDevicePanelBtn.class, order=20, name="Update")})}, content=MobileDeviceWithTS.class)})
    public List<MobileDeviceWithTS> getItems() {
        return this.items;
    }

    public void setItems(List<MobileDeviceWithTS> items) {
        this.items = items;
    }

    public void setMasterObjectsItemsM(List<Object> selDetP) {
        this.selDetP = selDetP;
    }

    @ListField(fields={@Field(title="\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", master="items", order=300, propertiesField={"className=ru.infor.ws.objects.vms.entities.DeviceMessages"}, viewer={ListMessagesViewer.class}, propertiesLayout="Split1/v/r/0.7", panels={}, content=DeviceMessages.class)})
    public List<DeviceMessages> getItemsM() {
        if (this.getDependentEL() == 1) {
            this.changeInitiator();
            this.updateMessagesList();
        }
        return this.itemsM;
    }

    public void changeInitiator() {
        if (this.getDependentEL() == 1) {
            ArrayList<Long> idDocList = new ArrayList<Long>();
            if (this.selDetP != null) {
                int i = 0;
                while (i < this.selDetP.size()) {
                    if (((MobileDeviceWithTS)this.selDetP.get(i)).getDeviceId() != null) {
                        idDocList.add(((MobileDeviceWithTS)this.selDetP.get(i)).getDeviceId());
                    }
                    ++i;
                }
            } else if (this.getInitiatorIdList() != null && this.getInitiatorIdList().size() > 0) {
                idDocList.add(this.getInitiatorIdList().get(0));
            }
            this.setInitiatorIdList(idDocList);
        }
    }

    public void setItemsM(List<DeviceMessages> itemsM) {
        this.itemsM = itemsM;
    }

    public void beforeDestroy(PanelContext pc) {
        this.setRefreshData(false);
        ((ObjectUIListWithAutoRefresh)((Object)this.itemsM)).stopAutoRefresh();
    }

    public boolean isRefreshData() {
        return this.refreshData;
    }

    public void setRefreshData(boolean refreshData) {
        this.refreshData = refreshData;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTill() {
        return this.dateTill;
    }

    public void setDateTill(Date dateTill) {
        this.dateTill = dateTill;
    }

    public Integer getDependentEL() {
        return this.dependentEL;
    }

    public void setDependentEL(Integer dependentEL) {
        this.dependentEL = dependentEL;
    }

    public TransportStatus getTransportStatus() {
        return this.transportStatus;
    }

    public void setTransportStatus(TransportStatus transportStatus) {
        this.transportStatus = transportStatus;
    }

    public List<Long> getInitiatorIdList() {
        return this.initiatorIdList;
    }

    public void setInitiatorIdList(List<Long> initiatorIdList) {
        this.initiatorIdList = initiatorIdList;
    }

    public PanelContext getCurrentPC() {
        return this.currentPC;
    }

    public void setCurrentPC(PanelContext currentPC) {
        this.currentPC = currentPC;
    }
}

