/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.navigationdevice.devicesstates;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.MultiLineString;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.navigationdevice.devicesstates.DeviceStatesViewer;
import ru.blok.vms.ui.navigationdevice.devicesstates.MapValueDevicesStates;

public class ManyRoutePainter<T extends JXMapViewer>
extends MapViewPainter<JXMapViewer> {
    static Color c = Color.GREEN;
    public static Stroke defaultStroke = new BasicStroke(2.0f, 1, 1);
    MapValueDevicesStates mapValueDevicesStates;

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.mapValueDevicesStates.getMapWB() != null) {
            for (DeviceStatesViewer.WarrantRealTimeExt w : this.mapValueDevicesStates.getMapWB().values()) {
                if (!w.isShowRouteOnMap() || w.getRoute() == null || w.getRoute().getRouteGeom() == null) continue;
                try {
                    MultiLineString lineString = new MultiLineString(w.getRoute().getRouteGeom());
                    if (lineString == null) continue;
                    int from = 0;
                    Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(lineString.getPoint(from).getY(), lineString.getPoint(from).getX()), map.getZoom());
                    int i = 1;
                    while (i < lineString.numPoints()) {
                        Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(lineString.getPoint(i).getY(), lineString.getPoint(i).getX()), map.getZoom());
                        this.paint(pointFrom, pointTo, map, g, vp2, vp3);
                        from = i++;
                        pointFrom = pointTo;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void paint(Point2D pointFrom, Point2D point, JXMapViewer map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (vp2.contains(point) || vp2.contains(pointFrom)) {
            g.setColor(c);
            g.setStroke(defaultStroke);
            g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
        }
        if (vp3.contains(point) || vp3.contains(pointFrom)) {
            g.setColor(c);
            g.setStroke(defaultStroke);
            g.drawLine((int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), (int)(pointFrom.getX() - vp3.getX()), (int)(pointFrom.getY() - vp3.getY()));
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.mapValueDevicesStates = (MapValueDevicesStates)mapValueWithTrack;
    }
}

