/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.navigationdevice.devicesstates;

import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.navigationdevice.devicesstates.DeviceStatesViewer;
import ru.blok.vms.ui.navigationdevice.devicesstates.ManyRoutePainter;
import ru.blok.vms.ui.navigationdevice.devicesstates.MapDevicePainter;
import ru.blok.vms.ui.navigationdevice.devicesstates.MapValueDevicesStates;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.NDDataThin;

public class MapViewerDevicesStates
extends MapViewer {
    MapValueDevicesStates mapValueDevicesStates;
    MapDevicePainter<JXMapViewer> wpp;
    ManyRoutePainter<JXMapViewer> rp;

    public MapViewerDevicesStates(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    public void setValue(Object arg0) {
        if (arg0 != null) {
            this.mapValueDevicesStates = (MapValueDevicesStates)arg0;
            this.mapValueDevicesStates.mapViewer = this;
            super.setValue(this.mapValueDevicesStates.getMapValue());
            this.wpp = new MapDevicePainter();
            this.wpp.setValue(this.mapValueDevicesStates);
            this.painter.addPainter(this.wpp);
            this.rp = new ManyRoutePainter();
            this.rp.setValue(this.mapValueDevicesStates);
            this.painter.addPainter(this.rp);
        }
    }

    @Override
    public Object getValue() {
        if (this.mapValueDevicesStates != null && this.mapValueDevicesStates.getMapValue() != null) {
            this.mapValueDevicesStates.getMapValue().setLat(this.map.getMainMap().getCenterPosition().getLatitude());
            this.mapValueDevicesStates.getMapValue().setLon(this.map.getMainMap().getCenterPosition().getLongitude());
            this.mapValueDevicesStates.getMapValue().setZoom(this.map.getMainMap().getZoom());
        }
        return this.mapValueDevicesStates;
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                double y;
                double x = MapViewerDevicesStates.this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(MapViewerDevicesStates.this.map.getMainMap().getWidth() / 2);
                Point2D.Double p = new Point2D.Double(x, y = MapViewerDevicesStates.this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(MapViewerDevicesStates.this.map.getMainMap().getHeight() / 2));
                DeviceStatesViewer.WarrantRealTimeExt w = MapViewerDevicesStates.this.inPoint(p);
                if (w != null) {
                    w.setSelect(!w.isSelect());
                    MapViewerDevicesStates.this.repaint();
                }
            }
        });
    }

    private DeviceStatesViewer.WarrantRealTimeExt inPoint(Point2D p) {
        for (DeviceStatesViewer.WarrantRealTimeExt w : this.mapValueDevicesStates.getMapWB().values()) {
            boolean i;
            if (!w.isShowOnMap() || w.getW().getNddata() == null || !(i = this.include(p, w))) continue;
            return w;
        }
        return null;
    }

    private boolean include(Point2D pClick, DeviceStatesViewer.WarrantRealTimeExt w) {
        NDDataThin d = w.getW().getNddata();
        if (d == null) {
            return false;
        }
        Point2D pDev = this.map.getMainMap().getTileFactory().geoToPixel(new GeoPosition(d.getLat().doubleValue(), d.getLon().doubleValue()), this.map.getMainMap().getZoom());
        Point2D.Double p1 = new Point2D.Double(pClick.getX() - pDev.getX(), pClick.getY() - pDev.getY());
        double dx = Math.abs(((Point2D)p1).getX());
        double dy = Math.abs(((Point2D)p1).getY());
        if (dx < 7.0 && dy < 7.0) {
            return true;
        }
        if (w.isSelect()) {
            int l = w.getHint().length;
            int k = 0;
            int i = 0;
            while (i < l) {
                if (w.getHint()[i].length() > k) {
                    k = w.getHint()[i].length();
                }
                ++i;
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double(-k * 8 + k * 8 / 2, -12 * l - 20, k * 8 + 10, 12 * l + 3);
            Polygon p = new Polygon();
            p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
            p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
            p.addPoint((int)(bounds.getMinX() + ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
            p.addPoint(0, 0);
            p.addPoint((int)(bounds.getMinX() + 2.0 * ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
            p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
            p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
            if (p.contains(p1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        for (DeviceStatesViewer.WarrantRealTimeExt w : this.mapValueDevicesStates.getMapWB().values()) {
            NDDataThin d = w.getW().getNddata();
            if (d == null) continue;
            if (minLat == null || d.getLat() < minLat) {
                minLat = d.getLat();
            }
            if (maxLat == null || d.getLat() > maxLat) {
                maxLat = d.getLat();
            }
            if (minLon == null || d.getLon() < minLon) {
                minLon = d.getLon();
            }
            if (maxLon != null && !(d.getLon() > maxLon)) continue;
            maxLon = d.getLon();
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }
}

