/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.navigationdevice.radiobeacon;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.client.soap.proxy.vms.EventWSProxy;
import ru.infor.client.soap.proxy.vms.ImportanceEventWSProxy;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.client.soap.proxy.vms.ReactionTypeWSProxy;
import ru.infor.client.soap.proxy.vms.RecordTypeWSProxy;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.events.entities.Event;
import ru.infor.ws.objects.events.entities.ImportanceEvent;
import ru.infor.ws.objects.events.entities.ReactionType;
import ru.infor.ws.objects.vms.NavigationDeviceSearchCriteria;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.RecordType;

public class ConverterMessage2NDData {
    static SimpleDateFormat dfs = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    static NDDataWSProxy proxyNDData = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
    static NavigationDeviceWSProxy proxy = (NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class);
    static NavigationDeviceSearchCriteria ndSc = new NavigationDeviceSearchCriteria();
    static RecordTypeWSProxy proxyRT = (RecordTypeWSProxy)CurrentProxyFactory.getProxy(RecordType.class);
    static ReactionTypeWSProxy reactionTypeProxy = (ReactionTypeWSProxy)CurrentProxyFactory.getProxy(ReactionType.class);
    static ImportanceEventWSProxy importanceEventProxy = (ImportanceEventWSProxy)CurrentProxyFactory.getProxy(ImportanceEvent.class);
    static EventWSProxy eventProxy = (EventWSProxy)CurrentProxyFactory.getProxy(Event.class);

    public static void main(String[] args) {
        ConverterMessage2NDData.callConverter();
    }

    public static void callConverter() {
        String str = ConverterMessage2NDData.loadFromFile("c:/5/RCC406E_old.FMT");
        ConverterMessage2NDData.converter(str, null);
    }

    public static Integer converter(String str, Date messageDate) {
        int k2;
        int k1 = str.indexOf("CMC REF:");
        String imei = str.substring(k1 + 9, k2 = str.indexOf("\n", k1 + 15));
        if (imei == null || imei.trim().equals("")) {
            return -1;
        }
        k1 = str.indexOf("DETECTED AT:");
        k2 = str.indexOf("UTC  BY", k1 + 15);
        String datetime = str.substring(k1 + 12, k2).trim();
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd MMM yy  HHmm", Locale.ENGLISH);
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date myDate = df.parse(datetime);
            SimpleDateFormat dfR = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            dfR.setTimeZone(TimeZone.getDefault());
            dfs.parse(dfR.format(myDate));
        }
        catch (ParseException parseException) {}
        Double lat = 0.0;
        Double lon = 0.0;
        k1 = str.indexOf("30-HEX MSG:");
        k2 = str.indexOf("HOMING", k1 + 1);
        String hexid = str.substring(k1 + 11, k2);
        if (hexid == null || hexid.trim().equals("")) {
            k1 = str.indexOf("BEACON REGISTRATION:");
            k2 = str.indexOf("6.", k1 + 11);
            str.substring(k1 + 20, k2).trim();
            k1 = str.indexOf("CERTIFICATE NO:");
            k2 = str.indexOf("BEACON MODEL", k1 + 16);
            str.substring(k1 + 15, k2).trim();
            k1 = str.indexOf("SERIAL NO:");
            k2 = str.indexOf("7.", k1 + 11);
            str.substring(k1 + 10, k2).trim();
        } else {
            String soub = new BigInteger(hexid.trim(), 16).toString(2);
            String.valueOf(ConverterMessage2NDData.getValue(soub, 27, 36)).trim();
            String.valueOf(ConverterMessage2NDData.getValue(soub, 41, 50)).trim();
            String.valueOf(ConverterMessage2NDData.getValue(soub, 51, 64)).trim();
            lat = ConverterMessage2NDData.getValue(soub, 66, 72).doubleValue() + ConverterMessage2NDData.getValue(soub, 73, 74).doubleValue() / 4.0;
            lon = ConverterMessage2NDData.getValue(soub, 76, 83).doubleValue() + ConverterMessage2NDData.getValue(soub, 84, 85).doubleValue() / 4.0;
            if (Integer.valueOf(0).equals(ConverterMessage2NDData.getValue(soub, 111, 111))) {
                Double latCorr = (ConverterMessage2NDData.getValue(soub, 114, 118).doubleValue() + ConverterMessage2NDData.getValue(soub, 119, 122).doubleValue() / 60.0) / 60.0;
                Double lonCorr = (ConverterMessage2NDData.getValue(soub, 124, 128).doubleValue() + ConverterMessage2NDData.getValue(soub, 129, 132).doubleValue() / 60.0) / 60.0;
                lat = ConverterMessage2NDData.getValue(soub, 113, 113).equals(0) ? Double.valueOf(lat - latCorr) : Double.valueOf(lat + latCorr);
                lon = ConverterMessage2NDData.getValue(soub, 123, 123).equals(0) ? Double.valueOf(lon - lonCorr) : Double.valueOf(lon + lonCorr);
            }
        }
        return 0;
    }

    public static Integer converter2(String str, Date messageDate) {
        int k2;
        Date nddataDate = messageDate;
        int k1 = str.indexOf("CMC REF:");
        String imei = str.substring(k1 + 9, k2 = str.indexOf("\n", k1 + 15));
        if (imei == null || imei.trim().equals("")) {
            return -1;
        }
        ndSc.setImei("*" + imei.trim() + "*");
        NavigationDeviceWSProxy.SearchResultListNavigationDevice sr = proxy.getList(InitializedVariable.context, ndSc);
        if (sr.isEmpty()) {
            return -2;
        }
        NavigationDevice nd = (NavigationDevice)sr.getObjList()[0];
        if (nddataDate == null) {
            k1 = str.indexOf("DETECTED AT:");
            k2 = str.indexOf("UTC  BY MSG", k1 + 15);
            String datetime = str.substring(k1 + 12, k2).trim();
            try {
                SimpleDateFormat df = new SimpleDateFormat("dd MMM yy  HHmm", Locale.ENGLISH);
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date myDate = df.parse(datetime);
                SimpleDateFormat dfR = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                dfR.setTimeZone(TimeZone.getDefault());
                nddataDate = dfs.parse(dfR.format(myDate));
            }
            catch (ParseException parseException) {}
        }
        if (nddataDate == null) {
            return -3;
        }
        String country = "";
        String certificateNo = "";
        String serialNo = "";
        Double lat = 0.0;
        Double lon = 0.0;
        k1 = str.indexOf("30-HEX MSG:");
        String hexid = str.substring(k1 + 11, k2 = str.indexOf("HOMING", k1 + 1));
        if (hexid == null || hexid.trim().equals("")) {
            k1 = str.indexOf("BEACON REGISTRATION:");
            k2 = str.indexOf("6.", k1 + 11);
            country = str.substring(k1 + 20, k2).trim();
            k1 = str.indexOf("CERTIFICATE NO:");
            k2 = str.indexOf("BEACON MODEL", k1 + 16);
            certificateNo = str.substring(k1 + 15, k2).trim();
            k1 = str.indexOf("SERIAL NO:");
            k2 = str.indexOf("7.", k1 + 11);
            serialNo = str.substring(k1 + 10, k2).trim();
        } else {
            String soub = new BigInteger(hexid.trim(), 16).toString(2);
            country = String.valueOf(ConverterMessage2NDData.getValue(soub, 27, 36)).trim();
            certificateNo = String.valueOf(ConverterMessage2NDData.getValue(soub, 41, 50)).trim();
            serialNo = String.valueOf(ConverterMessage2NDData.getValue(soub, 51, 64)).trim();
            lat = ConverterMessage2NDData.getValue(soub, 66, 72).doubleValue() + ConverterMessage2NDData.getValue(soub, 73, 74).doubleValue() / 4.0;
            lon = ConverterMessage2NDData.getValue(soub, 76, 83).doubleValue() + ConverterMessage2NDData.getValue(soub, 84, 85).doubleValue() / 4.0;
            if (Integer.valueOf(0).equals(ConverterMessage2NDData.getValue(soub, 111, 111))) {
                Double latCorr = (ConverterMessage2NDData.getValue(soub, 114, 118).doubleValue() + ConverterMessage2NDData.getValue(soub, 119, 122).doubleValue() / 60.0) / 60.0;
                Double lonCorr = (ConverterMessage2NDData.getValue(soub, 124, 128).doubleValue() + ConverterMessage2NDData.getValue(soub, 129, 132).doubleValue() / 60.0) / 60.0;
                lat = ConverterMessage2NDData.getValue(soub, 113, 113).equals(0) ? Double.valueOf(lat - latCorr) : Double.valueOf(lat + latCorr);
                lon = ConverterMessage2NDData.getValue(soub, 123, 123).equals(0) ? Double.valueOf(lon - lonCorr) : Double.valueOf(lon + lonCorr);
            }
        }
        NDData ndd = ConverterMessage2NDData.saveNDData(InitializedVariable.context, nd.getId(), nddataDate, lat, lon);
        if (ndd == null || ndd.getId().compareTo(0L) < 1) {
            return -4;
        }
        Event event = ConverterMessage2NDData.createEvent(InitializedVariable.context, ndd, serialNo, certificateNo, country);
        if (event == null || event.getId() == null) {
            return -5;
        }
        return 0;
    }

    private static Event createEvent(InvocationContext ctx, NDData data, String serialNo, String certificateNo, String country) {
        String message = "\u041f\u043e\u0441\u0442\u0443\u043f\u0438\u043b \u0441\u0438\u0433\u043d\u0430\u043b \u0440\u0430\u0434\u0438\u043e\u043c\u0430\u044f\u043a\u0430 (\u0441\u0435\u0440\u0438\u0439\u043d\u044b\u0439: ".concat(serialNo).concat(", \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442: ").concat(certificateNo).concat(", \u0441\u0442\u0440\u0430\u043d\u0430: ").concat(country).concat(")");
        Event event = new Event();
        event.setEventDate(data.getCreatedDateTime());
        event.setInitiator(data.getDeviceId());
        event.setNddataId(data.getId());
        event.setSpeed(data.getSpeed());
        event.setMessage(message);
        event.setActive(Integer.valueOf(1));
        event.setImportanceEvent(ConverterMessage2NDData.getImportanceEvent(ctx));
        event.setReactionType(ConverterMessage2NDData.getReactionType(ctx));
        event = eventProxy.save(ctx, event);
        return event;
    }

    private static ReactionType getReactionType(InvocationContext ctx) {
        ReactionType res = null;
        DirectoriesSearchCriteria sc = new DirectoriesSearchCriteria();
        sc.setDescription("*\u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u043c\u0435\u0448\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430*");
        ReactionTypeWSProxy.SearchResultListReactionType srList = reactionTypeProxy.getList(ctx, sc);
        if (srList != null && !srList.isEmpty()) {
            res = (ReactionType)srList.getObjList()[0];
        } else {
            res = new ReactionType();
            res.setDescription("\u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0432\u043c\u0435\u0448\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430");
            res.setCode("00");
            res = reactionTypeProxy.save(ctx, res);
        }
        return res;
    }

    private static NDData saveNDData(InvocationContext ctx, Long deviceid, Date nddataDate, Double lat, Double lon) {
        NDData d = new NDData();
        RecordType rt = ConverterMessage2NDData.getRecordType(ctx);
        d.setType(rt);
        d.setDeviceId(deviceid);
        d.setCreatedDateTime(nddataDate);
        d.setLat(lat);
        d.setLon(lon);
        d.setSpeed(Double.valueOf(0.0));
        d.setTripIndex(Integer.valueOf(0));
        d.setAlarmDevice(0);
        NDData[] list = proxyNDData.saveList(ctx, new NDData[]{d});
        return list[0];
    }

    private static RecordType getRecordType(InvocationContext ctx) {
        DirectoriesSearchCriteria dSC = new DirectoriesSearchCriteria();
        dSC.setDescription("*\u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438*");
        RecordTypeWSProxy.SearchResultListRecordType dSR = proxyRT.getList(ctx, dSC);
        return (RecordType)dSR.getObjList()[0];
    }

    private static ImportanceEvent getImportanceEvent(InvocationContext ctx) {
        ImportanceEvent res = null;
        DirectoriesSearchCriteria sc = new DirectoriesSearchCriteria();
        sc.setDescription("*\u0442\u0440\u0435\u0432\u043e\u0433\u0430*");
        ImportanceEventWSProxy.SearchResultListImportanceEvent srList = importanceEventProxy.getList(ctx, sc);
        if (srList != null && !srList.isEmpty()) {
            res = (ImportanceEvent)srList.getObjList()[0];
        } else {
            res = new ImportanceEvent();
            res.setDescription("\u0442\u0440\u0435\u0432\u043e\u0433\u0430");
            res.setCode("90");
            res = importanceEventProxy.save(ctx, res);
        }
        return res;
    }

    private static Integer getValue(String st, int b, int e) {
        String str = st.substring(b - 25, e - 24);
        return Integer.parseInt(str, 2);
    }

    public static String loadFromFile(String fullnameFile) {
        StringBuilder sb = new StringBuilder("");
        try {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fullnameFile), "Cp1251"));
            while ((s = reader.readLine()) != null) {
                sb = sb.append(s).append("\n");
            }
        }
        catch (Exception exception) {
            return "";
        }
        return sb.toString();
    }
}

