/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.ownerroadsectionlists.maps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.infor.ws.objects.vms.entities.WatchArea;

public class AreaPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    WatchArea area;
    List<org.postgis.Polygon> listPolygon = new ArrayList<org.postgis.Polygon>();
    List<GeoPosition> listCoord = new ArrayList<GeoPosition>();

    public WatchArea getArea() {
        return this.area;
    }

    public void setArea(WatchArea area) {
        this.area = area;
        this.listPolygon.clear();
        if (area != null) {
            AreaPainter.buildPolygon(area.getAreageom(), this.listPolygon);
        }
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Color w = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 70);
        Color w1 = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 250);
        if (this.listCoord.size() > 0) {
            this.paintCoordn(this.listCoord, map, g, vp2, vp3, w, w1);
        } else {
            for (org.postgis.Polygon p : this.listPolygon) {
                this.paintPolygon(p, map, g, vp2, vp3, w, w1);
            }
        }
    }

    protected void paintCoordn(List<GeoPosition> l, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color w, Color w1) {
        Polygon pp = new Polygon();
        int[] xPoints = new int[l.size()];
        int[] yPoints = new int[l.size()];
        int i = 0;
        while (i < l.size()) {
            Point2D point = map.getTileFactory().geoToPixel(l.get(i), map.getZoom());
            int x = (int)(point.getX() - vp2.getX());
            int y = (int)(point.getY() - vp2.getY());
            pp.addPoint(x, y);
            xPoints[i] = x;
            yPoints[i] = y;
            ++i;
        }
        if (l.size() > 2) {
            g.setColor(w1);
            g.drawPolygon(pp);
            g.setColor(w);
            g.fillPolygon(pp);
        } else {
            g.setColor(w1);
            g.drawPolyline(xPoints, yPoints, l.size());
        }
    }

    protected void paintPolygon(org.postgis.Polygon polygon, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color w, Color w1) {
        Path2D path = null;
        int ii = 0;
        while (ii < polygon.numRings()) {
            Polygon pp = new Polygon();
            int i = 0;
            while (i < polygon.getRing(ii).numPoints()) {
                Point p1 = polygon.getRing(ii).getPoint(i);
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p1.getY(), p1.getX()), map.getZoom());
                int x = (int)(point.getX() - vp2.getX());
                int y = (int)(point.getY() - vp2.getY());
                pp.addPoint(x, y);
                ++i;
            }
            if (path == null) {
                path = new GeneralPath(pp);
            } else {
                path.append(pp, true);
            }
            g.setColor(w1);
            g.drawPolygon(pp);
            ++ii;
        }
        g.setColor(w);
        g.fill(path);
    }

    public static void buildPolygon(String geom, List<org.postgis.Polygon> listPolygon) {
        try {
            Object geometry = geom.toLowerCase().indexOf("MultiPolygon".toLowerCase()) > -1 ? new MultiPolygon(geom) : new org.postgis.Polygon(geom);
            if (geometry instanceof org.postgis.Polygon) {
                listPolygon.add((org.postgis.Polygon)geometry);
            } else if (geometry instanceof MultiPolygon) {
                org.postgis.Polygon[] polygonArray = geometry.getPolygons();
                int n = polygonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    listPolygon.add((org.postgis.Polygon)geometry);
                    ++n2;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

