/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.ownerroadsectionlists.maps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Point;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.roads.RoadList;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class PainterRoad<T extends JXMapViewer>
extends MapViewPainter<T> {
    RoadWA w;
    RoadWAExt r;
    RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);

    public RoadWA getW() {
        return this.w;
    }

    public void setW(RoadWA w) {
        this.w = w;
        this.r = null;
        if (w != null) {
            this.r = (RoadWAExt)this.proxy.getCurrentObject(InitializedVariable.context, w.getId());
            RoadList.updateObjectGeom(this.r);
        }
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.r != null && this.r.getCurrentPolygon() != null) {
            Color c = Color.GREEN;
            RoutePainter.paintPolygon(this.r.getCurrentPolygon(), map, g, (Rectangle2D)vp2, c, 150);
            Point p = null;
            if (this.r.getCurrentLine() != null) {
                p = this.r.getCurrentLine().getPoint(0);
            } else if (this.r.getCurrentPolygon() != null) {
                p = this.r.getCurrentPolygon().getPoint(0);
            }
            if (p != null) {
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p.getY(), p.getX()), map.getZoom());
                int x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                int y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                g.translate(x, y);
                g.setColor(Color.BLACK);
                g.drawString(this.r.getName(), 0, 0);
                g.translate(-x, -y);
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

