/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.ownerroadsectionlists.maps;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.MultiLineString;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.ownerroadsectionlists.maps.AreaPainter;
import ru.blok.vms.ui.ownerroadsectionlists.maps.PainterRoad;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.WatchArea;

public class ZoneViewer
extends MapViewer {
    AreaPainter<JXMapViewer> aPainter;
    PainterRoad<JXMapViewer> pRoad;
    WatchArea area;

    public ZoneViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(null);
        this.area = (WatchArea)arg0;
        this.aPainter.setArea(this.area);
        this.aPainter.listCoord.clear();
        this.zoomToTracks();
    }

    protected String getSRID() {
        return "SRID=4326;";
    }

    @Override
    public Object getValue() {
        if (this.aPainter.listCoord.size() == 0) {
            return this.area;
        }
        if (this.area == null) {
            this.area = new WatchArea();
        }
        if (this.aPainter.listCoord.size() > 2) {
            StringBuilder st = new StringBuilder(this.getSRID());
            st.append("POLYGON((");
            int i = 0;
            while (i < this.aPainter.listCoord.size()) {
                GeoPosition gp = this.aPainter.listCoord.get(i);
                if (i > 0) {
                    st.append(",");
                }
                st.append(gp.getLongitude()).append(" ").append(gp.getLatitude());
                ++i;
            }
            GeoPosition gp = this.aPainter.listCoord.get(0);
            st.append(",");
            st.append(gp.getLongitude()).append(" ").append(gp.getLatitude());
            st.append("))");
            this.area.setAreageom(st.toString());
        } else {
            this.area.setAreageom(null);
        }
        return this.area;
    }

    @Override
    protected void init() {
        super.init();
        this.aPainter = new AreaPainter();
        this.painter.addPainter(this.aPainter);
        this.pRoad = new PainterRoad();
        this.painter.addPainter(this.pRoad);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ZoneViewer.this.mouseClickedOnMap(e);
            }
        });
    }

    public void setRoad(RoadWA r) {
        this.pRoad.setW(r);
        this.repaint();
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected void mouseMovedN(MouseEvent e) {
    }

    @Override
    protected void mouseWheelMovedN(MouseWheelEvent e) {
    }

    protected void mouseClickedOnMap(MouseEvent e) {
        if (e.isShiftDown()) {
            double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
            GeoPosition gp = this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(x, y), this.map.getMainMap().getZoom());
            if (e.isControlDown()) {
                this.aPainter.listCoord.clear();
            }
            this.aPainter.listCoord.add(gp);
            this.repaint();
        }
    }

    @Override
    protected Double[] getMinMax() {
        MultiLineString lineString;
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.aPainter != null && this.aPainter.listPolygon != null) {
            for (Polygon p : this.aPainter.listPolygon) {
                int i = 0;
                while (i < p.numPoints()) {
                    Point d = p.getPoint(i);
                    if (minLat == null || d.getY() < minLat) {
                        minLat = d.getY();
                    }
                    if (maxLat == null || d.getY() > maxLat) {
                        maxLat = d.getY();
                    }
                    if (minLon == null || d.getX() < minLon) {
                        minLon = d.getX();
                    }
                    if (maxLon == null || d.getX() > maxLon) {
                        maxLon = d.getX();
                    }
                    ++i;
                }
            }
        }
        for (GeoPosition gp : this.aPainter.listCoord) {
            if (minLat == null || gp.getLatitude() < minLat) {
                minLat = gp.getLongitude();
            }
            if (maxLat == null || gp.getLatitude() > maxLat) {
                maxLat = gp.getLongitude();
            }
            if (minLon == null || gp.getLongitude() < minLon) {
                minLon = gp.getLatitude();
            }
            if (maxLon != null && !(gp.getLongitude() > maxLon)) continue;
            maxLon = gp.getLatitude();
        }
        if (this.pRoad.r != null && (lineString = this.pRoad.r.getCurrentLine()) != null) {
            int i = 0;
            while (i < lineString.numPoints()) {
                double lat = lineString.getPoint(i).getY();
                double lon = lineString.getPoint(i).getX();
                if (minLat == null || lat < minLat) {
                    minLat = lat;
                }
                if (maxLat == null || lat > maxLat) {
                    maxLat = lat;
                }
                if (minLon == null || lon < minLon) {
                    minLon = lon;
                }
                if (maxLon == null || lon > maxLon) {
                    maxLon = lon;
                }
                ++i;
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }
}

