/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.plannedtoutput.plannedonmap;

import java.util.List;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.plannedtoutput.plannedonmap.PlannedOutputOnMap;
import ru.blok.vms.ui.plannedtoutput.plannedonmap.PlannedOutputToView;

public class MapValueOutput
extends MapValue
implements IMapValue {
    MapViewer mapViewer;
    PlannedOutputOnMap information;

    public MapValueOutput(double lat, double lon, int zoom) {
        super(lat, lon, zoom);
    }

    public PlannedOutputOnMap getInformation() {
        return this.information;
    }

    public void setInformation(PlannedOutputOnMap information) {
        this.information = information;
    }

    public void change(PlannedOutputToView sel) {
        if (this.mapViewer != null) {
            if (sel != null) {
                this.mapViewer.setCenterPosition(new double[]{sel.getData().getLat(), sel.getData().getLon()});
            } else {
                this.mapViewer.repaint();
            }
        }
    }

    public void change() {
        if (this.mapViewer != null) {
            this.mapViewer.repaint();
        }
    }

    public void init(List<GeoPosition> gpl) {
        if (gpl == null || gpl.size() == 0) {
            this.mapViewer.zoomToTracks();
        } else {
            Double minLat = null;
            Double maxLat = null;
            Double minLon = null;
            Double maxLon = null;
            for (GeoPosition d : gpl) {
                if (d == null) continue;
                if (minLat == null || d.getLatitude() < minLat) {
                    minLat = d.getLatitude();
                }
                if (maxLat == null || d.getLatitude() > maxLat) {
                    maxLat = d.getLatitude();
                }
                if (minLon == null || d.getLongitude() < minLon) {
                    minLon = d.getLongitude();
                }
                if (maxLon != null && !(d.getLongitude() > maxLon)) continue;
                maxLon = d.getLongitude();
            }
            if (minLat != null) {
                this.mapViewer.zoomToTracks(new Double[]{minLat, maxLat, minLon, maxLon});
            } else {
                this.mapViewer.zoomToTracks();
            }
        }
    }
}

