/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.plannedtoutput.plannedonmap;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import org.jxmapviewer.JXMapViewer;
import ru.blok.vms.ui.plannedtoutput.plannedonmap.MapValueOutput;
import ru.blok.vms.ui.plannedtoutput.plannedonmap.PainterData;
import ru.blok.vms.ui.plannedtoutput.plannedonmap.PlannedOutputToView;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.entities.NDData;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    JInternalFrame f;
    PainterData<JXMapViewer> painterData;
    JLayeredPane pane;
    MapValueOutput value;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.map.getMiniMap().setVisible(false);
        this.painterData = new PainterData();
        this.painter.addPainter(this.painterData);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapViewer.this.mouseClickedOnMap(e);
            }
        });
        this.f = new JInternalFrame();
        this.f.setSize(new Dimension(300, 500));
        this.f.setClosable(true);
        this.f.setDefaultCloseOperation(1);
        this.pane = new JDesktopPane();
        this.pane.add((Component)this.main, JLayeredPane.DEFAULT_LAYER);
        this.pane.add((Component)this.f, JLayeredPane.PALETTE_LAYER);
        this.pane.setVisible(true);
        this.pane.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MapViewer.this.main.setSize(MapViewer.this.pane.getSize());
                MapViewer.this.main.revalidate();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    protected void mouseMovedN(MouseEvent e) {
    }

    @Override
    protected void mouseWheelMovedN(MouseWheelEvent e) {
    }

    @Override
    public JComponent getComponent(boolean arg0, boolean arg1) {
        return this.pane;
    }

    protected void mouseClickedOnMap(MouseEvent e) {
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.value != null) {
            for (PlannedOutputToView w : this.value.getInformation().view.values()) {
                NDData d = w.getData();
                if (d == null) continue;
                if (minLat == null || d.getLat() < minLat) {
                    minLat = d.getLat();
                }
                if (maxLat == null || d.getLat() > maxLat) {
                    maxLat = d.getLat();
                }
                if (minLon == null || d.getLon() < minLon) {
                    minLon = d.getLon();
                }
                if (maxLon != null && !(d.getLon() > maxLon)) continue;
                maxLon = d.getLon();
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            ((MapValueOutput)value).mapViewer = this;
        }
        this.value = (MapValueOutput)value;
        super.setValue(this.value);
        this.painterData.setValue(this.value);
        this.zoomToTracks();
        this.main.setSize(this.pane.getSize());
    }
}

