/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.plannedtoutput.plannedonmap;

import com.vividsolutions.jts.io.WKTReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.List;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.transcoder.TranscoderException;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiPolygon;
import org.postgis.Polygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.plannedtoutput.plannedonmap.MapValueOutput;
import ru.blok.vms.ui.plannedtoutput.plannedonmap.PlannedOutputToView;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.client.soap.proxy.vms.WatchAreaWSProxy;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.ext.WatchAreaExt;

public class PainterData<T extends JXMapViewer>
extends MapViewPainter<T> {
    private static WKTReader wr = new WKTReader();
    MapValueOutput value;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        PlannedOutputToView wsel = null;
        if (this.value != null) {
            for (PlannedOutputToView w : this.value.getInformation().view.values()) {
                if (w.isSelect()) {
                    wsel = w;
                    continue;
                }
                if (w.getData() == null) continue;
                try {
                    if (w.getComponent().getParent() == null) {
                        map.add((Component)w.getComponent());
                        if (w.getData() != null && w.getData().getDirection() != null) {
                            w.setAngle(w.getData().getDirection());
                        }
                    }
                    this.paintImage(g, map, w, w.getH(), w.getW(), vp2);
                }
                catch (TranscoderException e) {
                    e.printStackTrace();
                }
            }
        }
        if (wsel != null) {
            if (wsel.getData() != null) {
                try {
                    if (wsel.getComponent().getParent() == null) {
                        map.add((Component)wsel.getComponent());
                        if (wsel.getData() != null && wsel.getData().getDirection() != null) {
                            wsel.setAngle(wsel.getData().getDirection());
                        }
                    }
                    if (wsel.getComponentH().getParent() == null) {
                        map.add((Component)wsel.getComponentH());
                    }
                    this.paintImage(g, map, wsel, wsel.getH(), wsel.getW(), vp2);
                }
                catch (TranscoderException e) {
                    e.printStackTrace();
                }
            }
            List lr = null;
            List lw = null;
            RouteWSProxy routeWSProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class, (String)this.value.information.getKeyPage());
            if (lr != null) {
                for (Object r : lr) {
                    if (r.getRouteGeom() == null) {
                        Route r2 = routeWSProxy.getCurrentObject(InitializedVariable.getContext((String)this.value.information.getKeyPage()), r.getId());
                        r.setRouteGeom(r2.getRouteGeom());
                        r.setAreaRouteGeom(r2.getAreaRouteGeom());
                    }
                    if (r != null && r.getAreaRouteGeom() != null && r.getCurrentPolygon() == null) {
                        try {
                            Object currentPolygon = null;
                            currentPolygon = r.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(r.getAreaRouteGeom()) : new Polygon(r.getAreaRouteGeom());
                            r.setCurrentPolygon((Geometry)currentPolygon);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    RoutePainter.paintPolygon(r.getCurrentPolygon(), map, g, (Rectangle2D)vp2, Color.RED, 50);
                }
            }
            if (lw != null) {
                for (Object r : lw) {
                    PainterData.checkGeom((WatchAreaExt)((Object)r), this.value.information.getKeyPage());
                    RoutePainter.paintPolygon(((WatchAreaExt)((Object)r)).getCurrentPolygon(), map, g, (Rectangle2D)vp2, r.getColor() == null ? Color.GREEN : new Color(r.getColor()), r.getTransparency() == null ? 50 : r.getTransparency());
                }
            }
        }
    }

    public static void checkGeom(WatchAreaExt r, String keyPage) {
        if (r.getAreageom() == null) {
            WatchAreaWSProxy watchAreaWSProxy = (WatchAreaWSProxy)CurrentProxyFactory.getProxy(WatchAreaExt.class, (String)keyPage);
            WatchAreaExt r2 = (WatchAreaExt)watchAreaWSProxy.getCurrentObject(InitializedVariable.getContext((String)keyPage), r.getId());
            r.setAreageom(r2.getAreageom());
        }
        if (r != null && r.getAreageom() != null && r.getCurrentPolygon() == null) {
            try {
                Object currentPolygon = null;
                currentPolygon = r.getAreageom().contains("MULTIPOLYGON") ? new MultiPolygon(r.getAreageom()) : new Polygon(r.getAreageom());
                r.setCurrentPolygon((Geometry)currentPolygon);
                com.vividsolutions.jts.geom.Geometry jtsp = wr.read(String.valueOf(r.getCurrentPolygon().getTypeString()) + r.getCurrentPolygon().getValue());
                r.setJtsp(jtsp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void paintImage(Graphics2D g, T map, PlannedOutputToView wv, int h, int w, Rectangle2D vp2) throws TranscoderException {
        GeoPosition gp = wv.getGeoposition();
        Point2D point = map.getTileFactory().geoToPixel(gp, map.getZoom());
        int x = (int)(point.getX() - vp2.getX());
        int y = (int)(point.getY() - vp2.getY());
        JSVGCanvas canvas = (JSVGCanvas)wv.getComponent();
        Dimension2D d = canvas.getSVGDocumentSize();
        if (d == null) {
            d = canvas.getSize();
        }
        wv.resize();
        Point pt = new Point(x - (int)d.getWidth() / 2, y - (int)d.getHeight() / 2);
        canvas.setLocation(pt);
        if (wv.getComponentH() != null) {
            JSVGCanvas canvas2 = (JSVGCanvas)wv.getComponentH();
            if (wv.isSelect()) {
                wv.resize2();
                pt = new Point(x - wv.getComponent().getWidth() / 2, y - wv.getComponentH().getHeight() + wv.getComponent().getHeight() / 2);
                canvas2.setLocation(pt);
                canvas2.setVisible(true);
            } else {
                canvas2.setVisible(false);
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueOutput)mapValueWithTrack;
    }
}

