/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.plannedtoutput.plannedonmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.apache.batik.dom.GenericText;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherAdapter;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.log4j.Logger;
import org.jxmapviewer.viewer.GeoPosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.configprop.ConfigProp;
import ru.blok.common.ui.configprop.ConfigProperties;
import ru.blok.vms.ui.plannedtoutput.plannedonmap.PlannedOutputOnMap;
import ru.blok.vms.ui.police.operationalinformation.ObjectToView;
import ru.infor.common.FileUtils;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.events.EventUI;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.PlannedOutput;
import ru.infor.ws.objects.vms.entities.TransportKind;

public class PlannedOutputToView {
    static String image2 = "/iconssvg/wd.svg";
    String urlIcon = null;
    private Date datedata;
    Long deviceId;
    NDData data;
    static Integer defaultFill = -16704308;
    static Integer defaultFillAv = -16704308;
    static Integer defaultRim = -16707462;
    static Integer defaultLabel = -1;
    static Integer defaultLabelAv = -16777216;
    NavigationPoint[] path;
    private List<EventUI> list = new ArrayList<EventUI>();
    public static String svgPrefix = "";
    public static String prefix = "/data";
    static String image;
    static String imageH;
    protected Long id;
    protected PlannedOutput object;
    protected SVGDocument doc;
    protected SVGDocument docH;
    protected int h = 30;
    protected int w = 20;
    protected boolean show = true;
    protected boolean select = false;
    protected JSVGCanvas canvas;
    protected JSVGCanvas canvasH;
    protected AffineTransform tx;
    protected RunnableQueue queue;
    protected RunnableQueue queue2;
    protected boolean onClickWasSet = false;
    protected PlannedOutputOnMap information;
    public DecimalFormat defs = new DecimalFormat("###0.##");
    static String parser;
    static SAXSVGDocumentFactory f;

    static {
        String cacheDataFolder = SysProperties.getProperty((String)"path.resource", (String)"");
        if (!cacheDataFolder.trim().equals("")) {
            cacheDataFolder = String.valueOf(cacheDataFolder) + File.separator;
        }
        svgPrefix = cacheDataFolder;
        image = "";
        imageH = "/iconssvg/hint.svg";
        parser = XMLResourceDescriptor.getXMLParserClassName();
        f = new SAXSVGDocumentFactory(parser);
    }

    public PlannedOutputToView(final Long id, PlannedOutput object, PlannedOutputOnMap information) {
        this.information = information;
        this.id = id;
        this.object = object;
        this.setImage();
        this.loadImage();
        this.canvas = new JSVGCanvas();
        this.canvas.setDocumentState(1);
        this.canvas.setDocument((Document)this.doc);
        String ww = this.doc.getRootElement().getAttribute("width");
        String hh = this.doc.getRootElement().getAttribute("height");
        this.canvas.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
        if (this.docH != null) {
            this.canvasH = new JSVGCanvas();
            this.canvasH.setDocumentState(1);
            this.canvasH.setDocument((Document)this.docH);
            ww = this.docH.getRootElement().getAttribute("width");
            hh = this.docH.getRootElement().getAttribute("height");
            this.canvasH.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
            this.canvasH.setBackground(new Color(0, 0, 0, 0));
            this.canvasH.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)new SVGLoadEventDispatcherAdapter(){

                public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
                    PlannedOutputToView.this.queue2 = PlannedOutputToView.this.canvasH.getUpdateManager().getUpdateRunnableQueue();
                }
            });
        }
        this.canvas.setBackground(new Color(0, 0, 0, 0));
        this.tx = this.canvas.getRenderingTransform();
        this.canvas.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)new SVGLoadEventDispatcherAdapter(){

            public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
                Element elt;
                EventTarget t;
                PlannedOutputToView.this.queue = PlannedOutputToView.this.canvas.getUpdateManager().getUpdateRunnableQueue();
                PlannedOutputToView.this.initangle();
                if (!PlannedOutputToView.this.onClickWasSet && (t = (EventTarget)((Object)(elt = PlannedOutputToView.this.canvas.getSVGDocument().getElementById("gMainGroup")))) != null && id != null) {
                    t.addEventListener("click", new OnClickAction(id), false);
                    PlannedOutputToView.this.onClickWasSet = true;
                }
            }
        });
    }

    public Date getDatedata() {
        return this.datedata;
    }

    public void setDatedata(Date datedata) {
        this.datedata = datedata;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public static String getFromServer(String urlStr, Long id, String keyPage) throws Exception {
        URL url = new URL(urlStr);
        Logger.getLogger(ObjectToView.class).debug((Object)("load url " + urlStr));
        if (url.getAuthority() == null) {
            String namec = String.valueOf(keyPage.equals("") ? InitializedVariable.appShortName : keyPage.toLowerCase()) + ".soap.services.url";
            ConfigProp cp1 = ConfigProperties.getInstance().getListProp().stream().filter(cp -> cp.getName().equals(namec)).findFirst().get();
            URL t = new URL(cp1.getValue());
            String newurl = String.valueOf(t.getProtocol()) + "://" + t.getHost() + ":" + t.getPort() + url.getPath() + "?" + url.getQuery();
            url = new URL(newurl);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url, (String)keyPage);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
        }
        catch (Exception e) {
            Logger.getLogger(ObjectToView.class).error((Object)("error load url " + urlStr));
            e.printStackTrace();
        }
        String typeS = "iconssvg/" + Long.toString(id);
        File file = svgPrefix.equals("") ? new File(ObjectToView.class.getResource(String.valueOf(prefix) + typeS).getFile()) : new File(String.valueOf(svgPrefix) + typeS);
        InputStream input = conn.getInputStream();
        FileUtils.copy((InputStream)input, (File)file);
        return typeS;
    }

    public void setImage() {
        PlannedOutput w = this.getObject();
        TransportKind type = w.getTransport().getTransportKind();
        if (type != null && type.getName() != null) {
            String urlStr = this.information.mapKind.get(type.getId()).getName();
            try {
                image = PlannedOutputToView.getFromServer(urlStr, type.getId(), this.information.getKeyPage());
            }
            catch (Exception e) {
                image = "/iconssvg/wd.svg";
                e.printStackTrace();
            }
        } else {
            image = "/iconssvg/wd.svg";
        }
        imageH = "/iconssvg/hint.svg";
    }

    public void initangle() {
        if (this.data != null && this.data.getDirection() != null) {
            this.setAngle(this.data.getDirection());
        }
    }

    public void select(long id) {
        this.information.setSelected(id);
    }

    public void setAngle(final double angle) {
        try {
            if (this.queue != null) {
                this.queue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Element gar = PlannedOutputToView.this.doc.getElementById("gMainGroup");
                        gar.setAttribute("transform", "rotate(" + angle + ",17.5,17.5)");
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NDData getData() {
        return this.data;
    }

    public void setData(NDData data) {
        this.data = data;
        if (data != null && data.getDirection() != null) {
            this.setAngle(data.getDirection());
        }
        this.setterHint();
    }

    public void setterHint() {
        try {
            if (this.queue2 != null) {
                this.queue2.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PlannedOutputToView.this.docH != null) {
                            String s;
                            GenericText e = (GenericText)PlannedOutputToView.this.docH.getElementById("num").getFirstChild();
                            if (e != null) {
                                e.setNodeValue(PlannedOutputToView.this.getObject().getNum());
                            }
                            if ((e = (GenericText)PlannedOutputToView.this.docH.getElementById("callsign").getFirstChild()) != null) {
                                e.setNodeValue(PlannedOutputToView.this.getObject().getTransport().getRegNum());
                            }
                            if ((e = (GenericText)PlannedOutputToView.this.docH.getElementById("speed").getFirstChild()) != null) {
                                s = "";
                                if (PlannedOutputToView.this.getData() != null && PlannedOutputToView.this.getData().getSpeed() != null) {
                                    s = String.valueOf(PlannedOutputToView.this.defs.format(PlannedOutputToView.this.getData().getSpeed())) + " \u043a\u043c/\u0447";
                                }
                                e.setNodeValue(s);
                            }
                            if ((e = (GenericText)PlannedOutputToView.this.docH.getElementById("task").getFirstChild()) != null) {
                                s = "";
                                if (PlannedOutputToView.this.getObject() != null && PlannedOutputToView.this.getObject().getWatchArea() != null) {
                                    s = PlannedOutputToView.this.getObject().getWatchArea().getName();
                                }
                                e.setNodeValue(s);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception exception) {}
    }

    public GeoPosition getGeoposition() {
        if (this.data == null) {
            return null;
        }
        GeoPosition gp = new GeoPosition(this.getData().getLat().doubleValue(), this.getData().getLon().doubleValue());
        return gp;
    }

    public NavigationPoint[] getPath() {
        return this.path;
    }

    public void setPath(NavigationPoint[] path) {
        this.path = path;
    }

    public List<EventUI> getList() {
        return this.list;
    }

    public void setList(List<EventUI> list) {
        this.list = list;
    }

    public PlannedOutput getObject() {
        return this.object;
    }

    public void setObject(PlannedOutput object) {
        this.object = object;
    }

    public boolean isSelect() {
        return this.select;
    }

    public void dispose() {
        this.canvas.dispose();
        if (this.canvas.getParent() != null) {
            this.canvas.getParent().remove((Component)this.canvas);
        }
        if (this.canvasH != null) {
            this.canvasH.dispose();
            if (this.canvasH.getParent() != null) {
                this.canvasH.getParent().remove((Component)this.canvasH);
            }
        }
    }

    public void setSelect(boolean select) {
        this.select = select;
    }

    public Long getId() {
        return this.id;
    }

    public JComponent getComponent() {
        return this.canvas;
    }

    public JComponent getComponentH() {
        return this.canvasH;
    }

    public SVGDocument getDoc() {
        return this.doc;
    }

    public void setDoc(SVGDocument doc) {
        this.doc = doc;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public void reload() {
        this.canvas.setDocument((Document)this.doc);
        this.canvas.repaint();
        this.setterHint();
        if (this.docH != null) {
            this.canvasH.setDocument((Document)this.docH);
            this.canvasH.repaint();
        }
    }

    public static SVGDocument loadImage(String image) {
        File file = svgPrefix.equals("") ? new File(ObjectToView.class.getResource(String.valueOf(prefix) + image).getFile()) : new File(String.valueOf(svgPrefix) + image);
        try {
            SVGDocument doc = f.createSVGDocument(file.toURI().toString());
            return doc;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadImage() {
        this.doc = PlannedOutputToView.loadImage(image);
        if (imageH != null) {
            this.docH = PlannedOutputToView.loadImage(imageH);
        }
    }

    public static void changeColorFill(Integer color, Element e, Double opacity) {
        if (e != null && color != null) {
            String s = e.getAttribute("style");
            int k = s.indexOf("fill:#");
            StringBuilder r = new StringBuilder();
            if (k > 0) {
                r.append(s.substring(0, k));
            }
            r.append("fill:#").append(Integer.toHexString(color).substring(2)).append(s.substring(k + 12));
            s = r.toString();
            if (opacity != null) {
                k = s.indexOf("opacity:");
                r = new StringBuilder();
                if (k > 0) {
                    r.append(s.substring(0, k));
                    r.append("opacity:").append(opacity).append(s.substring(k + 9));
                    s = r.toString();
                }
            }
            if (s != null && !"".equals(s)) {
                e.setAttribute("style", s);
            }
        }
    }

    public static void changeColorLine(Integer color, Element e) {
        if (e != null) {
            String s = e.getAttribute("style");
            int k = s.indexOf("stroke:#");
            StringBuilder r = new StringBuilder();
            if (k > 0) {
                r.append(s.substring(0, k));
                r.append("stroke:#").append(Integer.toHexString(color).substring(2)).append(s.substring(k + 14));
                e.setAttribute("style", r.toString());
            }
        }
    }

    public static void setopacity1(Element e1, boolean opacity) {
        if (opacity) {
            e1.setAttribute("style", e1.getAttribute("style").replace("stroke-opacity:0", "stroke-opacity:1"));
            e1.setAttribute("style", e1.getAttribute("style").replace("fill-opacity:0", "fill-opacity:1"));
            e1.setAttribute("style", e1.getAttribute("style").replace("opacity:0", "opacity:1"));
        } else {
            e1.setAttribute("style", e1.getAttribute("style").replace("stroke-opacity:1", "stroke-opacity:0"));
            e1.setAttribute("style", e1.getAttribute("style").replace("fill-opacity:1", "fill-opacity:0"));
            e1.setAttribute("style", e1.getAttribute("style").replace("opacity:1", "opacity:0"));
        }
    }

    public SVGDocument getDocH() {
        return this.docH;
    }

    public void setDocH(SVGDocument docH) {
        this.docH = docH;
    }

    public void resize() {
        String ww = this.doc.getRootElement().getAttribute("width");
        String hh = this.doc.getRootElement().getAttribute("height");
        this.canvas.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
    }

    public void resize2() {
        String ww = this.docH.getRootElement().getAttribute("width");
        String hh = this.docH.getRootElement().getAttribute("height");
        this.canvasH.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
    }

    public class OnClickAction
    implements EventListener {
        private long id;

        public OnClickAction(long id) {
            this.id = id;
        }

        @Override
        public void handleEvent(Event evt) {
            PlannedOutputToView.this.select(this.id);
        }
    }
}

