/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.pointsui.viewers.painters;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.pointsui.viewers.MapValue;
import ru.blok.vms.ui.pointsui.viewers.Utils;
import ru.infor.ws.objects.draw.entities.TrackPointUI;
import ru.infor.ws.objects.vms.entities.NDData;

public class PointPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    private Integer order;
    private MapValue mapValue;

    public PointPainter() {
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public MapValue getMapValue() {
        return this.mapValue;
    }

    public void setMapValue(MapValue mapValue) {
        this.mapValue = mapValue;
    }

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        TrackPointUI p = (TrackPointUI)this.getMapValue().getDataUI().getLayers()[this.getOrder()].getPrimitive();
        Object[] objectArray = this.getMapValue().getPointsl().get(this.getOrder());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            NDData d = (NDData)o;
            this.paint(map, g, vp2, vp3, p, d);
            ++n2;
        }
    }

    protected void paint(T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, TrackPointUI p, NDData data) {
        Color w;
        Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(data.getLat().doubleValue(), data.getLon().doubleValue()), map.getZoom());
        Color colorLine = new Color(Utils.getColorWithConditions(data, p.getColorLineConditions(), p.getColorLine()));
        Color colorFill = new Color(Utils.getColorWithConditions(data, p.getColorFillConditions(), p.getColorFill()));
        int opaque = Utils.getIntegerWithConditions(data, p.getOpaqueConditions(), p.getOpaque());
        int diameter = Utils.getIntegerWithConditions(data, p.getDiameterConditions(), p.getDiameter());
        if (vp2.contains(point)) {
            w = new Color(colorLine.getRed(), colorLine.getGreen(), colorLine.getBlue(), opaque);
            g.setColor(w);
            g.setStroke(new BasicStroke());
            g.drawOval((int)(point.getX() - vp2.getX() - (double)(diameter / 2)), (int)(point.getY() - vp2.getY() - (double)(diameter / 2)), diameter, diameter);
            w = new Color(colorFill.getRed(), colorFill.getGreen(), colorFill.getBlue(), opaque);
            g.setColor(w);
            g.fillOval((int)(point.getX() - vp2.getX() - (double)(diameter / 2)), (int)(point.getY() - vp2.getY() - (double)(diameter / 2)), diameter, diameter);
        }
        if (vp3.contains(point)) {
            w = new Color(colorLine.getRed(), colorLine.getGreen(), colorLine.getBlue(), opaque);
            g.setColor(w);
            g.drawOval((int)(point.getX() - vp3.getX() - (double)(diameter / 2)), (int)(point.getY() - vp3.getY() - (double)(diameter / 2)), diameter, diameter);
            w = new Color(colorFill.getRed(), colorFill.getGreen(), colorFill.getBlue(), opaque);
            g.setColor(w);
            g.fillOval((int)(point.getX() - vp3.getX() - (double)(diameter / 2)), (int)(point.getY() - vp3.getY() - (double)(diameter / 2)), diameter, diameter);
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

