/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.pointsui.viewers.painters;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.pointsui.viewers.Utils;
import ru.blok.vms.ui.pointsui.viewers.painters.PointPainter;
import ru.infor.ws.objects.draw.entities.TrackLineUI;
import ru.infor.ws.objects.draw.entities.TrackPointUI;
import ru.infor.ws.objects.draw.entities.TrackUI;
import ru.infor.ws.objects.vms.entities.NDData;

public class TrackPainter<T extends JXMapViewer>
extends PointPainter<T> {
    public TrackPainter() {
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        TrackUI t = (TrackUI)this.getMapValue().getDataUI().getLayers()[this.getOrder()].getPrimitive();
        TrackPointUI p = null;
        TrackLineUI tUI = null;
        if (t.getShowPoint().equals(1)) {
            p = t.getPointUI();
        }
        if (t.getShowLine().equals(1)) {
            tUI = t.getLineUI();
        }
        if (this.getMapValue().getPointsl() != null && this.getMapValue().getPointsl().get(this.getOrder()) != null && this.getMapValue().getPointsl().get(this.getOrder()).length > 0) {
            int i = 0;
            while (i < this.getMapValue().getPointsl().get(this.getOrder()).length - 1) {
                NDData d1 = (NDData)this.getMapValue().getPointsl().get(this.getOrder())[i];
                NDData d2 = (NDData)this.getMapValue().getPointsl().get(this.getOrder())[i + 1];
                if (p != null) {
                    this.paint(map, g, vp2, vp3, p, d1);
                }
                if (tUI != null) {
                    this.paintLine(map, g, vp2, vp3, tUI, d1, d2);
                }
                ++i;
            }
            if (p != null) {
                this.paint(map, g, vp2, vp3, p, (NDData)this.getMapValue().getPointsl().get(this.getOrder())[this.getMapValue().getPointsl().get(this.getOrder()).length - 1]);
            }
        }
    }

    private void paintLine(T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, TrackLineUI tUI, NDData data1, NDData data2) {
        Color cc;
        BasicStroke s;
        Float[] d;
        float w;
        Color c;
        Point2D point1 = map.getTileFactory().geoToPixel(new GeoPosition(data1.getLat().doubleValue(), data1.getLon().doubleValue()), map.getZoom());
        Point2D point2 = map.getTileFactory().geoToPixel(new GeoPosition(data2.getLat().doubleValue(), data2.getLon().doubleValue()), map.getZoom());
        if (vp2.contains(point1) || vp2.contains(point2)) {
            c = new Color(Utils.getColorWithConditions(data1, tUI.getColorConditions(), tUI.getColorLine()));
            w = Utils.getFloatWithConditions(data1, tUI.getWidthConditions(), tUI.getWidth()).floatValue();
            d = Utils.getFloatArrayWithConditions(data1, tUI.getDashConditions(), tUI.getDash());
            Integer o = Utils.getIntegerWithConditions(data1, tUI.getOpaqueConditions(), tUI.getOpaque());
            float[] ff = null;
            if (d != null) {
                ff = new float[d.length];
                int i = 0;
                while (i < d.length) {
                    ff[i] = d[i].floatValue();
                    ++i;
                }
            }
            s = new BasicStroke(w, 1, 0, 10.0f, ff, 0.0f);
            cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), o);
            g.setColor(cc);
            g.setStroke(s);
            g.drawLine((int)(point1.getX() - vp2.getX()), (int)(point1.getY() - vp2.getY()), (int)(point2.getX() - vp2.getX()), (int)(point2.getY() - vp2.getY()));
        }
        if (vp3.contains(point1) || vp3.contains(point2)) {
            c = new Color(Utils.getColorWithConditions(data1, tUI.getColorConditions(), tUI.getColorLine()));
            w = Utils.getFloatWithConditions(data1, tUI.getWidthConditions(), tUI.getWidth()).floatValue();
            d = Utils.getFloatArrayWithConditions(data1, tUI.getDashConditions(), tUI.getDash());
            float[] ff = new float[d.length];
            int i = 0;
            while (i < d.length) {
                ff[i] = d[i].floatValue();
                ++i;
            }
            Integer o = Utils.getIntegerWithConditions(data1, tUI.getOpaqueConditions(), tUI.getOpaque());
            s = new BasicStroke(w, 2, 0, 10.0f, ff, 0.0f);
            cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), o);
            g.setColor(cc);
            g.setStroke(s);
            g.drawLine((int)(point1.getX() - vp3.getX()), (int)(point1.getY() - vp3.getY()), (int)(point2.getX() - vp3.getX()), (int)(point2.getY() - vp3.getY()));
        }
    }
}

