/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.amun;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.Decoder;
import ru.blok.vms.ui.police.amun.GraphicsViewer;
import ru.blok.vms.ui.police.amun.amuntable.Item;
import ru.blok.vms.ui.police.amun.amuntable.ItemViewer;
import ru.blok.vms.ui.police.amun.amuntable.Sputnik;
import ru.blok.vms.ui.police.amun.amuntable.SputnikValue;
import ru.blok.vms.ui.police.amun.map.ShowOnMap;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.layout.AbstractTabSplitPercentLayoutManager;
import ru.infor.beanviewer.swing.layout.TabSplitPercentLayoutManager;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.AsyncBVA;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.RadioButtonViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.DataFromSatellitesWSProxy;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;
import ru.infor.ws.business.vms.websocket.DataFromSatellitesSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendListDataFromSatellites;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.DataFromSatellitesSearchCriteria;
import ru.infor.ws.objects.vms.entities.DataFromSatellites;

@ListView(views={@View(title="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0410\u041c\u0423\u041d", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class AmunGraphics
extends CommonObjectWithKey
implements DataFromSatellitesSocketIntf {
    static String realTime = "\u0412 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438";
    static String onDate = "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043d\u0430 \u0434\u0430\u0442\u0443";
    private String type = onDate;
    DataFromSatellitesWSProxy proxy = (DataFromSatellitesWSProxy)CurrentProxyFactory.getProxy(DataFromSatellites.class, (String)this.getKeyPage());
    DataFromSatellitesSearchCriteria sc;
    String message;
    DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    private Date currentDate = null;
    List<Sputnik> listSputnik = new ArrayList<Sputnik>();
    private Date date;
    Double lat;
    Double lon;
    Boolean ed = false;
    BeanViewerAction<ViewerContext> run = new AsyncBVA<Object, ViewerContext>((ctx, o) -> {
        this.connecting();
        return null;
    }, (o, ctx) -> {}, (o, c) -> {}){

        public String getName() {
            return "\u041d\u0430\u0447\u0430\u0442\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435";
        }
    };
    BeanViewerAction<ViewerContext> load = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            AmunGraphics.this.load();
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
    };
    ShowOnMap m = null;
    private BeanViewerAction<ViewerContext> showOnMap = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430";
        }

        public void actionPerformed(Object message) {
            AmunGraphics.this.m = new ShowOnMap(AmunGraphics.this);
            ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().newWindow(null, AmunGraphics.this.m.getClass(), (Object)AmunGraphics.this.m, (ViewerContext)this.getContext(), "", "ShowOnMap111", true);
        }
    };
    private Decoder.Package obj;
    List<Item> list = new ArrayList<Item>();
    PanelContext pc;
    JIDialog dialog;
    String sid;

    @ListField(fields={@Field(title="", order=5, viewer={TypeViewer.class}, propertiesLayout="1/fill:0//n/spanx,wrap,grow 0, growy 0##cell 10 10", changeAction={ChangeType.class})})
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void cleardata() {
        this.listSputnik.clear();
        this.buildItems();
        this.obj = null;
        this.currentDate = null;
    }

    public AmunGraphics(String keyPage) {
        super(keyPage);
        this.sc = new DataFromSatellitesSearchCriteria();
        this.sc.setSystemName("amun");
        this.date = new Date();
        Calendar c2 = Calendar.getInstance();
        c2.set(13, 0);
        c2.set(14, 0);
        this.sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        this.sc.appendSorting(SortObject.getInstance((String)"dateData", (String)SortObject.DIRECTION_ASC));
        this.sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
    }

    public void load() {
        this.sc.setDateDataTill(this.date);
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        c.add(12, -3);
        this.sc.setDateDataFrom(c.getTime());
        Object[] oo = this.proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), this.sc).getObjList();
        Calendar c2 = Calendar.getInstance();
        c2.setTime(c.getTime());
        c2.add(10, -3);
        while (oo == null && c2.getTimeInMillis() < c.getTimeInMillis()) {
            c.add(12, -5);
            oo = this.proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), this.sc).getObjList();
        }
        if (oo != null && oo.length > 0) {
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                DataFromSatellites d = (DataFromSatellites)o;
                try {
                    Decoder.Package p = Decoder.dataProcess(d.getData());
                    this.message = "\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 " + this.df.format(d.getDateData());
                    this.currentDate = d.getDateData();
                    this.analysPackage(p, d, new Boolean[]{false});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            this.buildItems();
        } else {
            this.message = "\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
        }
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    private Sputnik getItem(Integer num, String type, Boolean[] needRefresh) {
        Sputnik i = this.listSputnik.stream().filter(s -> s.getType().equals(type) && s.getNum().equals(num)).findFirst().orElse(null);
        if (i == null) {
            needRefresh[0] = false;
            i = new Sputnik();
            this.listSputnik.add(i);
            i.setNum(num);
            i.setType(type);
            if ("\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(type)) {
                i.getValue("L1", "CT", needRefresh);
                i.getValue("L1", "BT", needRefresh);
                i.getValue("L2", "CT", needRefresh);
                i.getValue("L2", "BT", needRefresh);
            }
        }
        return i;
    }

    private void buildItems() {
        Collections.sort(this.listSputnik);
        this.list.clear();
        String type = "";
        int n = 0;
        for (Sputnik s : this.listSputnik) {
            if (!type.equals(s.getType())) {
                Item i = new Item();
                i.setN(s.getType());
                type = s.getType();
                i.setColor(new Color(7186175));
                this.list.add(i);
                n = 0;
            }
            if ("\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(s.getType()) && s.getNum() == 0) continue;
            Color c = ++n % 2 == 0 ? new Color(16776301) : new Color(10878942);
            Item i = new Item();
            i.setN(String.valueOf(n) + ".");
            i.setNum(s.getNum());
            i.setL(s.getL());
            i.setUm(s.getUm());
            i.setAz(s.getAz());
            Collections.sort(s.getListValues());
            String ch = "";
            for (SputnikValue v : s.getListValues()) {
                if (!ch.equals(v.getCh())) {
                    i.setCh(v.getCh());
                    ch = v.getCh();
                }
                i.setK(v.getK());
                i.setSh(v.getSh());
                i.setDiff(v.getDiff());
                i.setPom(v.getPom());
                i.setCanuse(new Boolean[]{v.getCanuse(), v.getRr()});
                i.setRetr(v.getRetr());
                i.setColor(c);
                this.list.add(i);
                i = new Item();
            }
        }
    }

    public static String getTypeSystem(Integer code) {
        code = code & 7;
        String type = "";
        switch (code) {
            case 1: {
                type = "\u0413\u041b\u041e\u041d\u0410\u0421\u0421";
                break;
            }
            case 2: {
                type = "GPS";
                break;
            }
            case 3: {
                type = "SBAS";
                break;
            }
            case 4: {
                type = "Galileo";
                break;
            }
            case 5: {
                type = "GIOVE";
                break;
            }
            default: {
                type = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
            }
        }
        return type;
    }

    public String getTypeCh(Integer code, String type) {
        code = code >> 3 & 3;
        String typeS = "";
        switch (code) {
            case 0: {
                typeS = "L1";
                break;
            }
            case 1: {
                if ("GPS".equals(type) || "\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(type)) {
                    typeS = "L2";
                    break;
                }
                if (!"Galileo".equals(type) && !"GIOVE".equals(type)) break;
                typeS = "E5";
                break;
            }
            case 2: {
                if ("\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(type)) {
                    typeS = "L3";
                    break;
                }
                if ("GPS".equals(type)) {
                    typeS = "L5";
                    break;
                }
                if (!"Galileo".equals(type) && !"GIOVE".equals(type)) break;
                typeS = "E6";
            }
        }
        return typeS;
    }

    public String getTypeK(Integer code, String type, String typeS) {
        code = code >> 5 & 3;
        String typeSC = "";
        switch (code) {
            case 0: {
                if (("GPS".equals(type) || "SBAS".equals(type)) && "L1".equals(typeS)) {
                    typeSC = "C/A";
                    break;
                }
                if ("GPS".equals(type) && "L2".equals(typeS)) {
                    typeSC = "C";
                    break;
                }
                if ("\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(type) && ("L1".equals(typeS) || "L2".equals(typeS))) {
                    typeSC = "CT";
                    break;
                }
                if ("Galileo".equals(type) && "L1".equals(typeS) || "GIOVE".equals(type) && "E5".equals(typeS)) {
                    typeSC = "INAV";
                    break;
                }
                if ("Galileo".equals(type) && "E6".equals(typeS) || "GIOVE".equals(type) && "E6".equals(typeS)) {
                    typeSC = "CNAV";
                    break;
                }
                if (!"\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(type) || !"L3".equals(typeS)) break;
                typeSC = "DATA";
                break;
            }
            case 1: {
                if ("GPS".equals(type) && ("L1".equals(typeS) || "L2".equals(typeS))) {
                    typeSC = "P-\u043a\u043e\u0434";
                    break;
                }
                if ("\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(type)) {
                    typeSC = "BT";
                    break;
                }
                if ((!"Galileo".equals(type) || !"E5".equals(typeS)) && (!"GIOVE".equals(type) || !"E5".equals(typeS))) break;
                typeSC = "FNAV";
                break;
            }
            case 2: {
                if (!("Galileo".equals(type) && "L1".equals(typeS) || "GIOVE".equals(type) && "L1".equals(typeS)) && (!"\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(type) || !"L3".equals(typeS))) break;
                typeSC = "Pilot";
            }
        }
        return typeSC;
    }

    public void analysPackage(Decoder.Package p, DataFromSatellites ds, Boolean[] needRefresh) {
        Date d = ds.getDateData();
        if (this.currentDate == null || d.after(this.currentDate) || d.equals(this.currentDate)) {
            this.currentDate = d;
            if ("\u041f\u0440\u043e\u0433\u043d\u043e\u0437 \u0432\u0438\u0434\u0438\u043c\u044b\u0445 \u0441\u043f\u0443\u0442\u043d\u0438\u043a\u043e\u0432".equals(p.title)) {
                this.obj = p;
                for (Map<String, Number> m : p.cycles.values()) {
                    Double r = m.get("\u0423\u0433\u043e\u043b \u0432\u043e\u0437\u0432\u044b\u0448\u0435\u043d\u0438\u044f").doubleValue();
                    Double a = m.get("\u0410\u0437\u0438\u043c\u0443\u0442").doubleValue();
                    int n = m.get("\u041d\u043e\u043c\u0435\u0440 \u0441\u043f\u0443\u0442\u043d\u0438\u043a\u0430").intValue();
                    int l = m.get("\u041b\u0438\u0442\u0435\u0440 \u0447\u0430\u0441\u0442\u043e\u0442\u044b").intValue();
                    String type = AmunGraphics.getTypeSystem(((Long)m.get("\u0422\u0438\u043f \u0441\u0438\u0433\u043d\u0430\u043b\u0430")).intValue());
                    Sputnik i = this.getItem(n, type, needRefresh);
                    i.setL(l);
                    i.setUm(r);
                    i.setAz(a);
                }
            } else if ("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u0430\u043d\u0430\u043b\u043e\u0432 \u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430".equals(p.title)) {
                for (Map<String, Number> m : p.cycles.values()) {
                    Integer code = ((Long)m.get("\u0422\u0438\u043f \u0441\u0438\u0433\u043d\u0430\u043b\u0430")).intValue();
                    int n = m.get("\u041d\u043e\u043c\u0435\u0440 \u0441\u043f\u0443\u0442\u043d\u0438\u043a\u0430").intValue();
                    String type = AmunGraphics.getTypeSystem(code);
                    int l = m.get("\u041b\u0438\u0442\u0435\u0440 \u0434\u043b\u044f \u0413\u041b\u041e\u041d\u0410\u0421\u0421").intValue();
                    Sputnik i = this.getItem(n, type, needRefresh);
                    i.setL(l);
                    String typeS = this.getTypeCh(code, type);
                    String typeSC = this.getTypeK(code, type, typeS);
                    Integer r = m.get("\u0421\u0438\u0433\u043d\u0430\u043b/\u0448\u0443\u043c").intValue();
                    SputnikValue v = i.getValue(typeS, typeSC, needRefresh);
                    v.serSH(r, d);
                    Integer rc = m.get("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043f\u0443\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0435\u0448\u0435\u043d\u0438\u0438").intValue();
                    rc = rc & 0x8F;
                    v.setRr(rc == 0);
                }
            } else if ("\u0414\u0438\u0444\u0444\u0435\u0440\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u043e\u043f\u0440\u0430\u0432\u043a\u0438".equals(p.title)) {
                Integer code = ((Long)p.head.get("\u0422\u0438\u043f \u0441\u0438\u0433\u043d\u0430\u043b\u0430")).intValue();
                String type = AmunGraphics.getTypeSystem(code);
                for (Map.Entry<String, Map<String, Number>> e : p.cycles.entrySet()) {
                    int n = e.getValue().get("PRN").intValue();
                    Double df = e.getValue().get("PRC").doubleValue();
                    Sputnik i = this.getItem(n, type, needRefresh);
                    String typeS = this.getTypeCh(code, type);
                    String typeSC = this.getTypeK(code, type, typeS);
                    SputnikValue v = i.getValue(typeS, typeSC, needRefresh);
                    v.setDiff(df);
                }
            } else if ("\u041d\u0430\u043b\u0438\u0447\u0438\u0435 \u043f\u043e\u043c\u0435\u0445".equals(p.title)) {
                for (Map<String, Number> m : p.cycles.values()) {
                    Integer code = ((Long)m.get("\u0422\u0438\u043f \u0441\u0438\u0433\u043d\u0430\u043b\u0430")).intValue();
                    int n = m.get("\u041d\u043e\u043c\u0435\u0440 \u0441\u043f\u0443\u0442\u043d\u0438\u043a\u0430").intValue();
                    String type = AmunGraphics.getTypeSystem(code);
                    Sputnik i = this.getItem(n, type, needRefresh);
                    String typeS = this.getTypeCh(code, type);
                    String typeSC = this.getTypeK(code, type, typeS);
                    Double r = m.get("\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u043f\u043e\u043c\u0435\u0445\u0438").doubleValue();
                    SputnikValue v = i.getValue(typeS, typeSC, needRefresh);
                    v.setPom(r);
                }
            } else if ("\u0426\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c".equals(p.title)) {
                Integer codeL1 = ((Long)p.head.get("\u0413\u041b\u041e\u041d\u0410\u0421\u0421 L1")).intValue();
                Integer codeL2 = ((Long)p.head.get("\u0413\u041b\u041e\u041d\u0410\u0421\u0421 L2")).intValue();
                Integer codeGPS = ((Long)p.head.get("GPS")).intValue();
                for (Sputnik s : this.listSputnik) {
                    int c;
                    int n;
                    if ("\u0413\u041b\u041e\u041d\u0410\u0421\u0421".equals(s.getType())) {
                        for (SputnikValue v : s.getListValues()) {
                            if ("L1".equals(v.getCh()) && codeL1 > 0) {
                                n = s.getNum();
                                c = codeL1 >> n - 1 & 1;
                                v.setCanuse(c == 1);
                                continue;
                            }
                            if (!"L2".equals(v.getCh()) || codeL2 <= 0) continue;
                            n = s.getNum();
                            c = codeL2 >> n - 1 & 1;
                            v.setCanuse(c == 1);
                        }
                        continue;
                    }
                    if (!"GPS".equals(s.getType()) || codeGPS <= 0) continue;
                    for (SputnikValue v : s.getListValues()) {
                        n = s.getNum();
                        c = codeGPS >> n - 1 & 1;
                        v.setCanuse(c == 1);
                    }
                }
            } else if ("\u0412\u0435\u043a\u0442\u043e\u0440 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043f\u043e\u0442\u0440\u0435\u0431\u0438\u0442\u0435\u043b\u044f".equals(p.title)) {
                this.lat = (double)((Double)p.head.get("\u0428\u0438\u0440\u043e\u0442\u0430"));
                this.lon = (double)((Double)p.head.get("\u0414\u043e\u043b\u0433\u043e\u0442\u0430"));
                if (this.lat != null && this.lon != null && !this.ed.booleanValue()) {
                    this.setButtEnabled(true);
                }
                this.updateCoord();
            }
        }
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLon() {
        return this.lon;
    }

    @ListField(fields={@Field(title="", order=10, viewer={DateWithoutButton.class}, propertiesLayout="1:0#w 100, cell 2 0# cell 1 0, grow 0", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ListField(fields={@Field(title=" ", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="1:0# w 105, cell 4 0#grow 0, cell 3 0", propertiesUI={"format=HH:mm:ss"})})
    public Date getTime() {
        return this.date;
    }

    public void setTime(Date date) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDate());
        c2.setTime(date);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.date = c1.getTime();
    }

    @ListField(fields={@Field(title=" ", order=30, viewer={ActionButton.class}, propertiesLayout="1:0#cell 2 1#cell 1 1, grow 0")})
    public BeanViewerAction<ViewerContext> getRun() {
        return this.run;
    }

    @ListField(fields={@Field(title=" ", order=30, viewer={ActionButton.class}, propertiesLayout="1:0#cell 6 0#cell 5 0, grow 0")})
    public BeanViewerAction<ViewerContext> getLoad() {
        return this.load;
    }

    @ListField(fields={@Field(title=" ", order=40, propertiesLayout="1:0#w 800, cell 8 0#cell 7 0, grow 0", readOnly=true)})
    public String getMessage() {
        return this.message;
    }

    private void setButtEnabled(boolean enable) {
        this.pc.getPanel().getPresentatorForName("showOnMap").getViewer().setEditable(enable);
    }

    private void updateCoord() {
        if (this.m != null) {
            this.m.getValue().change();
        }
    }

    @ListField(fields={@Field(title=" ", order=40, propertiesLayout="1:0#cell 9 0#cell 9 0, grow 0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getShowOnMap() {
        return this.showOnMap;
    }

    @ListField(fields={@Field(title="", order=10, propertiesLayout="1/fill:2/fill#grow", viewer={GraphicsViewer.class})})
    public Decoder.Package getObj() {
        return this.obj;
    }

    public void setObj(Decoder.Package obj) {
        this.obj = obj;
    }

    @ListField(fields={@Field(title="", order=20, propertiesLayout="1:3/fill/n/grow#grow#wrap", viewer={ItemViewer.class}, content=Item.class)})
    public List<Item> getList() {
        return this.list;
    }

    public void setList(List<Item> list) {
        this.list = list;
    }

    public void beforeShow(PanelContext pc) {
        this.pc = pc;
        this.setButtEnabled(false);
        TabSplitPercentLayoutManager l = (TabSplitPercentLayoutManager)pc.getPanel().getLayout();
        JPanel p = (JPanel)l.getComponentForName("1:2");
        this.dialog = new JIDialog(p);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.getContentPane().removeAll();
        this.dialog.getContentPane().add(p);
        this.dialog.setSize(800, 800);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setTitle(((BeanPanel)pc.getPanel()).getTitle());
        this.dialog.setVisible(true);
    }

    public void connecting() {
        SubscribingOptions_SendListDataFromSatellites options = new SubscribingOptions_SendListDataFromSatellites();
        options.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        options.setServiceName("DataFromSatellitesWS");
        options.setMethodName("sendData");
        options.setSystemName("amun");
        ArrayList<String> np = new ArrayList<String>();
        np.add("0xA0");
        np.add("0x91");
        np.add("0xBA");
        np.add("0xF0");
        np.add("0xF1");
        np.add("0x90");
        options.setPackageNames(np);
        options.setSid(this.sid);
        try {
            this.sid = SocketClientFactory.subscribe((Object)((Object)this), (SubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        UnsubscribingOptions optionsU = new UnsubscribingOptions();
        optionsU.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        optionsU.setServiceName("DataFromSatellitesWS");
        optionsU.setMethodName("sendData");
        optionsU.setSid(this.sid);
        try {
            SocketClientFactory.unsubscribe((UnsubscribingOptions)optionsU, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception exception) {}
    }

    public void beforeDestroy(PanelContext pc) {
        this.dialog.setVisible(false);
        this.close();
    }

    public void sendData(List<DataFromSatellites> list) {
        Boolean[] needRefresh = new Boolean[]{false};
        for (DataFromSatellites d : list) {
            Decoder.Package p = Decoder.dataProcess(d.getData());
            this.message = "\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 " + this.df.format(d.getDateData());
            this.currentDate = d.getDateData();
            this.analysPackage(p, d, needRefresh);
        }
        this.buildItems();
        this.pc.getPanel().updateUI();
    }

    public static class ChangeType
    extends ActionCalculatedObject {
        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(((ViewerContext)this.getContext()).getPresentator());
            Object o = ((ViewerContext)this.getContext()).getPresentator().getViewer().getValue();
            boolean rt = true;
            if (onDate.equals(o)) {
                rt = false;
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("date").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("time").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("load").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("message").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("run").getViewer().setEditable(rt);
            if (!initializing) {
                if (!rt) {
                    ((AmunGraphics)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getObject())).close();
                }
                ((AmunGraphics)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getObject())).cleardata();
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
            }
        }
    }

    public static class JIDialog
    extends JFrame {
        private static final long serialVersionUID = 269467979010416619L;
        JPanel p;

        public void close() {
        }

        public JIDialog(JPanel p) {
            this.p = p;
        }
    }

    public static class TypeViewer<T>
    extends RadioButtonViewer<T> {
        List<String> l;

        public TypeViewer(UIFactory<T> factory) {
            super(factory);
        }

        public List<?> getRadioElement() {
            this.l = new ArrayList<String>();
            this.l.add(onDate);
            this.l.add(realTime);
            return this.l;
        }

        public void setValue(Object object) {
            super.setValue(object);
            HashMap map = super.getMapComponent();
            JPanel p = (JPanel)((AbstractTabSplitPercentLayoutManager)((PanelContext)this.getViewerContext().getParentContext()).getPanel().getLayout()).getComponentForName("1:0");
            for (String c : this.l) {
                Object t = map.get(c);
                String cons = "";
                if (onDate.equals(c)) {
                    cons = "cell 0 0, grow 0";
                } else if (realTime.equals(c)) {
                    cons = "cell 0 1, grow 0";
                }
                p.add((Component)t, cons);
            }
            p.revalidate();
        }
    }
}

