/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.amun;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.PolarChartPanel;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.util.ShapeUtilities;
import ru.blok.vms.ui.Decoder;
import ru.blok.vms.ui.police.amun.AmunGraphics;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class GraphicsViewer
extends FieldViewer<JComponent>
implements SwingItem {
    private JComponent panel;
    Decoder.Package p;

    public GraphicsViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.panel = (JComponent)factory.getAugmentPanel();
    }

    public int getShape() {
        return 1;
    }

    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    public Object getValue() {
        return null;
    }

    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
    }

    public void setValue(Object object) {
        this.p = (Decoder.Package)object;
        this.createPolarChart();
    }

    public void createPolarChart() {
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        PolarChartPanel chartPanel = new PolarChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.panel.removeAll();
        this.panel.add((Component)chartPanel);
        this.panel.revalidate();
    }

    private XYDataset createDataset() {
        LabeledXYDataset s = new LabeledXYDataset();
        if (this.p != null) {
            for (Map<String, Number> m : this.p.cycles.values()) {
                Double r = m.get("\u0423\u0433\u043e\u043b \u0432\u043e\u0437\u0432\u044b\u0448\u0435\u043d\u0438\u044f").doubleValue();
                Double a = m.get("\u0410\u0437\u0438\u043c\u0443\u0442").doubleValue();
                int n = m.get("\u041d\u043e\u043c\u0435\u0440 \u0441\u043f\u0443\u0442\u043d\u0438\u043a\u0430").intValue();
                String type = AmunGraphics.getTypeSystem(((Long)m.get("\u0422\u0438\u043f \u0441\u0438\u0433\u043d\u0430\u043b\u0430")).intValue());
                s.addData(a, r, n, type);
            }
        }
        return s;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createPolarChart((String)"\u0412\u0438\u0434\u0438\u043c\u044b\u0435 \u0441\u043f\u0443\u0442\u043d\u0438\u043a\u0438", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        PolarPlot plot = (PolarPlot)chart.getPlot();
        DefaultPolarItemRenderer renderer = new DefaultPolarItemRenderer(){
            private static final long serialVersionUID = -3263836143114471721L;

            public void drawSeries(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, PolarPlot plot, XYDataset dataset, int seriesIndex) {
                int numPoints = dataset.getItemCount(seriesIndex);
                if (numPoints == 0) {
                    return;
                }
                Path2D poly = null;
                ValueAxis axis = plot.getAxisForDataset(plot.indexOf(dataset));
                int i = 0;
                while (i < numPoints) {
                    double theta = dataset.getXValue(seriesIndex, i);
                    double radius = dataset.getYValue(seriesIndex, i);
                    Point p = plot.translateToJava2D(theta, radius, axis, dataArea);
                    if (poly == null) {
                        poly = new GeneralPath();
                        ((Path2D.Float)poly).moveTo(p.x, p.y);
                    } else {
                        ((Path2D.Float)poly).lineTo(p.x, p.y);
                    }
                    ++i;
                }
                if (!$assertionsDisabled && poly == null) {
                    throw new AssertionError();
                }
                if (this.getConnectFirstAndLastPoint()) {
                    poly.closePath();
                }
                g2.setPaint(this.lookupSeriesPaint(seriesIndex));
                g2.setStroke(this.lookupSeriesStroke(seriesIndex));
                EntityCollection entities = null;
                if (info != null) {
                    entities = info.getOwner().getEntityCollection();
                }
                PathIterator pi = ((Path2D.Float)poly).getPathIterator(null);
                int i2 = 0;
                while (!pi.isDone()) {
                    float[] coords = new float[6];
                    int segType = pi.currentSegment(coords);
                    pi.next();
                    if (segType != 1 && segType != 0) continue;
                    int x = Math.round(coords[0]);
                    int y = Math.round(coords[1]);
                    LabeledXYDataset lds = (LabeledXYDataset)dataset;
                    String l = lds.getL(seriesIndex, i2);
                    Shape shape = ShapeUtilities.createTranslatedShape((Shape)this.getItemShape(seriesIndex, i2++), (double)x, (double)y);
                    Paint paint = this.getUseFillPaint() ? this.lookupSeriesFillPaint(seriesIndex) : this.lookupSeriesPaint(seriesIndex);
                    g2.setPaint(paint);
                    g2.fill(shape);
                    g2.setColor(Color.WHITE);
                    g2.draw(shape);
                    FontMetrics f = g2.getFontMetrics();
                    int w1 = f.stringWidth(l);
                    TextUtilities.drawRotatedString((String)l, (Graphics2D)g2, (double)0.0, (float)(x - w1 / 2), (float)(y + f.getHeight() / 2 - 3));
                    if (this.isSeriesFilled(seriesIndex) && this.getDrawOutlineWhenFilled()) {
                        g2.setPaint(this.lookupSeriesOutlinePaint(seriesIndex));
                        g2.setStroke(this.lookupSeriesOutlineStroke(seriesIndex));
                        g2.draw(shape);
                    }
                    if (entities == null || !AbstractXYItemRenderer.isPointInRect((Rectangle2D)dataArea, (double)x, (double)y)) continue;
                    this.addEntity(entities, shape, dataset, seriesIndex, i2 - 1, x, y);
                }
            }
        };
        plot.setRenderer((PolarItemRenderer)renderer);
        renderer.setShapesVisible(true);
        plot.getAxis().setAutoRange(false);
        plot.getAxis().setRange(0.0, 90.0);
        plot.getAxis().setInverted(true);
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-15.0, -15.0, 30.0, 30.0));
        renderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(-15.0, -15.0, 30.0, 30.0));
        renderer.setSeriesShape(2, (Shape)new Ellipse2D.Double(-15.0, -15.0, 30.0, 30.0));
        renderer.setSeriesShape(3, (Shape)new Ellipse2D.Double(-15.0, -15.0, 30.0, 30.0));
        renderer.setSeriesShape(4, (Shape)new Ellipse2D.Double(-15.0, -15.0, 30.0, 30.0));
        renderer.setSeriesShape(5, (Shape)new Ellipse2D.Double(-15.0, -15.0, 30.0, 30.0));
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.BLUE);
        renderer.setSeriesPaint(2, (Paint)Color.GREEN);
        renderer.setSeriesPaint(3, (Paint)Color.YELLOW.darker());
        renderer.setSeriesPaint(4, (Paint)Color.MAGENTA);
        renderer.setSeriesPaint(5, (Paint)Color.GRAY);
        return chart;
    }

    private static void createRandomData(LabeledXYDataset s, String name, double baseRadius, double thetaInc) {
        double radius = baseRadius * (1.0 + Math.random());
        double theta = Math.random() * 360.0;
        s.addData(theta, radius, 1, "");
        radius = baseRadius * (1.0 + Math.random());
        theta = Math.random() * 360.0;
        s.addData(theta, radius, 2, "");
    }

    private static class LabeledXYDataset
    implements XYDataset {
        List<Series> seriesName = new ArrayList<Series>();

        public LabeledXYDataset() {
            this.seriesName.add(new Series("\u0413\u041b\u041e\u041d\u0410\u0421\u0421"));
            this.seriesName.add(new Series("GPS"));
            this.seriesName.add(new Series("SBAS"));
            this.seriesName.add(new Series("Galileo"));
            this.seriesName.add(new Series("GIOVE"));
            this.seriesName.add(new Series("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e"));
        }

        public void addData(Double x, Double y, int num, String type) {
            Series s;
            switch (type) {
                case "\u0413\u041b\u041e\u041d\u0410\u0421\u0421": {
                    s = this.seriesName.get(0);
                    break;
                }
                case "GPS": {
                    s = this.seriesName.get(1);
                    break;
                }
                case "SBAS": {
                    s = this.seriesName.get(2);
                    break;
                }
                case "Galileo": {
                    s = this.seriesName.get(3);
                    break;
                }
                case "GIOVE": {
                    s = this.seriesName.get(4);
                    break;
                }
                default: {
                    s = this.seriesName.get(5);
                }
            }
            s.add(x, y, Integer.toString(num));
        }

        public int getSeriesCount() {
            return this.seriesName.size();
        }

        public Comparable getSeriesKey(int arg0) {
            return this.seriesName.get((int)arg0).name;
        }

        public int indexOf(Comparable arg0) {
            return this.seriesName.indexOf(arg0);
        }

        public void addChangeListener(DatasetChangeListener arg0) {
        }

        public DatasetGroup getGroup() {
            return null;
        }

        public void removeChangeListener(DatasetChangeListener arg0) {
        }

        public void setGroup(DatasetGroup arg0) {
        }

        public DomainOrder getDomainOrder() {
            return null;
        }

        public int getItemCount(int arg0) {
            return this.seriesName.get(arg0).xValues.size();
        }

        public Number getX(int arg0, int arg1) {
            return (Number)this.seriesName.get(arg0).xValues.get(arg1);
        }

        public double getXValue(int arg0, int arg1) {
            return (Double)this.seriesName.get(arg0).xValues.get(arg1);
        }

        public Number getY(int arg0, int arg1) {
            return (Number)this.seriesName.get(arg0).yValues.get(arg1);
        }

        public double getYValue(int arg0, int arg1) {
            return (Double)this.seriesName.get(arg0).yValues.get(arg1);
        }

        public String getL(int arg0, int arg1) {
            return (String)this.seriesName.get(arg0).lValues.get(arg1);
        }
    }

    private static class Series {
        String name;
        private List<Double> xValues = new ArrayList<Double>();
        private List<Double> yValues = new ArrayList<Double>();
        private List<String> lValues = new ArrayList<String>();

        public Series(String name) {
            this.name = name;
        }

        public void add(Double x, Double y, String l) {
            this.xValues.add(x);
            this.yValues.add(y);
            this.lValues.add(l);
        }
    }
}

