/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.amun.amuntable;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class DPViewer
extends FieldViewer<JComponent>
implements SwingItem {
    public DPViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    public Class<? extends FieldViewer<JComponent>> getTableCellViewerClass() {
        return TableDPViewerHViewer.class;
    }

    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return null;
    }

    public Object getValue() {
        return null;
    }

    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
    }

    public void setValue(Object object) {
    }

    public static class TableDPViewerHViewer
    extends FieldViewer<JComponent>
    implements SwingItem {
        JPanel comp = new JPanel(){
            private static final long serialVersionUID = 134778846031695790L;

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (value != null) {
                    Color c = new Color(7186175);
                    DecimalFormat df = new DecimalFormat("###,##0.00");
                    int w = (int)((double)this.getWidth() * 0.85);
                    int b = this.getWidth() - w;
                    int z = b + (int)((double)w * 0.8);
                    int wr = (int)((double)w * Math.abs(value) / 100.0);
                    int bd = 0;
                    if (value < 0.0) {
                        bd = z - wr;
                    }
                    g.setColor(c);
                    g.fillRect(bd, 1, wr, this.getHeight() - 3);
                    g.setColor(c.darker());
                    g.drawRect(bd, 1, wr, this.getHeight() - 3);
                    g.setColor(c.darker().darker());
                    g.drawLine(z, 0, z, this.getHeight());
                    int bn = wr + 5;
                    String vs = df.format(value);
                    if (value < 0.0) {
                        FontMetrics f = g.getFontMetrics();
                        bn = bd - f.stringWidth(vs) - 5;
                    }
                    g.drawString(vs, bn, this.getHeight() - 3);
                }
            }
        };
        Double value;

        public JComponent getComponent(boolean isSelected, boolean hasFocus) {
            return this.comp;
        }

        public TableDPViewerHViewer(UIFactory<JComponent> factory) {
            super(factory);
            this.comp.setBorder(null);
        }

        public Object getValue() {
            return this.value;
        }

        public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
        }

        public void setValue(Object object) {
            this.value = (Double)object;
        }
    }
}

