/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.amun.amuntable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ru.blok.vms.ui.police.amun.amuntable.Item;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.table.TableWithModel;
import ru.infor.beanviewer.swing.viewers.list.SwingListTableModel;
import ru.infor.beanviewer.swing.viewers.list.TableUIProperties;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.BeanPanelInList;
import ru.infor.beanviewer.viewer.list.ListViewer;

public class ItemViewer
extends ListViewer<JComponent> {
    public ItemViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    public void setViewerContext(ViewerContext viewerContext) {
        super.setViewerContext(viewerContext);
        int i = 0;
        while (i < this.getTM().getColumnCount()) {
            this.getTM().getViewerToRenderer(i).setViewerContext(viewerContext);
            ++i;
        }
    }

    public TableWithModel<JComponent> getTM() {
        if (this.tm == null) {
            this.tm = new TableModel((BigContentViewer<JComponent>)this);
            this.panel = new BeanPanelInList(this.tm, this.getFactory());
            this.tm.setBp(this.panel);
            this.tm.setExtendedObject((TableWithModel.WorkExtendedObject)new WorkEventsExtendedObject((TableWithModel<JComponent>)this.tm));
            this.panel.setViewerContext(this.getViewerContext());
        }
        return this.tm;
    }

    public void initColumn(JTable table) {
        TableColumnModel cm = table.getColumnModel();
        ColumnGroup g1 = new ColumnGroup("\u0420\u0435\u0442\u0440\u043e\u0441\u043f\u0435\u043a\u0442\u0438\u0432\u0430 \u0443\u0440\u043e\u0432\u043d\u0435\u0439 \u0441\u0438\u0433\u043d\u0430\u043b\u043e\u0432");
        int i = 11;
        while (i <= 17) {
            g1.add(cm.getColumn(i));
            ++i;
        }
        GroupableTableHeader header = (GroupableTableHeader)table.getTableHeader();
        header.addColumnGroup(g1);
    }

    public static class ColumnGroup {
        protected TableCellRenderer renderer;
        protected Vector v;
        protected String text;
        protected int margin = 0;

        public ColumnGroup(String text) {
            this(null, text);
        }

        public ColumnGroup(TableCellRenderer renderer, String text) {
            this.renderer = renderer == null ? new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JTableHeader header = table.getTableHeader();
                    if (header != null) {
                        this.setForeground(header.getForeground());
                        this.setBackground(header.getBackground());
                        this.setFont(header.getFont());
                    }
                    this.setHorizontalAlignment(0);
                    this.setText(value == null ? "" : value.toString());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    return this;
                }
            } : renderer;
            this.text = text;
            this.v = new Vector();
        }

        public void add(Object obj) {
            if (obj == null) {
                return;
            }
            this.v.addElement(obj);
        }

        public Vector getColumnGroups(TableColumn c, Vector g) {
            g.addElement(this);
            if (this.v.contains(c)) {
                return g;
            }
            Enumeration enumm = this.v.elements();
            while (enumm.hasMoreElements()) {
                Vector groups;
                Object obj = enumm.nextElement();
                if (!(obj instanceof ColumnGroup) || (groups = ((ColumnGroup)obj).getColumnGroups(c, (Vector)g.clone())) == null) continue;
                return groups;
            }
            return null;
        }

        public TableCellRenderer getHeaderRenderer() {
            return this.renderer;
        }

        public void setHeaderRenderer(TableCellRenderer renderer) {
            if (renderer != null) {
                this.renderer = renderer;
            }
        }

        public Object getHeaderValue() {
            return this.text;
        }

        public Dimension getSize(JTable table) {
            Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
            int height = comp.getPreferredSize().height;
            int width = 0;
            Enumeration enumm = this.v.elements();
            while (enumm.hasMoreElements()) {
                Object obj = enumm.nextElement();
                if (obj instanceof TableColumn) {
                    TableColumn aColumn = (TableColumn)obj;
                    width += aColumn.getWidth();
                    width += this.margin;
                    width = (int)((double)width - (table.getIntercellSpacing().getWidth() + 0.0));
                    continue;
                }
                width += ((ColumnGroup)obj).getSize((JTable)table).width;
            }
            return new Dimension(width, height);
        }

        public void setColumnMargin(int margin) {
            this.margin = margin;
            Enumeration enumm = this.v.elements();
            while (enumm.hasMoreElements()) {
                Object obj = enumm.nextElement();
                if (!(obj instanceof ColumnGroup)) continue;
                ((ColumnGroup)obj).setColumnMargin(margin);
            }
        }
    }

    public static class GroupableTableHeader
    extends JTableHeader {
        protected Vector columnGroups = null;

        public GroupableTableHeader(TableColumnModel model) {
            super(model);
            this.setUI(new GroupableTableHeaderUI());
            this.setReorderingAllowed(false);
        }

        @Override
        public void setReorderingAllowed(boolean b) {
            this.reorderingAllowed = false;
        }

        public void addColumnGroup(ColumnGroup g) {
            if (this.columnGroups == null) {
                this.columnGroups = new Vector();
            }
            this.columnGroups.addElement(g);
        }

        public Enumeration getColumnGroups(TableColumn col) {
            if (this.columnGroups == null) {
                return null;
            }
            Enumeration enumm = this.columnGroups.elements();
            while (enumm.hasMoreElements()) {
                ColumnGroup cGroup = (ColumnGroup)enumm.nextElement();
                Vector v_ret = cGroup.getColumnGroups(col, new Vector());
                if (v_ret == null) continue;
                return v_ret.elements();
            }
            return null;
        }

        public void setColumnMargin() {
            if (this.columnGroups == null) {
                return;
            }
            int columnMargin = this.getColumnModel().getColumnMargin();
            Enumeration enumm = this.columnGroups.elements();
            while (enumm.hasMoreElements()) {
                ColumnGroup cGroup = (ColumnGroup)enumm.nextElement();
                cGroup.setColumnMargin(columnMargin);
            }
        }
    }

    public static class GroupableTableHeaderUI
    extends BasicTableHeaderUI {
        @Override
        public void paint(Graphics g, JComponent c) {
            Rectangle clipBounds = g.getClipBounds();
            if (this.header.getColumnModel() == null) {
                return;
            }
            ((GroupableTableHeader)this.header).setColumnMargin();
            int column = 0;
            Dimension size = this.header.getSize();
            Rectangle cellRect = new Rectangle(0, 0, size.width, size.height);
            Hashtable<ColumnGroup, Rectangle> h = new Hashtable<ColumnGroup, Rectangle>();
            int columnMargin = this.header.getColumnModel().getColumnMargin();
            Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                cellRect.height = size.height;
                cellRect.y = 0;
                TableColumn aColumn = enumeration.nextElement();
                Enumeration cGroups = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
                if (cGroups != null) {
                    int groupHeight = 0;
                    while (cGroups.hasMoreElements()) {
                        ColumnGroup cGroup = (ColumnGroup)cGroups.nextElement();
                        Rectangle groupRect = (Rectangle)h.get(cGroup);
                        if (groupRect == null) {
                            groupRect = new Rectangle(cellRect);
                            Dimension d = cGroup.getSize(this.header.getTable());
                            groupRect.width = d.width;
                            groupRect.height = d.height;
                            h.put(cGroup, groupRect);
                        }
                        this.paintCell(g, groupRect, cGroup);
                        cellRect.height = size.height - (groupHeight += groupRect.height);
                        cellRect.y = groupHeight;
                    }
                }
                cellRect.width = aColumn.getWidth() + columnMargin - (int)(this.header.getTable().getIntercellSpacing().getWidth() + 0.0);
                if (cellRect.intersects(clipBounds)) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += cellRect.width;
                ++column;
            }
        }

        private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
            TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
            TableCellRenderer renderer = aColumn.getHeaderRenderer() != null ? aColumn.getHeaderRenderer() : this.header.getDefaultRenderer();
            Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
            this.rendererPane.add(component);
            this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }

        private void paintCell(Graphics g, Rectangle cellRect, ColumnGroup cGroup) {
            TableCellRenderer renderer = cGroup.getHeaderRenderer();
            Component component = renderer.getTableCellRendererComponent(this.header.getTable(), cGroup.getHeaderValue(), false, false, -1, -1);
            this.rendererPane.add(component);
            this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }

        private int getHeaderHeight() {
            int height = 0;
            TableColumnModel columnModel = this.header.getColumnModel();
            int column = 0;
            while (column < columnModel.getColumnCount()) {
                TableColumn aColumn = columnModel.getColumn(column);
                TableCellRenderer renderer = aColumn.getHeaderRenderer() != null ? aColumn.getHeaderRenderer() : this.header.getDefaultRenderer();
                Component comp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
                int cHeight = comp.getPreferredSize().height;
                Enumeration enumm = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
                if (enumm != null) {
                    while (enumm.hasMoreElements()) {
                        ColumnGroup cGroup = (ColumnGroup)enumm.nextElement();
                        cHeight += cGroup.getSize((JTable)this.header.getTable()).height;
                    }
                    height = Math.max(height, cHeight);
                }
                ++column;
            }
            return height;
        }

        private Dimension createHeaderSize(long width) {
            TableColumnModel columnModel = this.header.getColumnModel();
            if ((width += (long)(columnModel.getColumnMargin() * columnModel.getColumnCount())) > Integer.MAX_VALUE) {
                width = Integer.MAX_VALUE;
            }
            return new Dimension((int)width, this.getHeaderHeight());
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            long width = 0L;
            Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn aColumn = enumeration.nextElement();
                width += (long)aColumn.getPreferredWidth();
            }
            return this.createHeaderSize(width);
        }
    }

    public static class TableModel
    extends SwingListTableModel {
        public TableModel(BigContentViewer<JComponent> vie) {
            super(vie);
        }

        public void updateModel(List<Object> list, Class<?> item, UIFactory<JComponent> factory, PanelContext pc, TableUIProperties properties, boolean containClassWasChanged, String keyContentProperties) {
            super.updateModel(list, item, factory, pc, properties, containClassWasChanged, keyContentProperties);
            ((ItemViewer)this.viewer).initColumn((JTable)this.getTableComponent());
        }

        protected void setHeader() {
            GroupableTableHeader g = new GroupableTableHeader(((JTable)this.getTableComponent()).getColumnModel());
            ((JTable)this.getTableComponent()).setTableHeader(g);
        }
    }

    public static class WorkEventsExtendedObject
    extends TableWithModel.WorkExtendedObject<JComponent> {
        public WorkEventsExtendedObject(TableWithModel<JComponent> tm) {
            super(tm);
        }

        public Color[] getColorForegroundBackgroundTable(Object value, int row, int column) {
            Item rr = (Item)this.getTm().list.get(row);
            Color c = rr.getColor();
            return new Color[]{c, c.darker().darker()};
        }
    }
}

