/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.dispositionplans.josm;

import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.josm.CommonDataSet;
import ru.infor.client.soap.proxy.vms.InfoPointWSProxy;
import ru.infor.client.soap.proxy.vms.PolicePostWSProxy;
import ru.infor.ws.objects.police.entities.PolicePost;
import ru.infor.ws.objects.vms.entities.InfoPoint;

public class PolicePostDataSet
extends CommonDataSet {
    PolicePostWSProxy proxy = (PolicePostWSProxy)CurrentProxyFactory.getProxy(PolicePost.class);
    InfoPointWSProxy proxypoint = (InfoPointWSProxy)CurrentProxyFactory.getProxy(InfoPoint.class);
    PolicePost postExt;
    Node center;

    public PolicePostDataSet(String keyPage, PolicePost post) throws SQLException {
        super(keyPage);
        this.postExt = post.getId() != null ? this.proxy.getCurrentObject(InitializedVariable.context, post.getId()) : post;
        String geom = this.postExt.getGeom();
        this.analysGeom(geom);
        if (this.postExt.getPoint() != null) {
            this.center = new Node(new LatLon(this.postExt.getPoint().getPrLat().doubleValue(), this.postExt.getPoint().getPrLon().doubleValue()));
            this.center.put("center_point", "yes");
            this.addPrimitive((OsmPrimitive)this.center);
        }
        if (geom == null && this.center == null) {
            Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
            if (coord == null) {
                coord = new Double[]{58.0508, 38.8255};
            }
            Node n = new Node(new LatLon(coord[0].doubleValue(), coord[1].doubleValue()));
            this.addPrimitive((OsmPrimitive)n);
        }
    }

    @Override
    protected boolean isClosed() {
        return true;
    }

    public static boolean pointInPolygon(Polygon polygon, Node center) {
        boolean in = false;
        Point p1 = polygon.getPoint(0);
        int i = 1;
        while (i <= polygon.numPoints()) {
            Point p2 = i == polygon.numPoints() ? polygon.getPoint(0) : polygon.getPoint(i);
            if (center.getCoor().getX() > Math.min(p1.getX(), p2.getX()) && center.getCoor().getX() <= Math.max(p1.getX(), p2.getX()) && center.getCoor().getY() <= Math.max(p1.getY(), p2.getY()) && p1.getY() != p2.getY()) {
                double d = (center.getCoor().getX() - p1.getX()) * (p2.getY() - p1.getY()) / (p2.getX() - p1.getX()) + p1.getY();
                if (p1.getY() == p2.getY() || center.getCoor().getY() <= d) {
                    in = !in;
                }
            }
            p1 = p2;
            ++i;
        }
        return in;
    }

    @Override
    protected boolean saveObject(String geom) {
        if (geom != null && geom.toLowerCase().indexOf("Polygon".toLowerCase()) > -1) {
            block10: {
                Polygon p;
                block9: {
                    p = new Polygon(geom);
                    if (this.center != null) break block9;
                    Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected zone is not close");
                    JOptionPane.showMessageDialog(null, "\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0446\u0435\u043d\u0442\u0440\u0430 \u043f\u043e\u0441\u0442\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    return false;
                }
                if (PolicePostDataSet.pointInPolygon(p, this.center)) break block10;
                Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected zone is not close");
                JOptionPane.showMessageDialog(null, "\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0446\u0435\u043d\u0442\u0440\u0430 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            try {
                InfoPoint pp = null;
                pp = this.postExt.getPoint() != null ? this.postExt.getPoint() : new InfoPoint();
                pp.setPrLat(Double.valueOf(this.center.getCoor().getY()));
                pp.setPrLon(Double.valueOf(this.center.getCoor().getX()));
                if (pp.getId() == null) {
                    pp = this.proxypoint.save(InitializedVariable.context, pp);
                }
                this.postExt.setPoint(pp);
                this.postExt.setGeom(geom);
                this.postExt = this.proxy.save(InitializedVariable.context, this.postExt);
                return true;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (this.center != null) {
            InfoPoint pp = null;
            pp = this.postExt.getPoint() != null ? this.postExt.getPoint() : new InfoPoint();
            pp.setPrLat(Double.valueOf(this.center.getCoor().getY()));
            pp.setPrLon(Double.valueOf(this.center.getCoor().getX()));
            if (pp.getId() == null) {
                pp = this.proxypoint.save(InitializedVariable.context, pp);
            }
            this.postExt.setPoint(pp);
            this.postExt.setGeom(geom);
            this.postExt = this.proxy.save(InitializedVariable.context, this.postExt);
            return true;
        }
        return false;
    }

    @Override
    public void save() {
        Way[] tracks = null;
        if (this.getSelectedWays().size() == 0) {
            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected ways is null");
        } else {
            tracks = this.getSelectedWays().toArray(new Way[0]);
            this.track = tracks[0];
        }
        if (tracks == null && this.center == null) {
            JOptionPane.showMessageDialog(null, "\u041d\u0438 \u043e\u0434\u043d\u0430 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
        } else if (tracks == null) {
            this.saveObject(null);
            JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0446\u0435\u043d\u0442\u0440\u0430 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
        } else {
            boolean ok = true;
            if (this.isClosed()) {
                Way[] wayArray = tracks;
                int n = tracks.length;
                int n2 = 0;
                while (n2 < n) {
                    Way w = wayArray[n2];
                    if (!w.isClosed()) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected zone is not close");
                        JOptionPane.showMessageDialog(null, "\u041e\u0434\u043d\u0430 \u0438\u0437 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u0437\u043e\u043d \u043d\u0435 \u0437\u0430\u043c\u043a\u043d\u0443\u0442\u0430\u044f", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                        ok = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (ok) {
                StringBuilder st;
                if (tracks.length == 1) {
                    st = new StringBuilder(this.getSRID());
                    if (this.isClosed()) {
                        st.append("POLYGON((");
                    } else {
                        st.append("MULTILINESTRING((");
                    }
                    int i = 0;
                    while (i < this.track.getNodesCount()) {
                        Node n = this.track.getNode(i);
                        double x = n.getCoor().lat();
                        double y = n.getCoor().lon();
                        if (i > 0) {
                            st.append(",");
                        }
                        st.append(y).append(" ").append(x);
                        ++i;
                    }
                    st.append("))");
                    if (this.track != null && this.track.getNodesCount() > 0) {
                        this.crdObject = this.track.getNode(0).getCoor();
                    }
                    if (ok = this.saveObject(st.toString())) {
                        JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
                    }
                } else {
                    st = new StringBuilder(this.getSRID());
                    if (this.isClosed()) {
                        st.append("MULTIPOLYGON(");
                    } else {
                        st.append("MULTILINESTRING(");
                    }
                    boolean z = false;
                    Way[] wayArray = tracks;
                    int n = tracks.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Way ww = wayArray[n3];
                        if (z) {
                            st.append(",");
                        } else {
                            z = true;
                        }
                        if (this.isClosed()) {
                            st.append("((");
                        } else {
                            st.append("(");
                        }
                        boolean zz = false;
                        int i = 0;
                        while (i < ww.getNodesCount()) {
                            Node n4 = ww.getNode(i);
                            double x = n4.getCoor().lat();
                            double y = n4.getCoor().lon();
                            if (zz) {
                                st.append(",");
                            } else {
                                zz = true;
                            }
                            st.append(y).append(" ").append(x);
                            ++i;
                        }
                        if (this.isClosed()) {
                            st.append("))");
                        } else {
                            st.append(")");
                        }
                        ++n3;
                    }
                    st.append(")");
                    if (tracks != null && tracks.length > 0 && tracks[0].getNodesCount() > 0) {
                        this.crdObject = tracks[0].getNode(0).getCoor();
                    }
                    if (ok = this.saveObject(st.toString())) {
                        JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
                    }
                }
            }
        }
    }
}

