/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.dispositionplans.map;

import java.util.List;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.vms.ui.police.dispositionplans.map.PostPainter;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.police.entities.PolicePost;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    PostPainter<JXMapViewer> postPainter;
    List<PolicePost> posts;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.postPainter = new PostPainter();
        this.painter.addPainter(this.postPainter);
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.postPainter != null && this.postPainter.getListPolygon() != null) {
            for (Polygon p : this.postPainter.getListPolygon()) {
                int i = 0;
                while (i < p.numPoints()) {
                    Point d = p.getPoint(i);
                    if (minLat == null || d.getY() < minLat) {
                        minLat = d.getY();
                    }
                    if (maxLat == null || d.getY() > maxLat) {
                        maxLat = d.getY();
                    }
                    if (minLon == null || d.getX() < minLon) {
                        minLon = d.getX();
                    }
                    if (maxLon == null || d.getX() > maxLon) {
                        maxLon = d.getX();
                    }
                    ++i;
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(null);
        this.posts = (List)arg0;
        this.postPainter.setPosts(this.posts);
        this.zoomToTracks();
    }
}

