/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.operationalinformation;

import java.awt.Color;
import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherAdapter;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jxmapviewer.viewer.GeoPosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import ru.blok.vms.ui.police.operationalinformation.OperationalInformation;
import ru.infor.common.SysProperties;

public abstract class ObjectToView<T> {
    public static String svgPrefix = "";
    public static String prefix = "/data";
    static String image;
    static String imageH;
    protected Long id;
    protected T object;
    protected SVGDocument doc;
    protected SVGDocument docH;
    protected int h = 30;
    protected int w = 20;
    protected boolean show = true;
    protected boolean select = false;
    protected JSVGCanvas canvas;
    protected JSVGCanvas canvasH;
    protected AffineTransform tx;
    protected RunnableQueue queue;
    protected RunnableQueue queue2;
    protected boolean onClickWasSet = false;
    protected OperationalInformation information;
    public DecimalFormat defs = new DecimalFormat("###0.##");
    static String parser;
    static SAXSVGDocumentFactory f;

    static {
        String cacheDataFolder = SysProperties.getProperty((String)"path.resource", (String)"");
        if (!cacheDataFolder.trim().equals("")) {
            cacheDataFolder = String.valueOf(cacheDataFolder) + File.separator;
        }
        svgPrefix = cacheDataFolder;
        image = "";
        imageH = "/iconssvg/hint.svg";
        parser = XMLResourceDescriptor.getXMLParserClassName();
        f = new SAXSVGDocumentFactory(parser);
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public boolean isSelect() {
        return this.select;
    }

    public void dispose() {
        this.canvas.dispose();
        if (this.canvas.getParent() != null) {
            this.canvas.getParent().remove((Component)this.canvas);
        }
        if (this.canvasH != null) {
            this.canvasH.dispose();
            if (this.canvasH.getParent() != null) {
                this.canvasH.getParent().remove((Component)this.canvasH);
            }
        }
    }

    public void setSelect(boolean select) {
        this.select = select;
    }

    public Long getId() {
        return this.id;
    }

    public abstract void setImage(String var1);

    public abstract void initIcon();

    public abstract void initangle();

    public abstract void select(long var1);

    public abstract void setterHint();

    public abstract GeoPosition getGeoposition();

    public ObjectToView(final Long id, T object, OperationalInformation information, String image) {
        this.information = information;
        this.id = id;
        this.object = object;
        this.setImage(image);
        this.loadImage();
        this.initIcon();
        this.canvas = new JSVGCanvas();
        this.canvas.setDocumentState(1);
        this.canvas.setDocument((Document)this.doc);
        String ww = this.doc.getRootElement().getAttribute("width");
        String hh = this.doc.getRootElement().getAttribute("height");
        this.canvas.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
        if (this.docH != null) {
            this.canvasH = new JSVGCanvas();
            this.canvasH.setDocumentState(1);
            this.canvasH.setDocument((Document)this.docH);
            ww = this.docH.getRootElement().getAttribute("width");
            hh = this.docH.getRootElement().getAttribute("height");
            this.canvasH.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
            this.canvasH.setBackground(new Color(0, 0, 0, 0));
            this.canvasH.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)new SVGLoadEventDispatcherAdapter(){

                public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
                    ObjectToView.this.queue2 = ObjectToView.this.canvasH.getUpdateManager().getUpdateRunnableQueue();
                }
            });
        }
        this.canvas.setBackground(new Color(0, 0, 0, 0));
        this.tx = this.canvas.getRenderingTransform();
        this.canvas.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)new SVGLoadEventDispatcherAdapter(){

            public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
                Element elt;
                EventTarget t;
                ObjectToView.this.queue = ObjectToView.this.canvas.getUpdateManager().getUpdateRunnableQueue();
                ObjectToView.this.initangle();
                if (!ObjectToView.this.onClickWasSet && (t = (EventTarget)((Object)(elt = ObjectToView.this.canvas.getSVGDocument().getElementById("gMainGroup")))) != null && id != null) {
                    t.addEventListener("click", new OnClickAction(id), false);
                    ObjectToView.this.onClickWasSet = true;
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.canvas;
    }

    public JComponent getComponentH() {
        return this.canvasH;
    }

    public SVGDocument getDoc() {
        return this.doc;
    }

    public void setDoc(SVGDocument doc) {
        this.doc = doc;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public void reload() {
        this.canvas.setDocument((Document)this.doc);
        this.canvas.repaint();
        this.setterHint();
        if (this.docH != null) {
            this.canvasH.setDocument((Document)this.docH);
            this.canvasH.repaint();
        }
    }

    public static SVGDocument loadImage(String image) {
        File file = svgPrefix.equals("") ? new File(ObjectToView.class.getResource(String.valueOf(prefix) + image).getFile()) : new File(String.valueOf(svgPrefix) + image);
        try {
            SVGDocument doc = f.createSVGDocument(file.toURI().toString());
            return doc;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadImage() {
        this.doc = ObjectToView.loadImage(image);
        if (imageH != null) {
            this.docH = ObjectToView.loadImage(imageH);
        }
    }

    public static void changeColorFill(Integer color, Element e, Double opacity) {
        if (e != null && color != null) {
            String s = e.getAttribute("style");
            int k = s.indexOf("fill:#");
            StringBuilder r = new StringBuilder();
            if (k > 0) {
                r.append(s.substring(0, k));
            }
            r.append("fill:#").append(Integer.toHexString(color).substring(2)).append(s.substring(k + 12));
            s = r.toString();
            if (opacity != null) {
                k = s.indexOf("opacity:");
                r = new StringBuilder();
                if (k > 0) {
                    r.append(s.substring(0, k));
                    r.append("opacity:").append(opacity).append(s.substring(k + 9));
                    s = r.toString();
                }
            }
            if (s != null && !"".equals(s)) {
                e.setAttribute("style", s);
            }
        }
    }

    public static void changeColorLine(Integer color, Element e) {
        if (e != null) {
            String s = e.getAttribute("style");
            int k = s.indexOf("stroke:#");
            StringBuilder r = new StringBuilder();
            if (k > 0) {
                r.append(s.substring(0, k));
                r.append("stroke:#").append(Integer.toHexString(color).substring(2)).append(s.substring(k + 14));
                e.setAttribute("style", r.toString());
            }
        }
    }

    public static void setopacity1(Element e1, boolean opacity) {
        if (opacity) {
            e1.setAttribute("style", e1.getAttribute("style").replace("stroke-opacity:0", "stroke-opacity:1"));
            e1.setAttribute("style", e1.getAttribute("style").replace("fill-opacity:0", "fill-opacity:1"));
            e1.setAttribute("style", e1.getAttribute("style").replace("opacity:0", "opacity:1"));
        } else {
            e1.setAttribute("style", e1.getAttribute("style").replace("stroke-opacity:1", "stroke-opacity:0"));
            e1.setAttribute("style", e1.getAttribute("style").replace("fill-opacity:1", "fill-opacity:0"));
            e1.setAttribute("style", e1.getAttribute("style").replace("opacity:1", "opacity:0"));
        }
    }

    public SVGDocument getDocH() {
        return this.docH;
    }

    public void setDocH(SVGDocument docH) {
        this.docH = docH;
    }

    public void resize() {
        String ww = this.doc.getRootElement().getAttribute("width");
        String hh = this.doc.getRootElement().getAttribute("height");
        this.canvas.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
    }

    public void resize2() {
        String ww = this.docH.getRootElement().getAttribute("width");
        String hh = this.docH.getRootElement().getAttribute("height");
        this.canvasH.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
    }

    public class OnClickAction
    implements EventListener {
        private long id;

        public OnClickAction(long id) {
            this.id = id;
        }

        @Override
        public void handleEvent(Event evt) {
            ObjectToView.this.select(this.id);
        }
    }
}

