/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.operationalinformation;

import com.vividsolutions.jts.io.WKTReader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.List;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.transcoder.TranscoderException;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiPolygon;
import org.postgis.Polygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.police.operationalinformation.MapValueWarrant;
import ru.blok.vms.ui.police.operationalinformation.ObjectToView;
import ru.blok.vms.ui.police.operationalinformation.TaskToView;
import ru.blok.vms.ui.police.operationalinformation.WarrantToView;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.client.soap.proxy.vms.WatchAreaWSProxy;
import ru.infor.ws.objects.police.entities.PoliceWarrantUI;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;
import ru.infor.ws.objects.vms.entities.ext.WatchAreaExt;

public class PainterData<T extends JXMapViewer>
extends MapViewPainter<T> {
    private static WKTReader wr = new WKTReader();
    MapValueWarrant value;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        WarrantToView wsel = null;
        if (this.value != null) {
            for (WarrantToView w : this.value.getInformation().view.values()) {
                if (w.isSelect()) {
                    wsel = w;
                    continue;
                }
                if (w.getData() == null) continue;
                try {
                    if (w.getComponent().getParent() == null) {
                        map.add((Component)w.getComponent());
                        if (w.getData() != null && w.getData().getDirection() != null) {
                            w.setAngle(w.getData().getDirection());
                        }
                    }
                    this.paintImage(g, map, w, w.getH(), w.getW(), vp2);
                }
                catch (TranscoderException e) {
                    e.printStackTrace();
                }
            }
        }
        if (wsel != null) {
            if (wsel.getData() != null) {
                try {
                    if (wsel.getComponent().getParent() == null) {
                        map.add((Component)wsel.getComponent());
                        if (wsel.getData() != null && wsel.getData().getDirection() != null) {
                            wsel.setAngle(wsel.getData().getDirection());
                        }
                    }
                    if (wsel.getComponentH().getParent() == null) {
                        map.add((Component)wsel.getComponentH());
                    }
                    this.paintImage(g, map, wsel, wsel.getH(), wsel.getW(), vp2);
                    this.paintTasks(g, map, vp2, wsel);
                }
                catch (TranscoderException e) {
                    e.printStackTrace();
                }
            }
            List<RouteExt> lr = wsel.information.transportRoutes.get(((PoliceWarrantUI)wsel.getObject()).getTransportId());
            List<WatchAreaExt> lw = wsel.information.transportZones.get(((PoliceWarrantUI)wsel.getObject()).getTransportId());
            RouteWSProxy routeWSProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class, (String)this.value.information.getKeyPage());
            if (lr != null) {
                for (RouteExt routeExt : lr) {
                    if (routeExt.getRouteGeom() == null) {
                        Route r2 = routeWSProxy.getCurrentObject(InitializedVariable.getContext((String)this.value.information.getKeyPage()), routeExt.getId());
                        routeExt.setRouteGeom(r2.getRouteGeom());
                        routeExt.setAreaRouteGeom(r2.getAreaRouteGeom());
                    }
                    if (routeExt != null && routeExt.getAreaRouteGeom() != null && routeExt.getCurrentPolygon() == null) {
                        try {
                            Object currentPolygon = null;
                            currentPolygon = routeExt.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(routeExt.getAreaRouteGeom()) : new Polygon(routeExt.getAreaRouteGeom());
                            routeExt.setCurrentPolygon((Geometry)currentPolygon);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    RoutePainter.paintPolygon(routeExt.getCurrentPolygon(), map, g, (Rectangle2D)vp2, Color.RED, 50);
                }
            }
            if (lw != null) {
                for (WatchAreaExt watchAreaExt : lw) {
                    PainterData.checkGeom(watchAreaExt, this.value.information.getKeyPage());
                    RoutePainter.paintPolygon(watchAreaExt.getCurrentPolygon(), map, g, (Rectangle2D)vp2, watchAreaExt.getColor() == null ? Color.GREEN : new Color(watchAreaExt.getColor()), watchAreaExt.getTransparency() == null ? 50 : watchAreaExt.getTransparency());
                }
            }
        }
    }

    public static void checkGeom(WatchAreaExt r, String keyPage) {
        if (r.getAreageom() == null) {
            WatchAreaWSProxy watchAreaWSProxy = (WatchAreaWSProxy)CurrentProxyFactory.getProxy(WatchAreaExt.class, (String)keyPage);
            WatchAreaExt r2 = (WatchAreaExt)watchAreaWSProxy.getCurrentObject(InitializedVariable.getContext((String)keyPage), r.getId());
            r.setAreageom(r2.getAreageom());
        }
        if (r != null && r.getAreageom() != null && r.getCurrentPolygon() == null) {
            try {
                Object currentPolygon = null;
                currentPolygon = r.getAreageom().contains("MULTIPOLYGON") ? new MultiPolygon(r.getAreageom()) : new Polygon(r.getAreageom());
                r.setCurrentPolygon((Geometry)currentPolygon);
                com.vividsolutions.jts.geom.Geometry jtsp = wr.read(String.valueOf(r.getCurrentPolygon().getTypeString()) + r.getCurrentPolygon().getValue());
                r.setJtsp(jtsp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void paintImage(Graphics2D g, T map, ObjectToView wv, int h, int w, Rectangle2D vp2) throws TranscoderException {
        GeoPosition gp = wv.getGeoposition();
        Point2D point = map.getTileFactory().geoToPixel(gp, map.getZoom());
        int x = (int)(point.getX() - vp2.getX());
        int y = (int)(point.getY() - vp2.getY());
        JSVGCanvas canvas = (JSVGCanvas)wv.getComponent();
        Dimension2D d = canvas.getSVGDocumentSize();
        if (d == null) {
            d = canvas.getSize();
        }
        wv.resize();
        Point pt = new Point(x - (int)d.getWidth() / 2, y - (int)d.getHeight() / 2);
        canvas.setLocation(pt);
        if (wv.getComponentH() != null) {
            JSVGCanvas canvas2 = (JSVGCanvas)wv.getComponentH();
            if (wv.isSelect()) {
                wv.resize2();
                pt = new Point(x - wv.getComponent().getWidth() / 2, y - wv.getComponentH().getHeight() + wv.getComponent().getHeight() / 2);
                canvas2.setLocation(pt);
                canvas2.setVisible(true);
            } else {
                canvas2.setVisible(false);
            }
        }
    }

    public void paintTasks(Graphics2D g, T map, Rectangle2D vp2, ObjectToView<?> o) {
        TaskToView v;
        WarrantToView w = (WarrantToView)o;
        if (w.isSelect() && ((PoliceWarrantUI)w.getObject()).getCurentTaskId() != null && (v = this.value.information.viewT.get(((PoliceWarrantUI)w.getObject()).getCurentTaskId())) != null) {
            GeoPosition f = w.getGeoposition();
            GeoPosition t = v.getGeoposition();
            this.paintGP(g, map, vp2, f, t, w);
        }
    }

    public void paintLine(Graphics2D g, T map, Rectangle2D vp2, GeoPosition from, GeoPosition to) {
        Color c = Color.BLUE;
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 100));
        g.setStroke(new BasicStroke(10.0f, 1, 1));
        Point2D pointf = map.getTileFactory().geoToPixel(from, map.getZoom());
        Point2D pointt = map.getTileFactory().geoToPixel(to, map.getZoom());
        int xf = (int)(pointf.getX() - vp2.getX());
        int yf = (int)(pointf.getY() - vp2.getY());
        int xt = (int)(pointt.getX() - vp2.getX());
        int yt = (int)(pointt.getY() - vp2.getY());
        g.drawLine(xf, yf, xt, yt);
    }

    public void paintGP(Graphics2D g, T map, Rectangle2D vp2, GeoPosition from, GeoPosition to, WarrantToView w) {
        if (from != null && to != null) {
            if ("\u0412\u043e\u0437\u0434\u0443\u0448\u043d\u043e\u0435 \u0441\u0443\u0434\u043d\u043e".equals(((PoliceWarrantUI)w.getObject()).getTransportKind())) {
                this.paintLine(g, map, vp2, from, to);
            } else {
                NavigationPoint[] nplast = w.getLastPaths();
                for (NavigationPoint[] np : w.getPaths()) {
                    Color c;
                    int[] xPoints = new int[np.length];
                    int[] yPoints = new int[np.length];
                    int i = 0;
                    while (i < np.length) {
                        GeoPosition pt = new GeoPosition(np[i].getLat().doubleValue(), np[i].getLon().doubleValue());
                        Point2D p2 = map.getTileFactory().geoToPixel(pt, map.getZoom());
                        int xf = (int)(p2.getX() - vp2.getX());
                        int yf = (int)(p2.getY() - vp2.getY());
                        xPoints[i] = xf;
                        yPoints[i] = yf;
                        ++i;
                    }
                    if (np.equals(nplast)) {
                        c = Color.BLUE;
                        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 100));
                    } else {
                        c = Color.BLACK;
                        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 30));
                    }
                    g.setStroke(new BasicStroke(10.0f, 1, 1));
                    g.drawPolyline(xPoints, yPoints, np.length);
                }
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueWarrant)mapValueWithTrack;
    }
}

