/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.operationalinformation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.transcoder.TranscoderException;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Point;
import ru.blok.vms.ui.police.operationalinformation.PainterData;
import ru.blok.vms.ui.police.operationalinformation.PostView;

public class PainterPED<T extends JXMapViewer>
extends PainterData<T> {
    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Color w0 = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 30);
        Color w1 = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 250);
        if (this.value != null) {
            for (PostView w : this.value.getInformation().mapsIcon.values()) {
                try {
                    if (w.getGeoposition() == null) continue;
                    if (w.getComponent().getParent() == null) {
                        map.add((Component)w.getComponent());
                    }
                    if (w.isSelect() && w.getComponentH().getParent() == null) {
                        map.add((Component)w.getComponentH());
                    }
                    this.paintImage(g, map, w, w.getH(), w.getW(), vp2);
                    if (w.getListPolygon() == null) continue;
                    for (org.postgis.Polygon p : w.getListPolygon()) {
                        this.paintPolygon(p, map, g, vp2, vp3, w0, w1);
                    }
                }
                catch (TranscoderException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void paintPolygon(org.postgis.Polygon polygon, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color w, Color w1) {
        Path2D path = null;
        g.setStroke(new BasicStroke(1.0f, 1, 1));
        int ii = 0;
        while (ii < polygon.numRings()) {
            Polygon pp = new Polygon();
            int i = 0;
            while (i < polygon.getRing(ii).numPoints()) {
                Point p1 = polygon.getRing(ii).getPoint(i);
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p1.getY(), p1.getX()), map.getZoom());
                int x = (int)(point.getX() - vp2.getX());
                int y = (int)(point.getY() - vp2.getY());
                pp.addPoint(x, y);
                ++i;
            }
            if (path == null) {
                path = new GeneralPath(pp);
            } else {
                path.append(pp, true);
            }
            g.setColor(w1);
            g.drawPolygon(pp);
            ++ii;
        }
        g.setColor(w);
        g.fill(path);
    }
}

