/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.operationalinformation;

import java.util.List;
import org.apache.batik.dom.GenericText;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Polygon;
import ru.blok.vms.ui.police.operationalinformation.ObjectToView;
import ru.blok.vms.ui.police.operationalinformation.OperationalInformation;
import ru.blok.vms.ui.police.operationalinformation.WarrantToView;
import ru.infor.ws.objects.police.entities.PolicePost;
import ru.infor.ws.objects.police.entities.PoliceSubdivisionType;

public class PostView
extends ObjectToView<PolicePost> {
    String hint;
    List<Polygon> listPolygon;

    public PostView(Long id, PolicePost object, OperationalInformation information) {
        super(object.getAreaSubdivision().getId(), object, information, null);
    }

    @Override
    public void setImage(String image1) {
        image = "/iconssvg/flag.svg";
        imageH = "/iconssvg/hint3.svg";
        PolicePost p = (PolicePost)this.getObject();
        if (p.getAreaSubdivision().getId().equals(OperationalInformation.our)) {
            image = "/iconssvg/flag.svg";
        } else {
            PoliceSubdivisionType t = p.getAreaSubdivision().getType();
            if (t != null) {
                String urlStr = this.information.mapPoliceSubdType.get(t.getId()).getIconName();
                try {
                    image = WarrantToView.getFromServer(urlStr, t.getId(), this.information.getKeyPage());
                }
                catch (Exception e) {
                    image = "/iconssvg/flag.svg";
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void initIcon() {
    }

    @Override
    public void initangle() {
    }

    @Override
    public void select(long id) {
        this.information.setSelectedSubd(id, null);
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.setterHint();
    }

    @Override
    public void setterHint() {
        GenericText e;
        if (this.docH != null && (e = (GenericText)this.docH.getElementById("text").getFirstChild()) != null) {
            e.setNodeValue(this.hint);
        }
    }

    @Override
    public GeoPosition getGeoposition() {
        if (((PolicePost)this.object).getPoint() != null) {
            GeoPosition gp = new GeoPosition(((PolicePost)this.object).getPoint().getPrLat().doubleValue(), ((PolicePost)this.object).getPoint().getPrLon().doubleValue());
            return gp;
        }
        return null;
    }

    public List<Polygon> getListPolygon() {
        return this.listPolygon;
    }

    public void setListPolygon(List<Polygon> listPolygon) {
        this.listPolygon = listPolygon;
    }
}

