/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.operationalinformation;

import com.google.gson.Gson;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.geotools.referencing.GeodeticCalculator;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.common.client.application.MainFrame;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.tracks.json.LoaderFromInternet;
import ru.infor.client.ServicesConnection;
import ru.infor.client.soap.proxy.cartography.RouteRulesSetWSProxy;
import ru.infor.client.soap.proxy.cartography.TransportTypesRWSProxy;
import ru.infor.common.FileUtils;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.cartography.CalculateRouteParams;
import ru.infor.ws.objects.cartography.GPSPoint;
import ru.infor.ws.objects.cartography.PathElement;
import ru.infor.ws.objects.cartography.entities.RouteRulesSet;
import ru.infor.ws.objects.cartography.entities.TransportTypesR;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.RouteNavigationParam;
import ru.infor.ws.objects.vms.entities.NDData;

public class Routes
extends CommonObjectWithKey {
    static String urlRoutes;
    private static Gson gson;
    static boolean innerRoute;
    static String transportType4CalcPathKey;
    static HashMap<String, NavigationPoint[]> cache;
    private static Long fitnessID;
    private static GeometryFactory gf;
    private static GeodeticCalculator gc;
    static NavigationPoint[] defaultNP;
    static HashMap<String, String> sp;

    static {
        String s;
        urlRoutes = "";
        gson = new Gson();
        innerRoute = false;
        transportType4CalcPathKey = null;
        urlRoutes = SysProperties.getProperty((String)"routes.url", (String)"");
        HashMap sp = null;
        sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)MainFrame.keyPage));
        if (sp.get("InnerRoute") != null && ("1".equals(s = (String)sp.get("InnerRoute")) || "true".equals(s))) {
            innerRoute = true;
        }
        if (sp.get("TransportType4CalcPathKey") != null) {
            transportType4CalcPathKey = (String)sp.get("TransportType4CalcPathKey");
        }
        cache = new HashMap();
        fitnessID = 1L;
        gf = new GeometryFactory();
        gc = new GeodeticCalculator();
        defaultNP = new NavigationPoint[0];
        Routes.sp = null;
    }

    public Routes(String keyPage) {
        super(keyPage);
    }

    public static void removeFromCache(final NDData d) {
        if (d != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String key = "" + d.getLat() + d.getLon();
                        for (String k : cache.keySet()) {
                            if (!k.startsWith(key)) continue;
                            cache.remove(k);
                        }
                    }
                    catch (Exception exception) {}
                }
            }).start();
        }
    }

    private static LineString np2geometry(NavigationPoint[] np) {
        return gf.createLineString(Arrays.stream(np).map(p -> new Coordinate(p.getLon().doubleValue(), p.getLat().doubleValue())).collect(Collectors.toList()).toArray(new Coordinate[np.length]));
    }

    private static LineString cutLine(Coordinate pt, LineString l) {
        Coordinate point;
        LocationIndexedLine g1;
        block3: {
            g1 = new LocationIndexedLine((com.vividsolutions.jts.geom.Geometry)l);
            LinearLocation here = g1.project(pt);
            point = g1.extractPoint(here);
            try {
                gc.setStartingGeographicPoint(pt.x, pt.y);
                gc.setDestinationGeographicPoint(point.x, point.y);
                double dist = gc.getOrthodromicDistance();
                if (!(dist > 200.0)) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        LineString ls = (LineString)g1.extractLine(g1.getEndIndex(), g1.indexOf(point));
        return ls;
    }

    public static void calcPath(NavigationPoint[] oldPath, GeoPosition from, GeoPosition to, Consumer<NavigationPoint[]> npc) {
        CompletableFuture<NavigationPoint[]> cfp = CompletableFuture.supplyAsync(() -> {
            LineString np = null;
            if (oldPath != null && oldPath.length >= 2) {
                np = Routes.cutLine(new Coordinate(from.getLongitude(), from.getLatitude()), Routes.np2geometry(oldPath));
            }
            if (np == null) {
                return Routes.caclPath(from, to);
            }
            NavigationPoint[] points = new NavigationPoint[np.getNumPoints()];
            int i = 0;
            while (i < np.getNumPoints()) {
                points[i] = new NavigationPoint();
                Coordinate c = np.getCoordinateN(np.getNumPoints() - i - 1);
                points[i].setLon(Double.valueOf(c.x));
                points[i].setLat(Double.valueOf(c.y));
                ++i;
            }
            return points;
        });
        cfp.thenAccept(it -> npc.accept((NavigationPoint[])it));
        Runnable task = () -> {
            try {
                cfp.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        };
        new Thread(task).start();
    }

    public static NavigationPoint[] caclPath(GeoPosition from, GeoPosition to) {
        return Routes.caclPath(from, to, innerRoute, transportType4CalcPathKey);
    }

    public static NavigationPoint[] caclPath(GeoPosition from, GeoPosition to, boolean innerRoute, String key4path) {
        StringBuilder kb = new StringBuilder().append(from.getLatitude()).append(from.getLongitude()).append(to.getLatitude()).append(to.getLongitude());
        String key = kb.toString();
        NavigationPoint[] points = cache.get(key);
        if (points != null) {
            return points;
        }
        cache.put(key, defaultNP);
        points = "".equals(urlRoutes) ? (innerRoute ? Routes.caclPath_inner(from, to, key4path) : Routes.caclPath_old(from, to)) : Routes.caclPath_new(from, to);
        cache.put(key, points);
        return points;
    }

    private static NavigationPoint[] caclPath_new(GeoPosition from, GeoPosition to) {
        try {
            StringBuilder urls = new StringBuilder(urlRoutes).append("rest/routing/route/?coord=").append(from.getLatitude()).append("%2C").append(from.getLongitude()).append("%2C").append(to.getLatitude()).append("%2C").append(to.getLongitude()).append("&time=0&types=2");
            URL url = new URL(urls.toString());
            HttpURLConnection conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            InputStream input = conn.getInputStream();
            byte[] resp = FileUtils.readFileToBytes((InputStream)input);
            String r1 = new String(resp);
            ResultRoute ret = (ResultRoute)gson.fromJson(r1, ResultRoute.class);
            ArrayList<NavigationPoint> pp = new ArrayList<NavigationPoint>();
            int i = 0;
            while (i < ret.getSegments().size()) {
                Double[][] dd = ret.getSegments().get(i).getLine().getGeometry().getCoordinates();
                int k = 0;
                while (k < dd.length) {
                    Double[] d = dd[k];
                    NavigationPoint p = new NavigationPoint();
                    p.setLat(d[1]);
                    p.setLon(d[0]);
                    pp.add(p);
                    ++k;
                }
                ++i;
            }
            return pp.toArray(new NavigationPoint[pp.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static NavigationPoint[] caclPath_old(GeoPosition from, GeoPosition to) {
        try {
            NavigationPoint from0 = new NavigationPoint();
            from0.setLat(Double.valueOf(from.getLatitude()));
            from0.setLon(Double.valueOf(from.getLongitude()));
            NavigationPoint to0 = new NavigationPoint();
            to0.setLat(Double.valueOf(to.getLatitude()));
            to0.setLon(Double.valueOf(to.getLongitude()));
            RouteNavigationParam param = new RouteNavigationParam();
            param.setFrom(from0);
            param.setTo(to0);
            param.setFintessID(fitnessID);
            NavigationPoint[] points = LoaderFromInternet.getRoute(InitializedVariable.context, param, LoaderFromInternet.MapQuest_API_KEY);
            return points;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static NavigationPoint[] caclPath_inner(GeoPosition from, GeoPosition to, String key4path) {
        try {
            sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)MainFrame.keyPage));
            InvocationContext contextCart = InitializedVariable.checkCreateInvocationContext((String)sp.get("cart.user.name"), (String)sp.get("cart.user.password"), (ServicesConnection)ServicesConnection.getConnection((String)"cartography-ws"));
            GPSPoint from0 = new GPSPoint();
            from0.setLat(Double.valueOf(from.getLatitude()));
            from0.setLon(Double.valueOf(from.getLongitude()));
            GPSPoint to0 = new GPSPoint();
            to0.setLat(Double.valueOf(to.getLatitude()));
            to0.setLon(Double.valueOf(to.getLongitude()));
            RouteRulesSetWSProxy proxy = (RouteRulesSetWSProxy)CurrentProxyFactory.getProxy(RouteRulesSet.class);
            CalculateRouteParams p = new CalculateRouteParams();
            p.setFrom(from0);
            p.setTo(to0);
            TransportTypesRWSProxy proxy2 = (TransportTypesRWSProxy)CurrentProxyFactory.getProxy(TransportTypesR.class);
            TransportTypesR[] tt = proxy2.getTransportTypes(contextCart);
            Long idType = 1L;
            int i = 0;
            while (i < tt.length) {
                String curKey = (tt[i].getName() == null ? "" : tt[i].getName().trim()).concat("##").concat(tt[i].getSubname() == null ? "" : tt[i].getSubname().trim());
                if (curKey.equalsIgnoreCase(key4path)) {
                    idType = tt[i].getId();
                    break;
                }
                ++i;
            }
            p.setTransportTypeIDs(new Long[]{idType});
            PathElement[] pp = proxy.calcRoute(contextCart, p);
            NavigationPoint[] points = new NavigationPoint[pp.length];
            int j = 0;
            while (j < pp.length) {
                NavigationPoint np = new NavigationPoint();
                np.setFitness(pp[j].getWeight());
                np.setLat(Double.valueOf(pp[j].getNode().getLat()));
                np.setLon(Double.valueOf(pp[j].getNode().getLon()));
                points[j] = np;
                ++j;
            }
            return points;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Geometry {
        Double[][] coordinates;

        public Double[][] getCoordinates() {
            return this.coordinates;
        }

        public void setCoordinates(Double[][] coordinates) {
            this.coordinates = coordinates;
        }
    }

    public static class Line {
        Geometry geometry;

        public Geometry getGeometry() {
            return this.geometry;
        }

        public void setGeometry(Geometry geometry) {
            this.geometry = geometry;
        }
    }

    public static class ResultRoute {
        List<Segment> segments;

        public List<Segment> getSegments() {
            return this.segments;
        }

        public void setSegments(List<Segment> segments) {
            this.segments = segments;
        }
    }

    public static class Segment {
        Line line;

        public Line getLine() {
            return this.line;
        }

        public void setLine(Line line) {
            this.line = line;
        }
    }
}

