/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.operationalinformation;

import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.batik.dom.GenericText;
import org.apache.log4j.Logger;
import org.jxmapviewer.viewer.GeoPosition;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.configprop.ConfigProp;
import ru.blok.common.ui.configprop.ConfigProperties;
import ru.blok.vms.ui.police.operationalinformation.ObjectToView;
import ru.blok.vms.ui.police.operationalinformation.OperationalInformation;
import ru.infor.common.FileUtils;
import ru.infor.ws.objects.events.EventUI;
import ru.infor.ws.objects.police.entities.PoliceWarrantKind;
import ru.infor.ws.objects.police.entities.PoliceWarrantUI;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.entities.NDData;

public class WarrantToView
extends ObjectToView<PoliceWarrantUI> {
    static String image2 = "/iconssvg/wd.svg";
    String urlIcon = null;
    private Date datedata;
    NDData data;
    static Integer defaultFill = -16704308;
    static Integer defaultFillAv = -16704308;
    static Integer defaultRim = -16707462;
    static Integer defaultLabel = -1;
    static Integer defaultLabelAv = -16777216;
    HashMap<Long, NavigationPoint[]> paths = new HashMap();
    List<Long> sort = new ArrayList<Long>();
    private List<EventUI> list = new ArrayList<EventUI>();

    public WarrantToView(Long id, PoliceWarrantUI object, OperationalInformation information) {
        super(id, object, information, null);
    }

    public Date getDatedata() {
        return this.datedata;
    }

    public void setDatedata(Date datedata) {
        this.datedata = datedata;
    }

    public static String getFromServer(String urlStr, Long id, String keyPage) throws Exception {
        URL url = new URL(urlStr);
        Logger.getLogger(ObjectToView.class).debug((Object)("load url " + urlStr));
        if (url.getAuthority() == null) {
            String namec = String.valueOf(keyPage.equals("") ? InitializedVariable.appShortName : keyPage.toLowerCase()) + ".soap.services.url";
            ConfigProp cp1 = ConfigProperties.getInstance().getListProp().stream().filter(cp -> cp.getName().equals(namec)).findFirst().get();
            URL t = new URL(cp1.getValue());
            String newurl = String.valueOf(t.getProtocol()) + "://" + t.getHost() + ":" + t.getPort() + url.getPath() + "?" + url.getQuery();
            url = new URL(newurl);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url, (String)keyPage);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
        }
        catch (Exception e) {
            Logger.getLogger(ObjectToView.class).error((Object)("error load url " + urlStr));
            e.printStackTrace();
        }
        String typeS = "iconssvg/" + Long.toString(id);
        File file = svgPrefix.equals("") ? new File(ObjectToView.class.getResource(String.valueOf(prefix) + typeS).getFile()) : new File(String.valueOf(svgPrefix) + typeS);
        InputStream input = conn.getInputStream();
        FileUtils.copy((InputStream)input, (File)file);
        return typeS;
    }

    @Override
    public void setImage(String image1) {
        PoliceWarrantUI w = (PoliceWarrantUI)this.getObject();
        Long type = w.getTransportKindId();
        Long func = w.getFunctionalServicesId();
        if (func != null) {
            this.urlIcon = this.information.mapFunctionalServices.get(func).getNameIcon();
        }
        if (type != null) {
            String urlStr = this.information.mapKind.get(type).getName();
            try {
                image = WarrantToView.getFromServer(urlStr, type, this.information.getKeyPage());
            }
            catch (Exception e) {
                image = "/iconssvg/wd.svg";
                e.printStackTrace();
            }
        } else {
            image = "/iconssvg/wd.svg";
        }
        imageH = "/iconssvg/hint.svg";
    }

    @Override
    public void initIcon() {
        WarrantToView.initIcon(((PoliceWarrantUI)this.getObject()).getPostWarrantKind(), (PoliceWarrantUI)this.getObject(), this.doc, this.urlIcon);
    }

    @Override
    public void initangle() {
        if (this.data != null && this.data.getDirection() != null) {
            this.setAngle(this.data.getDirection());
        }
    }

    @Override
    public void select(long id) {
        this.information.setSelected(id, null);
    }

    public void setAngle(final double angle) {
        try {
            if (this.queue != null) {
                this.queue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Element gar = WarrantToView.this.doc.getElementById("gMainGroup");
                        gar.setAttribute("transform", "rotate(" + angle + ",17.5,17.5)");
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NDData getData() {
        return this.data;
    }

    public void setData(NDData data) {
        this.data = data;
        if (data != null && data.getDirection() != null) {
            this.setAngle(data.getDirection());
        }
        this.setterHint();
    }

    public static void initIcon(PoliceWarrantKind kind, PoliceWarrantUI w, SVGDocument doc, String urlIcon) {
        WarrantToView.initIcon(kind, w, doc, urlIcon, true);
    }

    public static void initIcon(PoliceWarrantKind kind, PoliceWarrantUI w, SVGDocument doc, String urlIcon, boolean op) {
        Element e = doc.getElementById("pathchange");
        if (w != null) {
            WarrantToView.changeColorFill(w.getStatusTSColor() == null ? defaultFill : w.getStatusTSColor(), e, 1.0);
            WarrantToView.changeColorLine(w.getStatusTSColor() == null ? defaultRim.intValue() : new Color(w.getStatusTSColor()).brighter().brighter().getRGB(), e);
        }
        if (urlIcon != null) {
            Element e1 = doc.getElementById("imageG");
            e1.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", urlIcon);
            if (op) {
                WarrantToView.setopacity1(e1, true);
            }
        }
    }

    @Override
    public void setterHint() {
        try {
            if (this.queue2 != null) {
                this.queue2.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (WarrantToView.this.docH != null) {
                            String s;
                            GenericText e = (GenericText)WarrantToView.this.docH.getElementById("num").getFirstChild();
                            if (e != null) {
                                e.setNodeValue(((PoliceWarrantUI)WarrantToView.this.getObject()).getNum());
                            }
                            if ((e = (GenericText)WarrantToView.this.docH.getElementById("callsign").getFirstChild()) != null) {
                                e.setNodeValue(((PoliceWarrantUI)WarrantToView.this.getObject()).getCallsign());
                            }
                            if ((e = (GenericText)WarrantToView.this.docH.getElementById("speed").getFirstChild()) != null) {
                                s = "";
                                if (WarrantToView.this.getData() != null && WarrantToView.this.getData().getSpeed() != null) {
                                    s = String.valueOf(WarrantToView.this.defs.format(WarrantToView.this.getData().getSpeed())) + " \u043a\u043c/\u0447";
                                }
                                if ("\u0412\u043e\u0437\u0434\u0443\u0448\u043d\u043e\u0435 \u0441\u0443\u0434\u043d\u043e".equals(((PoliceWarrantUI)WarrantToView.this.getObject()).getTransportKind())) {
                                    Integer n = ((PoliceWarrantUI)WarrantToView.this.getObject()).getNumber4Height();
                                    Double h = null;
                                    if (n != null) {
                                        switch (n) {
                                            case 0: {
                                                h = WarrantToView.this.getData().getAe0();
                                                break;
                                            }
                                            case 1: {
                                                h = WarrantToView.this.getData().getAe1();
                                                break;
                                            }
                                            case 2: {
                                                h = WarrantToView.this.getData().getAe2();
                                                break;
                                            }
                                            case 3: {
                                                h = WarrantToView.this.getData().getAe3();
                                                break;
                                            }
                                            case 4: {
                                                h = WarrantToView.this.getData().getAe4();
                                                break;
                                            }
                                            case 5: {
                                                h = WarrantToView.this.getData().getAe5();
                                                break;
                                            }
                                            case 6: {
                                                h = WarrantToView.this.getData().getAe6();
                                                break;
                                            }
                                            case 7: {
                                                h = WarrantToView.this.getData().getAe7();
                                                break;
                                            }
                                            case 8: {
                                                h = WarrantToView.this.getData().getAe8();
                                                break;
                                            }
                                            case 9: {
                                                h = WarrantToView.this.getData().getAe9();
                                            }
                                        }
                                    }
                                    s = h != null ? String.valueOf(s) + "   \u2191 " + h + " \u043c" : String.valueOf(s) + "   \u2191 --";
                                }
                                e.setNodeValue(s);
                            }
                            if ((e = (GenericText)WarrantToView.this.docH.getElementById("task").getFirstChild()) != null) {
                                s = "";
                                if (WarrantToView.this.getObject() != null && ((PoliceWarrantUI)WarrantToView.this.getObject()).getCurentTaskTypeDescription() != null) {
                                    s = ((PoliceWarrantUI)WarrantToView.this.getObject()).getCurentTaskTypeDescription();
                                }
                                e.setNodeValue(s);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public GeoPosition getGeoposition() {
        if (this.data == null) {
            return null;
        }
        GeoPosition gp = new GeoPosition(this.getData().getLat().doubleValue(), this.getData().getLon().doubleValue());
        return gp;
    }

    public NavigationPoint[] getLastPaths() {
        if (this.paths.size() == 0) {
            return null;
        }
        return this.paths.get(this.sort.get(this.sort.size() - 1));
    }

    public List<NavigationPoint[]> getPaths() {
        ArrayList<NavigationPoint[]> res = new ArrayList<NavigationPoint[]>();
        for (Long l : this.sort) {
            res.add(this.paths.get(l));
        }
        return res;
    }

    public void addNewPath(NavigationPoint[] path, Long id) {
        this.paths.put(id, path);
        this.sort = new ArrayList<Long>(this.paths.keySet());
        Collections.sort(this.sort);
    }

    public void updatePath(NavigationPoint[] path) {
        if (path == null) {
            this.paths.clear();
            this.sort.clear();
        } else if (this.paths.size() > 0) {
            this.paths.put(this.sort.get(this.sort.size() - 1), path);
        } else {
            this.addNewPath(path, -1L);
        }
    }

    public List<EventUI> getList() {
        return this.list;
    }

    public void setList(List<EventUI> list) {
        this.list = list;
    }
}

