/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.policetasks.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class Flag2Painter<T extends JXMapViewer>
extends MapViewPainter<T> {
    private GeoPosition point = null;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.point != null) {
            int y;
            int x;
            Point2D point = map.getTileFactory().geoToPixel(this.point, map.getZoom());
            if (vp2.contains(point)) {
                x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                g.translate(x, y);
                this.paintNode(g, (JXMapViewer)map);
                g.translate(-x, -y);
            }
            if (vp3.contains(point)) {
                x = (int)(point.getX() - ((RectangularShape)vp3).getX());
                y = (int)(point.getY() - ((RectangularShape)vp3).getY());
                g.translate(x, y);
                this.paintNode(g, (JXMapViewer)map);
                g.translate(-x, -y);
            }
        }
    }

    public GeoPosition getPoint() {
        return this.point;
    }

    public void setPoint(GeoPosition point) {
        this.point = point;
    }

    public boolean paintNode(Graphics2D g, JXMapViewer ma) {
        g.setColor(Color.BLACK);
        g.drawOval(-5, -5, 10, 10);
        g.setColor(Color.RED);
        g.fillOval(-5, -5, 10, 10);
        return false;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

