/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.policetasks.map;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.police.policetasks.map.Flag2Painter;
import ru.blok.vms.ui.police.policetasks.map.MapValueTask;
import ru.blok.vms.ui.police.svg.IconOnMap;
import ru.blok.vms.ui.police.svg.SVGPainter;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.BuildingWSProxy;
import ru.infor.ws.objects.police.entities.ext.PoliceTaskExt;
import ru.infor.ws.objects.vms.AdressNearPointParam;
import ru.infor.ws.objects.vms.AdvancedSearchItem;
import ru.infor.ws.objects.vms.NearestAddress;
import ru.infor.ws.objects.vms.entities.Building;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    static String incident = "/iconssvg/star8.svg";
    Flag2Painter flagPainter;
    SVGPainter iconPainter;
    BuildingWSProxy proxy = (BuildingWSProxy)CurrentProxyFactory.getProxy(Building.class);
    MapValueTask value;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.flagPainter = new Flag2Painter();
        this.painter.addPainter(this.flagPainter);
        this.iconPainter = new SVGPainter();
        this.painter.addPainter(this.iconPainter);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapViewer.this.mouseClickedOnMap(e);
            }
        });
    }

    public void setPropertyUI(String key, String value) {
        if ("icon".equals(key)) {
            incident = "/iconssvg/" + value;
        } else {
            super.setPropertyUI(key, value);
        }
    }

    @Override
    protected void mouseMovedN(MouseEvent e) {
    }

    @Override
    protected void mouseWheelMovedN(MouseWheelEvent e) {
    }

    public void updateBuilding(GeoPosition gp) {
        AdressNearPointParam p = new AdressNearPointParam();
        p.setLat(Double.valueOf(gp.getLatitude()));
        p.setLon(Double.valueOf(gp.getLongitude()));
        p.setLimit(Integer.valueOf(1));
        NearestAddress[] ad = this.proxy.getListNearAdress(InitializedVariable.context, p);
        PoliceTaskExt e = (PoliceTaskExt)((Object)((PanelContext)this.getViewerContext().getParentContext()).getPanel().getObject());
        if (ad != null && ad.length > 0) {
            AdvancedSearchItem asItem = new AdvancedSearchItem();
            asItem.setId(ad[0].getBuildingId());
            asItem.setType("building");
            asItem.setValue(ad[0].getAddress());
            e.setAdvancedSearchItem(asItem);
        } else {
            e.setAdvancedSearchItem(null);
        }
        ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("advancedSearchItem");
    }

    public void setFlag(GeoPosition gp) {
        this.flagPainter.setPoint(gp);
        this.repaint();
    }

    public GeoPosition setIncident() {
        if (this.flagPainter.getPoint() != null) {
            IconOnMap m = new IconOnMap(incident, this.flagPainter.getPoint(), 30, 30, null, null);
            this.iconPainter.getListIcons().clear();
            this.iconPainter.addIconOnMap(m);
            this.flagPainter.setPoint(null);
            m.changeColor(this.value.getColor());
            this.repaint();
            return m.getPoint();
        }
        this.iconPainter.getListIcons().clear();
        this.repaint();
        return null;
    }

    protected void mouseClickedOnMap(MouseEvent e) {
        if (e.getClickCount() == 1) {
            double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
            GeoPosition gp = this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(x, y), this.map.getMainMap().getZoom());
            this.setFlag(gp);
            this.updateBuilding(gp);
        }
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.flagPainter != null && this.flagPainter.getPoint() != null) {
            GeoPosition d = this.flagPainter.getPoint();
            if (minLat == null || d.getLatitude() < minLat) {
                minLat = d.getLatitude();
            }
            if (maxLat == null || d.getLatitude() > maxLat) {
                maxLat = d.getLatitude();
            }
            if (minLon == null || d.getLongitude() < minLon) {
                minLon = d.getLongitude();
            }
            if (maxLon == null || d.getLongitude() > maxLon) {
                maxLon = d.getLongitude();
            }
        }
        if (this.iconPainter != null && this.iconPainter.getListIcons() != null) {
            for (IconOnMap p : this.iconPainter.getListIcons()) {
                GeoPosition d = p.getPoint();
                if (minLat == null || d.getLatitude() < minLat) {
                    minLat = d.getLatitude();
                }
                if (maxLat == null || d.getLatitude() > maxLat) {
                    maxLat = d.getLatitude();
                }
                if (minLon == null || d.getLongitude() < minLon) {
                    minLon = d.getLongitude();
                }
                if (maxLon != null && !(d.getLongitude() > maxLon)) continue;
                maxLon = d.getLongitude();
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            ((MapValueTask)value).mapViewer = this;
        }
        super.setValue(value);
        this.value = (MapValueTask)value;
        if (this.value != null && this.value.getIncident() != null) {
            IconOnMap m = new IconOnMap(incident, this.value.getIncident(), 30, 30, null, null);
            m.changeColor(this.value.getColor());
            this.iconPainter.getListIcons().clear();
            this.iconPainter.addIconOnMap(m);
        }
        this.zoomToTracks();
    }

    public void changeColor(Integer color) {
        for (IconOnMap o : this.iconPainter.getListIcons()) {
            o.changeColor(color);
        }
        this.repaint();
    }
}

