/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.radiobeacon;

import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import ru.blok.vms.ui.police.radiobeacon.MapValueRadio;
import ru.blok.vms.ui.police.radiobeacon.PainterSignals;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.events.ext.EventUIExt;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    PainterSignals<JXMapViewer> painterData;
    MapValueRadio value;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.map.getMiniMap().setVisible(false);
        this.painterData = new PainterSignals();
        this.painter.addPainter(this.painterData);
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.value != null && this.value.getSignals().getSelectEvents() != null) {
            for (Object o : this.value.getSignals().getSelectEvents()) {
                EventUIExt w = (EventUIExt)((Object)o);
                if (w.getRadius() == null) {
                    PainterSignals.setPolygon(w, this.value.getSignals().getRadius());
                }
                if (w.getMinLat() == null) continue;
                if (minLat == null || w.getMinLat() < minLat) {
                    minLat = w.getMinLat();
                }
                if (maxLat == null || w.getMaxLat() > maxLat) {
                    maxLat = w.getMaxLat();
                }
                if (minLon == null || w.getMinLon() < minLon) {
                    minLon = w.getMinLon();
                }
                if (maxLon != null && !(w.getMaxLon() > maxLon)) continue;
                maxLon = w.getMaxLon();
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            ((MapValueRadio)value).mapViewer = this;
        }
        this.value = (MapValueRadio)value;
        super.setValue(this.value);
        this.painterData.setValue(this.value);
        this.zoomToTracks();
    }
}

