/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.radiobeacon;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.postgis.Point;
import ru.blok.vms.ui.geo.GeoUtils;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.police.radiobeacon.MapValueRadio;
import ru.infor.ws.objects.events.ext.EventUIExt;
import ru.infor.ws.objects.vms.entities.NDData;

public class PainterSignals<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValueRadio value;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.value != null && this.value.getSignals().getSelectEvents() != null) {
            for (Object o : this.value.getSignals().getSelectEvents()) {
                EventUIExt w = (EventUIExt)((Object)o);
                this.paintSignal(w, (JXMapViewer)map, g, vp2, vp3, Color.RED, 50, this.value.getSignals().getRadius());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolygon(EventUIExt e, int r) {
        EventUIExt eventUIExt = e;
        synchronized (eventUIExt) {
            if (e.getRadius() != null && e.getRadius().equals(r)) {
                return;
            }
            NDData d = e.getNddata();
            if (d == null) {
                return;
            }
            e.setRadius(r);
            GeometryFactory f = new GeometryFactory();
            org.postgis.Polygon p3 = null;
            try {
                CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)GeoUtils.wkt4326);
                CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)GeoUtils.wkt3395);
                MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
                GeneralDirectPosition pt1 = new GeneralDirectPosition(d.getLon().doubleValue(), d.getLat().doubleValue());
                DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                Coordinate c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                com.vividsolutions.jts.geom.Point pp = f.createPoint(c);
                Geometry buffer = pp.buffer((double)r);
                MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
                if (buffer instanceof Polygon) {
                    Polygon p = (Polygon)buffer;
                    Coordinate[] cc1 = new Coordinate[p.getCoordinates().length];
                    int i = 0;
                    while (i < p.getCoordinates().length) {
                        c = p.getCoordinates()[i];
                        pt1 = new GeneralDirectPosition(c.x, c.y);
                        pt2 = math2.transform((DirectPosition)pt1, null);
                        cc1[i] = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                        if (e.getMaxLat() == null || e.getMaxLat() < cc1[i].y) {
                            e.setMaxLat(cc1[i].y);
                        }
                        if (e.getMinLat() == null || e.getMinLat() > cc1[i].y) {
                            e.setMinLat(cc1[i].y);
                        }
                        if (e.getMinLon() == null || e.getMinLon() > cc1[i].x) {
                            e.setMinLon(cc1[i].x);
                        }
                        if (e.getMaxLon() == null || e.getMaxLon() < cc1[i].x) {
                            e.setMaxLon(cc1[i].x);
                        }
                        ++i;
                    }
                    Polygon p2 = f.createPolygon(f.createLinearRing(cc1), null);
                    p3 = new org.postgis.Polygon(p2.toString());
                    p3.setSrid(4326);
                    e.setPolygon(p3);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void paintSignal(EventUIExt e, JXMapViewer map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, int k, int r) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), k);
        PainterSignals.setPolygon(e, r);
        if (e.getPolygon() != null) {
            g.setColor(cc);
            java.awt.Polygon pp = new java.awt.Polygon();
            int i = 0;
            while (i < e.getPolygon().numPoints()) {
                Point p = e.getPolygon().getPoint(i);
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p.y, p.x), map.getZoom());
                pp.addPoint((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()));
                ++i;
            }
            g.fillPolygon(pp);
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueRadio)mapValueWithTrack;
    }
}

