/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.radiobeacon;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.ResourceStrings;
import ru.blok.common.ui.buttons.EditorButtonInAsyncList;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.event.ListEventsViewer;
import ru.blok.vms.ui.navigationdevice.radiobeacon.RadioBeaconList;
import ru.blok.vms.ui.police.radiobeacon.MapValueRadio;
import ru.blok.vms.ui.police.radiobeacon.MapViewer;
import ru.blok.vms.ui.police.radiobeacon.RadioBeaconMessage;
import ru.blok.vms.ui.voiting.PlayAlarm;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.EventUIWSProxy;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.client.soap.proxy.vms.NavigationDeviceUIWSProxy;
import ru.infor.common.BeanCopierGenerator;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;
import ru.infor.ws.business.vms.websocket.EventSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendEventUI;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.events.EventSearchCriteria;
import ru.infor.ws.objects.events.EventUI;
import ru.infor.ws.objects.events.ext.EventUIExt;
import ru.infor.ws.objects.vms.NavigationDeviceUI;
import ru.infor.ws.objects.vms.NavigationDeviceUISearchCriteria;
import ru.infor.ws.objects.vms.entities.NDData;

@ListView(views={@View(title="\u0421\u0438\u0433\u043d\u0430\u043b\u044b \u043e\u0442 \u0440\u0430\u0434\u0438\u043e\u0431\u0443\u0435\u0432", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class RadioBeanSignals
extends CommonObjectWithKey
implements EventSocketIntf {
    HashMap<String, String> sp = null;
    static String levelMonitoringCentre = "4";
    private Date dateFrom;
    private Date dateTill;
    private Integer radius = 5000;
    Double[] coord;
    EventUIWSProxy eventProxy = (EventUIWSProxy)CurrentProxyFactory.getProxy(EventUI.class);
    EventSearchCriteria eventSC = new EventSearchCriteria();
    NavigationDeviceUIWSProxy ndProxy = (NavigationDeviceUIWSProxy)CurrentProxyFactory.getProxy(NavigationDeviceUI.class);
    NDDataWSProxy ndDataWSProxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
    private List<EventUIExt> events;
    List<Long> initiators;
    MapValueRadio valueRadio;
    PlayAlarm playAlarm = new PlayAlarm(true);
    PanelContext pc;
    String sid;
    private Date dateLastCheck1;
    private Timer mTimer;
    List<Object> selectEvents = null;
    BeanViewerAction<ViewerContext> filter = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            RadioBeanSignals.this.events = new ArrayList();
            RadioBeanSignals.this.eventSC.setEventDateFrom(RadioBeanSignals.this.getDateFrom());
            RadioBeanSignals.this.eventSC.setEventDateTill(RadioBeanSignals.this.getDateTill());
            Object[] o1 = RadioBeanSignals.this.eventProxy.getList(InitializedVariable.context, RadioBeanSignals.this.eventSC).getObjList();
            if (o1 != null) {
                Object[] objectArray = o1;
                int n = o1.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    RadioBeanSignals.this.events.add((EventUIExt)((Object)o));
                    ++n2;
                }
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
            RadioBeanSignals.this.valueRadio.mapViewer.zoomToTracks();
        }

        public String getIcon() {
            return ResourceStrings.btFilterApply;
        }

        public String getName() {
            return "\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440";
        }
    };

    public RadioBeanSignals(String keyPage) {
        super(keyPage);
        this.setPeriod();
        this.init();
    }

    private void init() {
        int n;
        if (InitializedVariable.getWorkplaceId((String)this.getKeyPage()) != null) {
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)this.getKeyPage()));
        }
        if (this.sp.get("LevelMonitoringCentre") != null) {
            levelMonitoringCentre = this.sp.get("LevelMonitoringCentre");
        }
        if (this.sp.get("RadiusOfLocationBeacon") != null) {
            try {
                this.radius = Integer.valueOf(this.sp.get("RadiusOfLocationBeacon"));
            }
            catch (Exception exception) {
                this.radius = 5000;
            }
        }
        Long[] ndtList = RadioBeaconList.getNavigationDeviceTypeId(RadioBeaconList.getNavigationDeviceType());
        NavigationDeviceUISearchCriteria ndSc = new NavigationDeviceUISearchCriteria();
        ndSc.setDeviceTypeIdList(ndtList);
        this.initiators = new ArrayList<Long>();
        Object[] oo = this.ndProxy.getList(InitializedVariable.context, ndSc).getObjList();
        if (oo != null) {
            Object[] objectArray = oo;
            n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.initiators.add(((NavigationDeviceUI)o).getId());
                ++n2;
            }
        } else {
            this.initiators.add(-1L);
        }
        this.events = new ArrayList<EventUIExt>();
        this.eventSC = new EventSearchCriteria();
        this.eventSC.appendSorting(SortObject.getInstance((String)"eventDate", (String)SortObject.DIRECTION_DESC));
        this.eventSC.appendSorting(SortObject.getInstance((String)"importanceEvent.code", (String)SortObject.DIRECTION_ASC));
        this.eventSC.setEventDateFrom(this.getDateFrom());
        this.eventSC.setEventDateTill(this.getDateTill());
        this.eventSC.setInitiatorIdList(this.initiators.toArray(new Long[this.initiators.size()]));
        this.eventSC.setCount(Integer.valueOf(Integer.MAX_VALUE));
        Object[] o1 = this.eventProxy.getList(InitializedVariable.context, this.eventSC).getObjList();
        if (o1 != null) {
            Object[] objectArray = o1;
            int n3 = o1.length;
            n = 0;
            while (n < n3) {
                Object o = objectArray[n];
                this.events.add((EventUIExt)((Object)o));
                ++n;
            }
        }
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)this.getKeyPage()));
        this.valueRadio = new MapValueRadio(this.coord[0], this.coord[1], this.coord[2].intValue());
        this.valueRadio.setSignals(this);
        this.setDateLastCheck(new Date());
    }

    private void setPeriod() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(12, -15);
        this.dateFrom = c.getTime();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, 1);
        c.add(13, -1);
        this.dateTill = c.getTime();
    }

    public void beforeShow(PanelContext pc) {
        this.pc = pc;
        this.connected();
        this.mTimer = new Timer();
        this.mTimer.schedule((TimerTask)new TimerUpdateStateTask(this), 60000L, 60000L);
    }

    public Date getDateLastCheck() {
        return this.dateLastCheck1;
    }

    public void setDateLastCheck(Date dateLastCheck) {
        Calendar c = Calendar.getInstance();
        c.setTime(dateLastCheck);
        c.add(13, 1);
        this.dateLastCheck1 = c.getTime();
    }

    public void connected() {
        SubscribingOptions_SendEventUI options = new SubscribingOptions_SendEventUI();
        options.setContext(InitializedVariable.context);
        options.setServiceName("EventWS");
        options.setMethodName("sendEvent");
        options.setDeviceIdList(this.initiators);
        options.setSid(this.sid);
        try {
            this.sid = SocketClientFactory.subscribe((Object)((Object)this), (SubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        UnsubscribingOptions optionsU = new UnsubscribingOptions();
        optionsU.setContext(InitializedVariable.context);
        optionsU.setServiceName("EventWS");
        optionsU.setMethodName("sendEvent");
        optionsU.setSid(this.sid);
        try {
            SocketClientFactory.unsubscribe((UnsubscribingOptions)optionsU, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void beforeDestroy(PanelContext pc) {
        this.mTimer.cancel();
        this.close();
    }

    @ListField(fields={@Field(title="\u0421  ", order=10, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:m1/wrap 2, fill:0/fillx, ins 0/n/spanx, growy 0", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @ListField(fields={@Field(title="", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:0# w 105", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeFrom() {
        return this.dateFrom;
    }

    public void setTimeFrom(Date dateFrom) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateFrom());
        c2.setTime(dateFrom);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateFrom = c1.getTime();
    }

    @ListField(fields={@Field(title="\u043f\u043e ", order=30, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:m1:1/fillx, ins 0/n/span x, growy 0# w 100", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateTill() {
        return this.dateTill;
    }

    public void setDateTill(Date dateTill) {
        this.dateTill = dateTill;
    }

    @ListField(fields={@Field(title="", order=40, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:1# w 105", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeTill() {
        return this.dateTill;
    }

    public void setTimeTill(Date dateTill) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateTill());
        c2.setTime(dateTill);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateTill = c1.getTime();
    }

    @ListField(fields={@Field(title="\u0420\u0430\u0434\u0438\u0443\u0441, \u043c", order=50, propertiesLayout="Split1/h/l/0.3:m1# growy 0, growx# growy 0, growx 0")})
    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    @ListField(fields={@Field(title="\u0416\u0443\u0440\u043d\u0430\u043b \u0441\u043e\u0431\u044b\u0442\u0438\u0439", order=300, viewer={ListEventsViewer2.class}, propertiesLayout="Split1/h/l/0.3:m1#span,growy #spanx, wrap, growy 0", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=Editor.class, keyView="radiobeacon", doubleclick=true)})}, content=EventUI.class)})
    public List<EventUIExt> getEvents() {
        return this.events;
    }

    public EventUIExt editEvents(Object o) {
        return (EventUIExt)((Object)o);
    }

    public void sendEvent(List<EventUI> arg0) {
        for (EventUI e : arg0) {
            EventUIExt ee = new EventUIExt();
            BeanCopierGenerator.getInstance(EventUI.class, (boolean)false).copy((Object)e, (Object)ee, null);
            this.events.add(ee);
            this.setDateLastCheck(ee.getEventDate());
            this.runMessage(e);
        }
        this.updateEvents();
    }

    public void updateEvents() {
        int[] ii = ((ListViewer)this.pc.getPanel().getPresentatorForName("events").getViewer()).getTM().getSelectedRows();
        ((ListViewer)this.pc.getPanel().getPresentatorForName("events").getViewer()).getTM().fireTableDataChanged();
        ((ListViewer)this.pc.getPanel().getPresentatorForName("events").getViewer()).getTM().setSelectedRows(ii);
    }

    public void runMessage(EventUI eventUI) {
        Runnable task3 = () -> {
            this.playAlarm.playingAlarm();
            RadioBeaconMessage m = new RadioBeaconMessage(eventUI, this.playAlarm, levelMonitoringCentre);
            ViewerContext vc = new ViewerContext();
            InitializedVariable.factory.newWindow(m.getClass(), m.getClass(), (Object)m, vc, "", "MessageFromRadioBeacon" + eventUI.getId(), false);
        };
        new Thread(task3).start();
    }

    public List<Object> getSelectEvents() {
        return this.selectEvents;
    }

    public void setSelectEvents(List<Object> l) {
        this.selectEvents = l;
    }

    @ListField(fields={@Field(title="", order=100, propertiesLayout="Split1/h/r/0.3", viewer={MapViewer.class})})
    public MapValueRadio getValueRadio() {
        return this.valueRadio;
    }

    @ListField(fields={@Field(title="", order=60, propertiesLayout="Split1/h/l/0.3:m1# growy 0, growx, spanx# wrap, growy 0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getFilter() {
        return this.filter;
    }

    public static class Editor
    extends EditorButtonInAsyncList {
        public void actionPerformed(Object arg0) {
            List list = ((ViewerContext)this.getContext()).getPresentator().getSelectedItems();
            if (list != null && !list.isEmpty()) {
                EventUIExt ee = (EventUIExt)((Object)list.get(0));
                PlayAlarm playAlarm = new PlayAlarm(true);
                playAlarm.playingAlarm();
                RadioBeaconMessage m = new RadioBeaconMessage(ee, playAlarm, levelMonitoringCentre);
                ViewerContext vc = new ViewerContext();
                InitializedVariable.factory.newWindow(m.getClass(), m.getClass(), (Object)m, vc, "", "MessageFromRadioBeacon" + ee.getId(), false);
            }
        }
    }

    public static class ListEventsViewer2
    extends ListEventsViewer {
        public ListEventsViewer2(UIFactory factory) {
            super(factory);
        }

        @Override
        protected void actionOnSelect() {
            super.actionOnSelect();
            List l = this.getSelectedItems();
            ((RadioBeanSignals)((Object)((PanelContext)this.getViewerContext().getParentContext()).getPanel().getObject())).setSelectEvents(l);
            ((MapViewer)((PanelContext)this.getViewerContext().getParentContext()).getPanel().getPresentatorForName("valueRadio").getViewer()).zoomToTracks();
        }
    }

    static class TimerUpdateStateTask
    extends TimerTask {
        RadioBeanSignals i;

        public TimerUpdateStateTask(RadioBeanSignals i) {
            this.i = i;
        }

        @Override
        public void run() {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            if (c.getTime().getTime() - this.i.getDateLastCheck().getTime() > 120000L) {
                EventSearchCriteria eventSC = new EventSearchCriteria();
                eventSC.appendSorting(SortObject.getInstance((String)"eventDate", (String)SortObject.DIRECTION_DESC));
                eventSC.appendSorting(SortObject.getInstance((String)"importanceEvent.code", (String)SortObject.DIRECTION_ASC));
                eventSC.setEventDateFrom(this.i.getDateLastCheck());
                eventSC.setEventDateTill(c.getTime());
                eventSC.setInitiatorIdList(this.i.initiators.toArray(new Long[this.i.initiators.size()]));
                eventSC.setCount(Integer.valueOf(Integer.MAX_VALUE));
                Object[] o1 = this.i.eventProxy.getList(InitializedVariable.context, eventSC).getObjList();
                if (o1 != null) {
                    Object[] objectArray = o1;
                    int n = o1.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        this.i.events.add((EventUIExt)((Object)o));
                        this.i.setDateLastCheck(((EventUIExt)((Object)o)).getEventDate());
                        this.i.runMessage((EventUIExt)((Object)o));
                        ++n2;
                    }
                    this.i.updateEvents();
                    this.i.close();
                    this.i.connected();
                }
                this.i.setDateLastCheck(c.getTime());
            }
        }
    }
}

