/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.sdcm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ru.blok.vms.ui.Sisnet;
import ru.blok.vms.ui.police.sdcm.FastCorrectionItem;
import ru.blok.vms.ui.police.sdcm.SDCMCommon;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.ws.objects.vms.entities.DataFromSatellites;

@ListView(views={@View(title="\u0411\u044b\u0441\u0442\u0440\u044b\u0435 \u043f\u043e\u043f\u0440\u0430\u0432\u043a\u0438", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class FastCorrectionsTable
extends SDCMCommon {
    HashMap<Integer, FastCorrectionItem> map = new HashMap();
    List<FastCorrectionItem> lists;

    public FastCorrectionsTable(String keyPage) {
        super(keyPage);
    }

    @Override
    public void setFileltedLoadData() {
    }

    @Override
    protected void loadDataNeedRebuild(DataFromSatellites d, Boolean[] needRefresh) {
        this.sbsmsg.message = d.getData();
        Sisnet.decode_msgtype(this.sbsmsg, this.sbscorr, this.sbsdegr, this.sbseph, this.sbsalm, this.sbsion, this.sbstime, this.sbsserv, this.sbscov);
        int code = this.sbsmsg.message[1] >>> 2 & 0x3F;
        if (code >= 2 && code <= 5 || code == 0) {
            int j;
            if (code == 0) {
                code = 2;
            }
            if ((j = (int)(13 * (code - 2))) < this.sbscorr.getNumSat()) {
                int i = 0;
                while (i < 13 && j < this.sbscorr.getNumSat()) {
                    short prn = this.sbscorr.getPRN()[j];
                    FastCorrectionItem it = this.map.get(prn);
                    if (it == null) {
                        needRefresh[0] = true;
                        it = new FastCorrectionItem();
                        it.setPrn(Integer.valueOf(prn));
                        if (prn > 0) {
                            this.map.put(Integer.valueOf(prn), it);
                        }
                    }
                    if (it.getDate() == null || it.getDate().before(d.getDateData())) {
                        it.setPrc(this.sbscorr.getFastCorr_PRC()[j]);
                        it.setDate(d.getDateData());
                        if (this.sbscorr.getFastCorr_UDREI()[j] != 0 && this.sbscorr.getFastCorr_UDREI()[j] <= 16) {
                            it.setUdrei(this.sbscorr.getFastCorr_UDREI()[j] - 1);
                        }
                    }
                    ++i;
                    ++j;
                }
            }
            this.message = "\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 " + this.df.format(d.getDateData());
        }
    }

    @Override
    protected void rebuildList() {
        this.lists = new ArrayList<FastCorrectionItem>(this.map.values());
        Collections.sort(this.lists, (a, b) -> a.getPrn().compareTo(b.getPrn()));
    }

    @ListField(fields={@Field(title="", order=20, propertiesLayout="1:3/fill/n/grow#grow#wrap", viewer={ListViewer.class}, content=FastCorrectionItem.class)})
    public List<FastCorrectionItem> getList() {
        return this.lists;
    }

    public void setList(List<FastCorrectionItem> list) {
        this.lists = list;
    }

    @Override
    public void cleardata() {
        this.map.clear();
        this.lists = null;
    }

    @Override
    protected List<String> getPackageNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("0x00");
        l.add("0x02");
        l.add("0x03");
        l.add("0x04");
        l.add("0x05");
        return l;
    }
}

