/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.sdcm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ru.blok.vms.ui.Sisnet;
import ru.blok.vms.ui.police.sdcm.IntegrityItem;
import ru.blok.vms.ui.police.sdcm.SDCMCommon;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.ws.objects.vms.entities.DataFromSatellites;

@ListView(views={@View(title="\u041c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u0438 \u0413\u041d\u0421\u0421", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class IntegrityMonitoring
extends SDCMCommon {
    HashMap<Integer, IntegrityItem> mapGPS = new HashMap();
    List<IntegrityItem> listsGPS;
    HashMap<Integer, IntegrityItem> mapGL = new HashMap();
    List<IntegrityItem> listsGL;

    public IntegrityMonitoring(String keyPage) {
        super(keyPage);
    }

    @Override
    protected List<String> getPackageNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("0x00");
        l.add("0x02");
        l.add("0x03");
        l.add("0x04");
        l.add("0x05");
        l.add("0x06");
        return l;
    }

    @Override
    public void setFileltedLoadData() {
    }

    @Override
    public void cleardata() {
        this.mapGL.clear();
        this.mapGPS.clear();
        this.listsGL = null;
        this.listsGPS = null;
    }

    @Override
    protected void loadDataNeedRebuild(DataFromSatellites d, Boolean[] needRefresh) {
        this.sbsmsg.message = d.getData();
        Sisnet.decode_msgtype(this.sbsmsg, this.sbscorr, this.sbsdegr, this.sbseph, this.sbsalm, this.sbsion, this.sbstime, this.sbsserv, this.sbscov);
        int code = this.sbsmsg.message[1] >>> 2 & 0x3F;
        if (code == 6) {
            int i = 0;
            while (i < this.sbscorr.getNumSat()) {
                int prn = this.sbscorr.getPRN()[i];
                IntegrityItem it = null;
                if (prn <= 37) {
                    it = this.mapGPS.get(prn);
                    if (it == null) {
                        needRefresh[0] = true;
                        it = new IntegrityItem();
                        it.setPrn(prn);
                        this.mapGPS.put(prn, it);
                    }
                } else {
                    it = this.mapGL.get(prn -= 37);
                    if (it == null) {
                        needRefresh[0] = true;
                        it = new IntegrityItem();
                        it.setPrn(prn);
                        this.mapGL.put(prn, it);
                    }
                }
                if (this.sbscorr.getFastCorr_UDREI()[i] != 0 && this.sbscorr.getFastCorr_UDREI()[i] <= 16) {
                    it.setUdrei(this.sbscorr.getFastCorr_UDREI()[i] - 1);
                }
                ++i;
            }
        } else if (code >= 2 && code <= 5 || code == 0) {
            int j;
            if (code == 0) {
                code = 2;
            }
            if ((j = (int)(13 * (code - 2))) < this.sbscorr.getNumSat()) {
                int i = 0;
                while (i < 13 && j < this.sbscorr.getNumSat()) {
                    int prn = this.sbscorr.getPRN()[j];
                    IntegrityItem it = null;
                    if (prn <= 37) {
                        it = this.mapGPS.get(prn);
                        if (it == null) {
                            needRefresh[0] = true;
                            it = new IntegrityItem();
                            it.setPrn(prn);
                            if (prn > 0) {
                                this.mapGPS.put(prn, it);
                            }
                        }
                    } else {
                        it = this.mapGL.get(prn -= 37);
                        if (it == null) {
                            needRefresh[0] = true;
                            it = new IntegrityItem();
                            it.setPrn(prn);
                            this.mapGL.put(prn, it);
                        }
                    }
                    if (it.getDate() == null || it.getDate().before(d.getDateData())) {
                        it.setDate(d.getDateData());
                        if (this.sbscorr.getFastCorr_UDREI()[j] != 0 && this.sbscorr.getFastCorr_UDREI()[j] <= 16) {
                            it.setUdrei(this.sbscorr.getFastCorr_UDREI()[j] - 1);
                        }
                    }
                    ++i;
                    ++j;
                }
            }
            this.message = "\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 " + this.df.format(d.getDateData());
        }
        this.message = "\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 " + this.df.format(d.getDateData());
    }

    @Override
    protected void rebuildList() {
        this.listsGPS = new ArrayList<IntegrityItem>(this.mapGPS.values());
        Collections.sort(this.listsGPS, (a, b) -> a.getPrn().compareTo(b.getPrn()));
        this.listsGL = new ArrayList<IntegrityItem>(this.mapGL.values());
        Collections.sort(this.listsGL, (a, b) -> a.getPrn().compareTo(b.getPrn()));
    }

    @ListField(fields={@Field(title="GPS", order=130, propertiesLayout="1:3/fill/n/grow#grow, cell 1 1#cell 1 0, growx", viewer={ListViewer.class}, content=IntegrityItem.class)})
    public List<IntegrityItem> getListsGPS() {
        return this.listsGPS;
    }

    @ListField(fields={@Field(title="\u0413\u041b\u041e\u041d\u0410\u0421\u0421", order=120, propertiesLayout="1:3/fill/n/grow#grow, cell 0 1#cell 0 0, growx", viewer={ListViewer.class}, content=IntegrityItem.class)})
    public List<IntegrityItem> getListsGL() {
        return this.listsGL;
    }
}

