/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.sdcm;

import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.Sisnet;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.layout.AbstractTabSplitPercentLayoutManager;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.AsyncBVA;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.RadioButtonViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.DataFromSatellitesWSProxy;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;
import ru.infor.ws.business.vms.websocket.DataFromSatellitesSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendListDataFromSatellites;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.DataFromSatellitesSearchCriteria;
import ru.infor.ws.objects.vms.entities.DataFromSatellites;

public abstract class SDCMCommon
extends CommonObjectWithKey
implements DataFromSatellitesSocketIntf {
    DataFromSatellitesWSProxy proxy = (DataFromSatellitesWSProxy)CurrentProxyFactory.getProxy(DataFromSatellites.class, (String)this.getKeyPage());
    DataFromSatellitesSearchCriteria sc;
    static String realTime = "\u0412 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438";
    static String onDate = "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043d\u0430 \u0434\u0430\u0442\u0443";
    private String type = onDate;
    String message;
    private Date date;
    DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    Sisnet.SBASMessageType sbsmsg = new Sisnet.SBASMessageType();
    Sisnet.SBASCorrectionsType sbscorr = new Sisnet.SBASCorrectionsType();
    Sisnet.SBASDegradationsType sbsdegr = new Sisnet.SBASDegradationsType();
    Sisnet.SBASEphemerisType sbseph = new Sisnet.SBASEphemerisType();
    Sisnet.SBASAlmanacsType sbsalm = new Sisnet.SBASAlmanacsType();
    Sisnet.SBASIonosphericType sbsion = new Sisnet.SBASIonosphericType();
    Sisnet.SBASTimeType sbstime = new Sisnet.SBASTimeType();
    Sisnet.SBASServiceType sbsserv = new Sisnet.SBASServiceType();
    Sisnet.SBASCovarianceType sbscov = new Sisnet.SBASCovarianceType();
    BeanViewerAction<ViewerContext> run = new AsyncBVA<Object, ViewerContext>((ctx, o) -> {
        this.connecting();
        return null;
    }, (o, ctx) -> {}, (o, c) -> {}){

        public String getName() {
            return "\u041d\u0430\u0447\u0430\u0442\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435";
        }
    };
    String sid;
    BeanViewerAction<ViewerContext> load = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            SDCMCommon.this.load();
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
    };
    PanelContext pc;

    public SDCMCommon(String keyPage) {
        super(keyPage);
        this.sc = new DataFromSatellitesSearchCriteria();
        this.sc.setSystemName("sdcm");
        this.setFileltedLoadData();
        this.date = new Date();
        Calendar c2 = Calendar.getInstance();
        c2.set(13, 0);
        c2.set(14, 0);
        this.sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        this.sc.appendSorting(SortObject.getInstance((String)"dateData", (String)SortObject.DIRECTION_ASC));
        this.sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
    }

    public abstract void setFileltedLoadData();

    @ListField(fields={@Field(title="", order=5, viewer={TypeViewer.class}, propertiesLayout="1/fill:0//n/spanx,wrap,grow 0, growy 0##cell 10 10", changeAction={ChangeType.class})})
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public abstract void cleardata();

    protected void loadfirstpackage(Date date) {
        DataFromSatellitesSearchCriteria sc = new DataFromSatellitesSearchCriteria();
        sc.setDateDataTill(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(10, -1);
        sc.setDateDataFrom(c.getTime());
        sc.setSystemName("sdcm");
        sc.setPackageName("0x01");
        sc.setCount(Integer.valueOf(1));
        sc.appendSorting(SortObject.getInstance((String)"dateData", (String)SortObject.DIRECTION_DESC));
        Object[] oo = this.proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), sc).getObjList();
        Calendar c2 = Calendar.getInstance();
        c2.setTime(c.getTime());
        c2.add(5, -10);
        while (oo == null && c2.getTimeInMillis() < c.getTimeInMillis()) {
            c.add(12, -50);
            oo = this.proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), sc).getObjList();
        }
        if (oo != null && oo.length > 0) {
            DataFromSatellites d = (DataFromSatellites)oo[0];
            this.sbsmsg.message = d.getData();
            Sisnet.decode_msgtype(this.sbsmsg, this.sbscorr, this.sbsdegr, this.sbseph, this.sbsalm, this.sbsion, this.sbstime, this.sbsserv, this.sbscov);
        }
    }

    public void load() {
        this.loadfirstpackage(this.date);
        this.sc.setDateDataTill(this.date);
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        c.add(12, -1);
        this.sc.setDateDataFrom(c.getTime());
        Object[] oo = this.proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), this.sc).getObjList();
        Calendar c2 = Calendar.getInstance();
        c2.setTime(c.getTime());
        c2.add(10, -24);
        while (oo == null && c2.getTimeInMillis() < c.getTimeInMillis()) {
            c.add(12, -5);
            oo = this.proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), this.sc).getObjList();
        }
        Boolean[] needRefresh = new Boolean[]{false};
        if (oo != null && oo.length > 0) {
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                DataFromSatellites d = (DataFromSatellites)o;
                this.sbsmsg.message = d.getData();
                Sisnet.decode_msgtype(this.sbsmsg, this.sbscorr, this.sbsdegr, this.sbseph, this.sbsalm, this.sbsion, this.sbstime, this.sbsserv, this.sbscov);
                this.loadDataNeedRebuild(d, needRefresh);
                ++n2;
            }
            if (needRefresh[0].booleanValue()) {
                this.rebuildList();
            }
        } else {
            this.message = "\u0414\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
        }
    }

    protected abstract void loadDataNeedRebuild(DataFromSatellites var1, Boolean[] var2);

    protected abstract void rebuildList();

    @ListField(fields={@Field(title="", order=10, viewer={DateWithoutButton.class}, propertiesLayout="1:0#w 100, cell 2 0# cell 1 0, grow 0", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ListField(fields={@Field(title=" ", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="1:0# w 200, wmin 150, cell 4 0#grow 0, cell 3 0", propertiesUI={"format=HH:mm:ss"})})
    public Date getTime() {
        return this.date;
    }

    public void setTime(Date date) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDate());
        c2.setTime(date);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.date = c1.getTime();
    }

    protected abstract List<String> getPackageNames();

    public void connecting() {
        this.loadfirstpackage(new Date());
        SubscribingOptions_SendListDataFromSatellites options = new SubscribingOptions_SendListDataFromSatellites();
        options.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        options.setServiceName("DataFromSatellitesWS");
        options.setMethodName("sendData");
        options.setSystemName("sdcm");
        options.setPackageNames(this.getPackageNames());
        options.getPackageNames().add("0x01");
        options.setSid(this.sid);
        try {
            this.sid = SocketClientFactory.subscribe((Object)((Object)this), (SubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.sid != null) {
            UnsubscribingOptions optionsU = new UnsubscribingOptions();
            optionsU.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
            optionsU.setServiceName("DataFromSatellitesWS");
            optionsU.setMethodName("sendData");
            optionsU.setSid(this.sid);
            try {
                SocketClientFactory.unsubscribe((UnsubscribingOptions)optionsU, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
            }
            catch (Exception exception) {}
        }
    }

    @ListField(fields={@Field(title=" ", order=30, viewer={ActionButton.class}, propertiesLayout="1:0#cell 2 1#cell 1 1, grow 0")})
    public BeanViewerAction<ViewerContext> getRun() {
        return this.run;
    }

    @ListField(fields={@Field(title=" ", order=30, viewer={ActionButton.class}, propertiesLayout="1:0#cell 6 0#cell 5 0, grow 0")})
    public BeanViewerAction<ViewerContext> getLoad() {
        return this.load;
    }

    @ListField(fields={@Field(title=" ", order=40, propertiesLayout="1:0#w 800, cell 8 0#cell 7 0, grow 0", readOnly=true)})
    public String getMessage() {
        return this.message;
    }

    public void beforeShow(PanelContext pc) {
        this.pc = pc;
    }

    public void sendData(List<DataFromSatellites> list) {
        Boolean[] needRefresh = new Boolean[]{false};
        for (DataFromSatellites d : list) {
            this.sbsmsg.message = d.getData();
            Sisnet.decode_msgtype(this.sbsmsg, this.sbscorr, this.sbsdegr, this.sbseph, this.sbsalm, this.sbsion, this.sbstime, this.sbsserv, this.sbscov);
            int code = this.sbsmsg.message[1] >>> 2 & 0x3F;
            if (code == 1) continue;
            this.loadDataNeedRebuild(d, needRefresh);
        }
        if (needRefresh[0].booleanValue()) {
            this.rebuildList();
        }
        this.pc.getPanel().updateUI();
    }

    public void beforeDestroy(PanelContext pc) {
        this.close();
    }

    public static class ChangeType
    extends ActionCalculatedObject {
        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(((ViewerContext)this.getContext()).getPresentator());
            Object o = ((ViewerContext)this.getContext()).getPresentator().getViewer().getValue();
            boolean rt = true;
            if (onDate.equals(o)) {
                rt = false;
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("date").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("time").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("load").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("message").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("run").getViewer().setEditable(rt);
            if (!initializing) {
                if (!rt) {
                    ((SDCMCommon)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getObject())).close();
                }
                ((SDCMCommon)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getObject())).cleardata();
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
            }
        }
    }

    public static class TypeViewer<T>
    extends RadioButtonViewer<T> {
        List<String> l;

        public TypeViewer(UIFactory<T> factory) {
            super(factory);
        }

        public List<?> getRadioElement() {
            this.l = new ArrayList<String>();
            this.l.add(onDate);
            this.l.add(realTime);
            return this.l;
        }

        public void setValue(Object object) {
            super.setValue(object);
            HashMap map = super.getMapComponent();
            JPanel p = (JPanel)((AbstractTabSplitPercentLayoutManager)((PanelContext)this.getViewerContext().getParentContext()).getPanel().getLayout()).getComponentForName("1:0");
            for (String c : this.l) {
                Object t = map.get(c);
                String cons = "";
                if (onDate.equals(c)) {
                    cons = "cell 0 0, grow 0";
                } else if (realTime.equals(c)) {
                    cons = "cell 0 1, grow 0";
                }
                p.add((Component)t, cons);
            }
            p.revalidate();
        }
    }
}

