/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherAdapter;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.util.RunnableQueue;
import org.jxmapviewer.viewer.GeoPosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import ru.blok.vms.ui.police.operationalinformation.ObjectToView;
import ru.blok.vms.ui.police.svg.ClickImage;
import ru.infor.common.SysProperties;

public class IconOnMap {
    public static String svgPrefix = "";
    String image;
    GeoPosition point;
    List<String> prop;
    SVGDocument doc;
    int h;
    int w;
    ClickImage cim;
    Image img;
    protected Long id;
    protected boolean show = true;
    protected boolean select = false;
    protected JSVGCanvas canvas;
    protected RunnableQueue queue;
    protected boolean onClickWasSet = false;
    String icon;

    static {
        String cacheDataFolder = SysProperties.getProperty((String)"path.svg.image", (String)"");
        if (!cacheDataFolder.trim().equals("")) {
            cacheDataFolder = String.valueOf(cacheDataFolder) + File.separator;
        }
        svgPrefix = String.valueOf(cacheDataFolder) + File.separator;
    }

    public Image getImg() {
        return this.img;
    }

    public void setImg(Image img) {
        this.img = img;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public List<String> getProp() {
        return this.prop;
    }

    public void setProp(List<String> prop) {
        this.prop = prop;
    }

    public SVGDocument getDoc() {
        return this.doc;
    }

    public void loadImage() {
        this.doc = ObjectToView.loadImage(this.image);
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public GeoPosition getPoint() {
        return this.point;
    }

    public void setPoint(GeoPosition point) {
        this.point = point;
    }

    public void changeColor(Integer color) {
        if (this.doc != null) {
            this.img = null;
            Element e = this.doc.getElementById("pathChange");
            if (e != null) {
                String s = e.getAttribute("style");
                int k = s.indexOf("fill:#");
                StringBuilder r = new StringBuilder();
                if (k > 0) {
                    r.append(s.substring(0, k - 1));
                }
                r.append("fill:#").append(Integer.toHexString(color).substring(2)).append(s.substring(k + 12));
                e.setAttribute("style", r.toString());
            }
        }
    }

    public boolean isSelect() {
        return this.select;
    }

    public void dispose() {
        this.canvas.dispose();
        if (this.canvas.getParent() != null) {
            this.canvas.getParent().remove((Component)this.canvas);
        }
    }

    public Long getId() {
        return this.id;
    }

    public IconOnMap(String image, GeoPosition point, int h, int w, final Long id, ClickImage cim) {
        this.image = image;
        this.point = point;
        this.h = h;
        this.w = w;
        this.loadImage();
        this.cim = cim;
        this.canvas = new JSVGCanvas();
        this.canvas.setDocumentState(1);
        this.canvas.setDocument((Document)this.doc);
        String ww = this.doc.getRootElement().getAttribute("width");
        String hh = this.doc.getRootElement().getAttribute("height");
        this.canvas.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
        this.canvas.setBackground(new Color(0, 0, 0, 0));
        this.canvas.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)new SVGLoadEventDispatcherAdapter(){

            public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
                Element elt;
                EventTarget t;
                IconOnMap.this.queue = IconOnMap.this.canvas.getUpdateManager().getUpdateRunnableQueue();
                if (!IconOnMap.this.onClickWasSet && (t = (EventTarget)((Object)(elt = IconOnMap.this.canvas.getSVGDocument().getElementById("gMainGroup")))) != null && id != null) {
                    t.addEventListener("pathChange", new OnClickAction(id), false);
                    IconOnMap.this.onClickWasSet = true;
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.canvas;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public void reload() {
        this.canvas.setDocument((Document)this.doc);
        this.canvas.repaint();
    }

    public class OnClickAction
    implements EventListener {
        private long id;

        public OnClickAction(long id) {
            this.id = id;
        }

        @Override
        public void handleEvent(Event evt) {
            if (IconOnMap.this.cim != null) {
                IconOnMap.this.cim.select(this.id);
            }
        }
    }
}

