/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.police.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.jxmapviewer.JXMapViewer;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.police.svg.IconOnMap;

public class SVGPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    List<IconOnMap> listIcons = new ArrayList<IconOnMap>();

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        for (IconOnMap m : this.listIcons) {
            int y;
            int x;
            Point2D point = map.getTileFactory().geoToPixel(m.getPoint(), map.getZoom());
            if (vp2.contains(point)) {
                x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                try {
                    if (m.getImg() == null) {
                        m.setImg(SVGPainter.loadImage(m.getDoc(), m.getW(), m.getH()));
                    }
                    g.drawImage(m.getImg(), x - m.getW() / 2, y - m.getH() / 2, (ImageObserver)map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!vp3.contains(point)) continue;
            x = (int)(point.getX() - ((RectangularShape)vp3).getX());
            y = (int)(point.getY() - ((RectangularShape)vp3).getY());
            try {
                if (m.getImg() == null) {
                    m.setImg(SVGPainter.loadImage(m.getDoc(), m.getW(), m.getH()));
                }
                g.drawImage(m.getImg(), x - m.getW() / 2, y - m.getH() / 2, (ImageObserver)map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static BufferedImage loadImage(SVGDocument svg, float width, float height) throws TranscoderException {
        BufferedImageTranscoder imageTranscoder = new BufferedImageTranscoder();
        imageTranscoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, Float.valueOf(width));
        imageTranscoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, Float.valueOf(height));
        TranscoderInput input = new TranscoderInput((Document)svg);
        imageTranscoder.transcode(input, null);
        return imageTranscoder.getBufferedImage();
    }

    public List<IconOnMap> getListIcons() {
        return this.listIcons;
    }

    public void addIconOnMap(IconOnMap m) {
        this.listIcons.add(m);
    }

    public void removeIconOnMap(IconOnMap m) {
        this.listIcons.remove(m);
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }

    public static class BufferedImageTranscoder
    extends ImageTranscoder {
        private BufferedImage img = null;

        public BufferedImage createImage(int w, int h) {
            BufferedImage bi = new BufferedImage(w, h, 2);
            return bi;
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) {
            this.img = img;
        }

        public BufferedImage getBufferedImage() {
            return this.img;
        }
    }
}

