/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.powerline;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import ru.blok.vms.ui.roads.actions.BuildRoute;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.ws.objects.energy.entities.ext.PowerLineItemsExt;

public class PowerLineItemsChange
extends ActionCalculatedObject {
    public void actionPerformed(Object message) {
        FieldPresentation fp = ((ViewerContext)this.getContext()).getPresentator();
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(fp);
        FieldPresentation fpLength = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("length");
        List itemsList = (List)((ViewerContext)this.getContext()).getObject();
        Double len = PowerLineItemsChange.calcLength(itemsList);
        System.out.println(" len=" + len);
        fpLength.getViewer().setValue((Object)len);
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(fpLength);
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("length");
    }

    public static Double calcLength(List<PowerLineItemsExt> itemsList) {
        Collections.sort(itemsList, new Comparator<PowerLineItemsExt>(){

            @Override
            public int compare(PowerLineItemsExt o1, PowerLineItemsExt o2) {
                return o1.getIndex().compareTo(o2.getIndex());
            }
        });
        Double len = 0.0;
        if (itemsList == null || itemsList.size() == 0) {
            return len;
        }
        GeometryFactory f = new GeometryFactory();
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)BuildRoute.wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)BuildRoute.wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            GeneralDirectPosition pt1 = new GeneralDirectPosition(itemsList.get(0).getLon().doubleValue(), itemsList.get(0).getLat().doubleValue());
            DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
            Coordinate c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
            Point p_old = f.createPoint(c);
            int i = 1;
            while (i < itemsList.size()) {
                pt1 = new GeneralDirectPosition(itemsList.get(i).getLon().doubleValue(), itemsList.get(i).getLat().doubleValue());
                pt2 = math.transform((DirectPosition)pt1, null);
                c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                Point pp = f.createPoint(c);
                len = len + p_old.distance((Geometry)pp) / 1000.0 / 2.0;
                p_old = pp;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return len;
    }
}

