/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.powerline.geompl;

import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.powerline.PowerLineItemsChange;
import ru.blok.vms.ui.powerline.geompl.MapValue;
import ru.blok.vms.ui.powerline.geompl.NewPowerItemPainter;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.ws.objects.energy.entities.ext.PowerLineExt;
import ru.infor.ws.objects.energy.entities.ext.PowerLineItemsExt;

public class MapViewerPowerItems
extends MapViewer {
    NewPowerItemPainter<JXMapViewer> routePainter2;

    public MapViewerPowerItems(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.routePainter2 = new NewPowerItemPainter();
        this.painter.addPainter(this.routePainter2);
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected void mouseClickedOnMap(double x, double y, GeoPosition gp, MouseEvent e) {
        super.mouseClickedOnMap(x, y, gp, e);
        if (e.getClickCount() == 2) {
            if (((MapValue)this.getValue()).powerLineExt == null) {
                ((MapValue)this.getValue()).setPowerLineExt(new PowerLineExt());
            }
            ((MapValue)this.getValue()).powerLineExt.addItems(gp, (PanelContext)this.getViewerContext().getParentContext(), e.isControlDown());
            Double len = PowerLineItemsChange.calcLength(((MapValue)this.getValue()).powerLineExt.getItemsList());
            System.out.println(len);
            PowerLineExt obj = (PowerLineExt)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            obj.setLength(len);
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateMainObject();
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("length");
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("itemsList");
            this.repaint();
        }
    }

    @Override
    protected MapValue getNewInstance(double lat, double lon, int zoom) {
        return new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.getValue() != null && ((MapValue)this.getValue()).getPowerLineExt() != null) {
            List<PowerLineItemsExt> list = ((MapValue)this.getValue()).getPowerLineExt().getItemsList();
            int i = 0;
            while (i < list.size()) {
                double lat = list.get(i).getLat();
                double lon = list.get(i).getLon();
                if (minLat == null || lat < minLat) {
                    minLat = lat;
                }
                if (maxLat == null || lat > maxLat) {
                    maxLat = lat;
                }
                if (minLon == null || lon < minLon) {
                    minLon = lon;
                }
                if (maxLon == null || lon > maxLon) {
                    maxLon = lon;
                }
                ++i;
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(arg0);
        this.routePainter2.setValue((MapValue)arg0);
        this.zoomToTracks();
    }
}

