/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.powerline.geompl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.powerline.geompl.MapValue;
import ru.infor.ws.objects.energy.entities.ext.PowerLineItemsExt;

public class NewPowerItemPainter<T extends JXMapViewer>
extends MapViewPainter<JXMapViewer> {
    MapValue value;
    public static Stroke defaultStroke = new BasicStroke(2.0f, 1, 1);
    public static Stroke defaultStrokeSelect = new BasicStroke(6.0f, 1, 1);

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        List<PowerLineItemsExt> lists;
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.value != null && this.value.getPowerLineExt() != null && (lists = this.value.getPowerLineExt().getItemsList()).size() > 0) {
            PowerLineItemsExt select = this.value.getPowerLineExt().getSelect();
            int from = 0;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(lists.get(from).getLat().doubleValue(), lists.get(from).getLon().doubleValue()), map.getZoom());
            boolean sel = select != null && select.getIndex().equals(lists.get(from).getIndex());
            this.paintPoint(g, map, vp2, vp3, pointFrom, sel);
            ++from;
            int i = 1;
            while (i < lists.size()) {
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(lists.get(i).getLat().doubleValue(), lists.get(i).getLon().doubleValue()), map.getZoom());
                this.paint(pointFrom, pointTo, map, g, vp2, vp3, Color.RED, false);
                from = i;
                pointFrom = pointTo;
                sel = select != null && select.getIndex().equals(lists.get(from).getIndex());
                this.paintPoint(g, map, vp2, vp3, pointTo, sel);
                ++i;
            }
        }
    }

    protected void paint(Point2D pointFrom, Point2D point, JXMapViewer map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, boolean select) {
        g.setColor(c);
        if (select) {
            g.setStroke(defaultStrokeSelect);
        } else {
            g.setStroke(defaultStroke);
        }
        g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
    }

    public void paintPoint(Graphics2D g, JXMapViewer map, Rectangle2D vp2, Rectangle2D vp3, Point2D point, boolean select) {
        int x = (int)(point.getX() - vp2.getX());
        int y = (int)(point.getY() - vp2.getY());
        g.translate(x, y);
        if (!select) {
            g.setColor(Color.RED);
            g.fillOval(-3, -3, 6, 6);
        } else {
            g.setColor(Color.BLUE);
            g.fillOval(-5, -5, 10, 10);
        }
        g.translate(-x, -y);
    }

    public void setValue(MapValue mapValueWithTrack) {
        this.value = mapValueWithTrack;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

