/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.rdsrvoperation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import ru.blok.cartography.core.Utils;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.event.ListEventsViewer;
import ru.blok.vms.ui.event.ObjectUIListWithAutoRefresh;
import ru.blok.vms.ui.rdsrvoperation.ChangeListOperation;
import ru.blok.vms.ui.rdsrvoperation.EventMessage;
import ru.blok.vms.ui.rdsrvoperation.ListViewerOperation;
import ru.blok.vms.ui.rdsrvoperation.ParametersOperationViewer;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.client.soap.proxy.vms.EventUIWSProxy;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.client.soap.proxy.vms.RDSrvOperationWSProxy;
import ru.infor.common.FileUtils;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;
import ru.infor.ws.business.vms.websocket.EventSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.DeviceCommand;
import ru.infor.ws.business.vms.websocket.objects.DeviceCommandParam;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendEventUI;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.events.EventSearchCriteria;
import ru.infor.ws.objects.events.EventUI;
import ru.infor.ws.objects.rds.RDSrvOperationSearchCriteria;
import ru.infor.ws.objects.rds.entities.RDSrvOperation;
import ru.infor.ws.objects.vms.NavigationDeviceUI;
import ru.infor.ws.objects.vms.TransportUI;
import ru.infor.ws.objects.vms.entities.NavigationDevice;

@ListView(views={@View(title="\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", actions={@ActionViewer(clazz=PanelContext.CancelButton.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class CommandSendForm
extends CommonObjectWithKey {
    static Logger logger = Logger.getLogger(CommandSendForm.class);
    static SecurityWSProxy securityProxy = new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection());
    RDSrvOperationWSProxy proxy = (RDSrvOperationWSProxy)CurrentProxyFactory.getProxy(RDSrvOperation.class, (String)this.getKeyPage());
    RDSrvOperationSearchCriteria criteria = new RDSrvOperationSearchCriteria();
    String ts_regnum;
    String nd_code_type;
    String code_type;
    RDSrvOperation operation;
    Object[] params;
    List<EventUI> events;
    String sidInitiator;
    Long initiatorId;
    List<Long> initiatorIdList;
    Long closingTimeOfMessageWindow = 10L;
    EventUIWSProxy eventProxy = (EventUIWSProxy)CurrentProxyFactory.getProxy(EventUI.class, (String)this.getKeyPage());
    EventSearchCriteria eventSC = new EventSearchCriteria();
    HashMap<String, String> sp = null;
    BeanViewerAction<ViewerContext> sendCommand = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            DeviceCommandParam[] pars = (DeviceCommandParam[])CommandSendForm.this.params[1];
            if (pars != null && pars.length > 0) {
                int i = 0;
                while (i < pars.length) {
                    if (pars[i].getKey().toLowerCase().startsWith("file_name")) {
                        logger.debug((Object)("uploadFile out=" + pars[i].getValue()));
                    }
                    ++i;
                }
            }
            DeviceCommand[] arrDC = new DeviceCommand[CommandSendForm.this.getInitiatorIdList().size()];
            int j = 0;
            while (j < CommandSendForm.this.getInitiatorIdList().size()) {
                DeviceCommand dc = new DeviceCommand();
                dc.setCommandCode(CommandSendForm.this.getOperation().getName().getCode());
                dc.setDeviceId(CommandSendForm.this.getInitiatorIdList().get(j));
                dc.setParams(pars);
                arrDC[j] = dc;
                ++j;
            }
            NavigationDeviceWSProxy proxy = (NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class, (String)CommandSendForm.this.getKeyPage());
            proxy.sendListCommands(InitializedVariable.getContext((String)CommandSendForm.this.getKeyPage()), arrDC);
        }
    };
    PanelContext pc;

    public CommandSendForm(String keyPage, List<TransportUI> ts, List<NavigationDeviceUI> nd) {
        super(keyPage);
        this.criteria.setCount(Integer.valueOf(Integer.MAX_VALUE));
        if (this.sp == null) {
            this.sp = InitializedVariable.runtimeParameters((String)keyPage, (Long)InitializedVariable.getWorkplaceId((String)keyPage));
            if (this.sp.get("ClosingTimeOfMessageWindow") != null) {
                try {
                    this.closingTimeOfMessageWindow = Long.valueOf(this.sp.get("ClosingTimeOfMessageWindow"));
                }
                catch (Exception exception) {
                    this.closingTimeOfMessageWindow = 11L;
                }
            }
        }
        this.ts_regnum = " \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
        if (ts != null && ts.size() > 0) {
            this.ts_regnum = ts.stream().sorted((s1, s2) -> s1.getRegNum().compareTo(s2.getRegNum())).map(mm -> mm.getRegNum()).collect(Collectors.joining(", "));
        }
        this.code_type = nd.get(0).getDeviceType().getCode();
        this.nd_code_type = nd.get(0).getDeviceType().getDescription().concat(": ").concat(nd.stream().sorted((s1, s2) -> s1.getCode().compareTo(s2.getCode())).map(mm -> mm.getCode()).collect(Collectors.joining(", ")));
        ArrayList<Long> idList = new ArrayList<Long>();
        int i = 0;
        while (i < nd.size()) {
            idList.add(nd.get(i).getId());
            ++i;
        }
        this.setInitiatorIdList(idList);
        this.initEvents();
        this.connectedEventUI();
    }

    @ListField(fields={@Field(title="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", order=10, propertiesLayout="Split1/v/l/0.5:0/wrap 1/#cell 3 0, w 800 # cell 2 0", readOnly=true, propertiesUI={"background=#FFFFE1"})})
    public String getTs_regnum() {
        return this.ts_regnum;
    }

    public void setTs_regnum(String ts_regnum) {
        this.ts_regnum = ts_regnum;
    }

    @ListField(fields={@Field(title="\u041e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u0435", order=20, propertiesLayout="Split1/v/l/0.5:0#cell 3 1,w 800  # cell 2 1", readOnly=true, propertiesUI={"background=#FFFFE1"})})
    public String getNd_code_type() {
        return this.nd_code_type;
    }

    public void setNd_code_type(String nd_code_type) {
        this.nd_code_type = nd_code_type;
    }

    @ListField(fields={@Field(title="\u041a\u043e\u043c\u0430\u043d\u0434\u0430", order=30, propertiesLayout="Split1/v/l/0.5:0#cell 3 2, w 800 # cell 2 2", readOnly=false, viewer={ListViewerOperation.class}, changeAction={ChangeListOperation.class})})
    public RDSrvOperation getOperation() {
        return this.operation;
    }

    public void setOperation(RDSrvOperation operation) {
        this.operation = operation;
    }

    @ListField(fields={@Field(title="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", order=30, propertiesLayout="Split1/v/l/0.5:0#cell 2 4 2, w 800, h 300 # cell 2 3 2", readOnly=false, viewer={ParametersOperationViewer.class})})
    public Object[] getParams() {
        return this.params;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    @ListField(fields={@Field(title="", order=1000, viewer={ActionButton.class}, propertiesLayout="Split1/v/l/0.5:0#cell 3 10, w 800 # cell 2 10")})
    public BeanViewerAction<ViewerContext> getShowTransitKP() {
        return this.sendCommand;
    }

    @ListField(fields={@Field(title="\u0416\u0443\u0440\u043d\u0430\u043b \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439", order=300, propertiesLayout="Split1/v/r/0.5", propertiesField={"className=ru.infor.ws.objects.events.EventUI"}, viewer={ListEventsViewer.class}, panels={}, content=EventUI.class)})
    public List<EventUI> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventUI> events) {
        this.events = events;
    }

    public List<Long> getInitiatorIdList() {
        return this.initiatorIdList;
    }

    public void setInitiatorIdList(List<Long> initiatorIdList) {
        this.initiatorIdList = initiatorIdList;
    }

    private String uploadFile(String value) {
        logger.debug((Object)("uploadFile in=" + value));
        try {
            String zipFile = Utils.zipFiles(new String[]{value});
            File file = new File(zipFile);
            String urlString = securityProxy.getUploadURL(InitializedVariable.getContext((String)this.getKeyPage()));
            String urlStr = String.valueOf(urlString) + "/?name=" + file.getName();
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            OutputStream out = conn.getOutputStream();
            FileUtils.copy((File)file.getAbsoluteFile(), (OutputStream)new BufferedOutputStream(out));
            conn.getInputStream();
            conn.disconnect();
            return file.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            InitializedVariable.getFactory((String)this.getKeyPage()).runMessageEx((Object)new ErrorMessage("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430"), new BeanViewerAction[]{new MessageOKButton()});
            return null;
        }
    }

    public void initEvents() {
        this.events = new ObjectUIListWithAutoRefresh<EventUI>(EventUI.class, this.getKeyPage());
        this.eventSC = (EventSearchCriteria)((ObjectUIList)this.events).getSearchCriteria();
        this.eventSC.appendSorting(SortObject.getInstance((String)"importanceEvent.code", (String)SortObject.DIRECTION_DESC));
        this.eventSC.appendSorting(SortObject.getInstance((String)"eventDate", (String)SortObject.DIRECTION_DESC));
        this.eventSC.setEventDateFrom(CommonSearchCriteria.beginOfDay((Date)new Date()));
        this.eventSC.setEventDateTill(CommonSearchCriteria.endOfDay((Date)new Date()));
        this.eventSC.setInitiatorIdList(this.initiatorIdList.toArray(new Long[this.initiatorIdList.size()]));
    }

    public void beforeShow(PanelContext pc) {
        this.pc = pc;
        ArrayList<RDSrvOperation> listOperation = new ArrayList<RDSrvOperation>();
        if (this.code_type != null && !this.code_type.trim().equals("")) {
            this.criteria.setDeviceTypeName(this.code_type);
            RDSrvOperationWSProxy.SearchResultListRDSrvOperation sr = this.proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), this.criteria);
            if (!sr.isEmpty()) {
                int i = 0;
                while (i < sr.getObjList().length) {
                    RDSrvOperation o = this.proxy.getCurrentObject(InitializedVariable.getContext((String)this.getKeyPage()), ((RDSrvOperation)sr.getObjList()[i]).getId());
                    listOperation.add(o);
                    ++i;
                }
            }
        }
        ListViewerOperation v = (ListViewerOperation)pc.getPanel().getPresentatorForName("operation").getViewer();
        v.setList(listOperation);
        pc.getPanel().updateUIForPresentatorName("operation");
    }

    public void beforeDestroy(PanelContext pc) {
        this.closeEventUI();
    }

    public void closeEventUI() {
        UnsubscribingOptions optionsU = new UnsubscribingOptions();
        optionsU.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        optionsU.setServiceName("EventWS");
        optionsU.setMethodName("sendEvent");
        optionsU.setSid(this.sidInitiator);
        try {
            SocketClientFactory.unsubscribe((UnsubscribingOptions)optionsU, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void connectedEventUI() {
        SubscribingOptions_SendEventUI options = new SubscribingOptions_SendEventUI();
        options.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        options.setServiceName("EventWS");
        options.setMethodName("sendEvent");
        options.setDeviceIdList(this.initiatorIdList);
        try {
            this.sidInitiator = SocketClientFactory.subscribe((Object)new EventListener(), (SubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runMessage(EventUI eventUI) {
        EventMessage m = new EventMessage(eventUI);
        final ViewerContext vc = new ViewerContext();
        InitializedVariable.getFactory((String)this.getKeyPage()).newWindow(m.getClass(), m.getClass(), (Object)m, vc, "", "MessageFromRealEvent" + eventUI.getId(), false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(CommandSendForm.this.closingTimeOfMessageWindow * 1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                InitializedVariable.getFactory((String)CommandSendForm.this.getKeyPage()).close(vc.getKeyPage());
            }
        }).start();
    }

    public final class EventListener
    implements EventSocketIntf {
        public void sendEvent(List<EventUI> data) {
            for (EventUI e : data) {
                if (e.getMessage().indexOf("004:") <= -1) continue;
                CommandSendForm.this.runMessage(e);
            }
            ((ObjectUIListWithAutoRefresh)((Object)CommandSendForm.this.events)).getNewsData();
        }
    }
}

