/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.rdsrvoperation;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.lib.misc.CalendarEx;
import ru.infor.ws.business.vms.websocket.objects.DeviceCommandParam;
import ru.infor.ws.objects.rds.entities.RDSrvOperationParam;

public class ParametersOperationViewer
extends FieldViewer<JComponent>
implements SwingItem {
    JPanel panel;
    JScrollPane pane;
    Object[] value;
    RDSrvOperationParam[] v1;
    public static int STRINGTYPE = 0;
    public static int NUMBERTYPE = 1;
    public static int DATETYPE = 2;
    List<Param> list = new ArrayList<Param>();
    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public ParametersOperationViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.panel = new JPanel((LayoutManager)new MigLayout("wrap 2"));
        this.pane = new JScrollPane(this.panel);
    }

    public int getShape() {
        return 1;
    }

    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.pane;
    }

    public Object getValue() {
        this.value = new Object[]{this.v1, this.readValues()};
        return this.value;
    }

    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
    }

    public void setValue(Object object) {
        this.value = (Object[])object;
        this.v1 = this.value != null && this.value.length > 0 ? (RDSrvOperationParam[])this.value[0] : null;
        this.revalidate();
    }

    public DeviceCommandParam[] readValues() {
        if (this.list.size() > 0) {
            DeviceCommandParam[] v = new DeviceCommandParam[this.list.size()];
            int i = 0;
            while (i < this.list.size()) {
                Param p = this.list.get(i);
                DeviceCommandParam vp = new DeviceCommandParam();
                vp.setKey(p.key);
                if (p.type == DATETYPE) {
                    vp.setValue(this.df.format(p.calendarEx.getDate()));
                } else {
                    vp.setValue(p.t.getText());
                }
                v[i] = vp;
                ++i;
            }
            return v;
        }
        return null;
    }

    public void revalidate() {
        this.panel.removeAll();
        this.list.clear();
        if (this.v1 != null) {
            RDSrvOperationParam[] rDSrvOperationParamArray = this.v1;
            int n = this.v1.length;
            int n2 = 0;
            while (n2 < n) {
                JTextField t;
                RDSrvOperationParam param = rDSrvOperationParamArray[n2];
                this.panel.add((Component)this.getFactory().getLabel(param.getDescription()), "");
                Param p = new Param();
                p.key = param.getCode();
                if ("EndOfPeriod".equals(param.getCode()) || "BeginningOfPeriod".equals(param.getCode())) {
                    CalendarEx dateEx = new CalendarEx();
                    dateEx.setDateFormat(this.df);
                    this.panel.add((Component)dateEx, "w 400");
                    p.type = DATETYPE;
                    p.calendarEx = dateEx;
                } else if (param.getCode().toLowerCase().startsWith("filename")) {
                    t = (JTextField)this.getFactory().getTextField();
                    this.panel.add((Component)t, "w 400, split 2");
                    p.t = t;
                    JButton b = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
                    this.panel.add((Component)b, "growx 0");
                    b.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FileFilter ff = null;
                            int type = 0;
                            String fn = t.getText();
                            File dest = ParametersOperationViewer.this.getFactory().runFileChooser(fn == null || fn.equals("") ? null : new File(fn), type, ff);
                            if (dest != null) {
                                t.setText(dest.getAbsolutePath());
                            }
                        }
                    });
                } else {
                    t = (JTextField)this.getFactory().getTextField();
                    this.panel.add((Component)t, "w 400");
                    p.t = t;
                    if ("DataTransferPeriod".equals(param.getCode()) || "NumAudioFile".equals(param.getCode()) || "port".equals(param.getCode())) {
                        p.type = NUMBERTYPE;
                    }
                }
                this.list.add(p);
                ++n2;
            }
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    public static class Param {
        int type = STRINGTYPE;
        CalendarEx calendarEx;
        JTextField t;
        String key;
    }
}

